(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1385870,      40589]
NotebookOptionsPosition[   1278505,      37342]
NotebookOutlinePosition[   1279913,      37389]
CellTagsIndexPosition[   1279870,      37386]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Symbolic Integration Problems",
  FontFamily->"Arial",
  FontSize->30],
 StyleBox["\n",
  FontSize->36],
 "from ",
 StyleBox["Integration of Functions",
  FontSlant->"Italic"],
 " (1948) ",
 StyleBox["by A. F. Timofeev",
  FontFamily->"Arial"]
}], "Title",
 CellChangeTimes->{{3.5886195227027745`*^9, 3.5886195238027763`*^9}, {
   3.5887010164543858`*^9, 3.588701026194399*^9}, {3.5897339881924467`*^9, 
   3.5897339888144827`*^9}, {3.595089073550669*^9, 3.5950890759548063`*^9}, 
   3.5950891271777363`*^9, {3.5950892054412127`*^9, 3.595089222926213*^9}, 
   3.5950893027827806`*^9, {3.5952746704077997`*^9, 3.5952746710978007`*^9}, {
   3.595274772707943*^9, 3.5952748115779977`*^9}, {3.596562962373578*^9, 
   3.596562973673594*^9}, {3.596563007163641*^9, 3.596563008163642*^9}, {
   3.5965630583737125`*^9, 3.5965630598837147`*^9}, {3.5965633721961527`*^9, 
   3.5965634059062004`*^9}},
 TextAlignment->Center,
 FontSize->24],

Cell[TextData[{
 "\nThe following is a list of the 705 example integration problems from the \
nine chapters in A. F. Timofeev\[CloseCurlyQuote]s 1948 book ",
 StyleBox["Integration of Functions",
  FontSlant->"Italic"],
 ".  Each integral along with its optimal antiderivative (that is, the best \
antiderivative found so far) is shown.\n"
}], "Text",
 CellChangeTimes->{
  3.5886189068119125`*^9, {3.58861906950214*^9, 3.5886190703121414`*^9}, {
   3.5886195084127545`*^9, 3.588619509992757*^9}, 3.5886196072128925`*^9, 
   3.5886198992533016`*^9, {3.5886212962303343`*^9, 3.588621299150338*^9}, {
   3.5886213296078815`*^9, 3.5886213385678935`*^9}, {3.588621374507944*^9, 
   3.5886214756080856`*^9}, {3.588621528088159*^9, 3.588621535128169*^9}, {
   3.588621573865723*^9, 3.588621590845747*^9}, {3.588621653865835*^9, 
   3.5886217703759985`*^9}, {3.5886218334935865`*^9, 3.588622007521331*^9}, {
   3.5886220724114213`*^9, 3.588622118126486*^9}, {3.58862217126906*^9, 
   3.5886222171991243`*^9}, {3.5886235455059843`*^9, 
   3.5886236836461782`*^9}, {3.588623740736258*^9, 3.5886238162263637`*^9}, {
   3.5886238524864144`*^9, 3.588623855206418*^9}, {3.5886280728173027`*^9, 
   3.5886281594910545`*^9}, {3.588628203919933*^9, 3.588628233481985*^9}, {
   3.5886282737924557`*^9, 3.588628379326641*^9}, {3.5886284235215187`*^9, 
   3.5886284269379244`*^9}, {3.588628775590137*^9, 3.5886287930933676`*^9}, {
   3.588628903657174*^9, 3.5886289545600634`*^9}, {3.588628996492937*^9, 
   3.5886290349626045`*^9}, {3.588629402238849*^9, 3.588629407917259*^9}, {
   3.58870041867352*^9, 3.5887004655035853`*^9}, {3.5887005238536673`*^9, 
   3.588700526713671*^9}, {3.5887007494190025`*^9, 3.5887007650990243`*^9}, {
   3.588700895734216*^9, 3.588700911124238*^9}, {3.588700952624296*^9, 
   3.5887009687243185`*^9}, {3.588703223772586*^9, 3.588703282340171*^9}, {
   3.5887237591258454`*^9, 3.5887239810661564`*^9}, 3.5897338152735567`*^9, {
   3.589733908996917*^9, 3.5897339445289493`*^9}, {3.589734048418892*^9, 
   3.5897340564663515`*^9}, {3.5897488162871604`*^9, 
   3.5897488410805783`*^9}, {3.5900072974915514`*^9, 
   3.5900073627252827`*^9}, {3.5900090956493998`*^9, 
   3.5900091322864957`*^9}, {3.59284888697511*^9, 3.592848890685116*^9}, {
   3.592848931755173*^9, 3.5928489733927317`*^9}, 3.5928490112227845`*^9, {
   3.5928587342628717`*^9, 3.5928587590829067`*^9}, {3.5932773611732855`*^9, 
   3.5932773863333206`*^9}, {3.5933671621223965`*^9, 3.593367178152419*^9}, {
   3.595092681046006*^9, 3.595092728159701*^9}, {3.5950927677949677`*^9, 
   3.59509277482337*^9}, {3.595092831335602*^9, 3.5950929197716603`*^9}, {
   3.5950929554397*^9, 3.595093119168065*^9}, {3.5965634358362417`*^9, 
   3.5965635189563584`*^9}, 3.5965635655664234`*^9, 3.5965636769165792`*^9, {
   3.6024318346931877`*^9, 3.6024318351931887`*^9}, {3.628133992861185*^9, 
   3.6281339935862265`*^9}},
 FontFamily->"Arial",
 FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
 "Chapter 1 (p. 9-42)\n",
 StyleBox["Basic Integration Problems",
  FontSize->24,
  FontWeight->"Plain"]
}], "Subtitle",
 CellChangeTimes->{{3.5950910754931736`*^9, 3.59509110077662*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->28],

Cell[CellGroupData[{

Cell["Problems 1 - 5 (p. 25)", "Section",
 CellChangeTimes->{3.5950452419596643`*^9}],

Cell[CellGroupData[{

Cell["Problem #1", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "b"}]], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"b", " ", "x"}], "a"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "b"}]], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"b", " ", "x"}], "a"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735791722603*^9, 3.589735797988961*^9}, {
   3.589748038150654*^9, 3.5897480409278126`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735180507643*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sec", "[", 
     RowBox[{"2", " ", "a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "a", " ", "x"}], "]"}], "]"}], 
   RowBox[{"2", " ", "a"}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735806675458*^9, 3.589735812957817*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #4", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735183176796*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", " ", 
      RowBox[{"Sin", "[", 
       FractionBox["x", "3"], "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", "4"]}], " ", 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Cos", "[", 
     FractionBox["x", "3"], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735824228462*^9, 3.589735833344983*^9}, 
   3.5897458306973944`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351892541437`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"3", " ", "\[Pi]"}], "4"], "-", 
       RowBox[{"2", " ", "x"}]}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", 
      RowBox[{"2", " ", "x"}]}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 6 - 11 (p. 25-26)", "Section",
 CellChangeTimes->{3.5950452419596643`*^9, 3.595045281058901*^9}],

Cell[CellGroupData[{

Cell["Problem #6", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735191971299*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sec", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"Sec", "[", "x", "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #7", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351980116444`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Csc", "[", "x", "]"}], " ", 
    RowBox[{"Cot", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"Csc", "[", "x", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735875799412*^9, 3.589735883273839*^9}, 
   3.589745907987815*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #8", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352014588413`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Tan", "[", "x", "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"Tan", "[", "x", "]"}], "2"]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358977836695`*^9, 3.5897359043440447`*^9}, 
   3.589745935768404*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #9", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352082782316`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      RowBox[{"Cos", "[", "x", "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"Sin", "[", "x", "]"}], 
   RowBox[{"1", "+", 
    RowBox[{"Cos", "[", "x", "]"}]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735911115432*^9, 3.5897359184888535`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #10", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.589735440337505*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "x", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897359253942485`*^9, 3.5897359322616415`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #11", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.589735441521572*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"a", "-", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"a", "-", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}]}], "]"}], "b"]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897359398580756`*^9, 3.5897359490336003`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 12 - 16 (p. 26)", "Section",
 CellChangeTimes->{3.5950452419596643`*^9, 3.595045281058901*^9, 
  3.5950453344969573`*^9}],

Cell[CellGroupData[{

Cell["Problem #12", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.589735442561632*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "b"}]], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "a"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897359564190226`*^9, 3.589735962082347*^9}, {
   3.589747992448039*^9, 3.5897479970853047`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #13", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735180507643*^9, 
  3.589735443237671*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "b"}]], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "a"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735973164981*^9, 3.589735978884308*^9}, {
   3.589747983248513*^9, 3.589747987618763*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #14a", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735183176796*^9, 3.5897354436036916`*^9, 
   3.5900012913690205`*^9, {3.5900013256219797`*^9, 3.5900013351545253`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], "]"}], 
   SuperscriptBox["b", "2"]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735989190897*^9, 3.589735995406253*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #14b", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735183176796*^9, 3.5897354436036916`*^9, 
   3.590001293998171*^9, {3.5900013296052074`*^9, 3.5900013410868645`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], "]"}], 
    SuperscriptBox["b", "2"]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735989190897*^9, 3.589735995406253*^9}, {
   3.5900013473792243`*^9, 3.590001351715472*^9}, 3.590001421658473*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #15a", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, 3.589735444379736*^9, {
   3.5897365975626945`*^9, 3.58973659801472*^9}, 3.5900012959412823`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], "]"}], 
    SuperscriptBox["b", "2"]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897360178355355`*^9, 3.5897360246149235`*^9}, 
   3.5898255584325337`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #15b", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, 3.589735444379736*^9, {
   3.5897365975626945`*^9, 3.58973659801472*^9}, 3.590001298959455*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], "]"}], 
   SuperscriptBox["b", "2"]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897360178355355`*^9, 3.5897360246149235`*^9}, 
   3.5898255584325337`*^9, {3.5900013574458003`*^9, 3.5900013609119987`*^9}, 
   3.5900014538573146`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #16", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897352014588413`*^9, 3.589735445100777*^9, {
   3.589736600742876*^9, 3.5897366012209034`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", "-", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"2", " ", 
     SqrtBox["3"]}]], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", 
        SqrtBox["3"]}], "+", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897360516284685`*^9, 3.589736057211788*^9}, {
   3.5897480029126377`*^9, 3.589748006252829*^9}, {3.5899999255378995`*^9, 
   3.589999939061673*^9}, {3.590000164658577*^9, 3.590000178230353*^9}, 
   3.591041159163275*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 17 - 21 (p. 26)", "Section"],

Cell[CellGroupData[{

Cell["Problem #17", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897352082782316`*^9, 3.5897354454617977`*^9, {
   3.589736606772221*^9, 3.589736607476261*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", "x"], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], "-", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"ArcTanh", "[", 
    SuperscriptBox["\[ExponentialE]", "x"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897360658262806`*^9, 3.589736073964746*^9}, {
   3.5897460646157737`*^9, 3.5897460722022076`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #18", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.589735456761444*^9, {
   3.5897366101714153`*^9, 3.5897366110314646`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      RowBox[{"Log", "[", "x", "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"Log", "[", 
   RowBox[{"Log", "[", "x", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897360819112005`*^9, 3.589736087596526*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #19", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.589735457195469*^9, {3.589736615559724*^9, 3.5897366170018063`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"Log", "[", "x", "]"}], "2"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"ArcTan", "[", 
   RowBox[{"Log", "[", "x", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897361005292654`*^9, 3.58973610689963*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #20", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.5897354576034927`*^9, {3.5897366227441344`*^9, 3.589736623812196*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"Log", "[", "x", "]"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     RowBox[{"Log", "[", "x", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589736115345113*^9, 3.5897361219424906`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #21", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735180507643*^9, 3.58973545808552*^9, {
   3.5897366266633587`*^9, 3.5897366270453806`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Log", "[", 
         FractionBox["x", "a"], "]"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", 
    RowBox[{"Log", "[", 
     FractionBox["x", "a"], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589736128497865*^9, 3.589736135730279*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 22 - 26 (p. 27)", "Section"],

Cell[CellGroupData[{

Cell["Problem #22", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735183176796*^9, 3.58973545861455*^9, {
   3.589736694328229*^9, 3.589736694824257*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["x"], "+", "x"}], ")"}], "2"], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "x"]}], "+", 
   FractionBox["4", 
    SqrtBox["x"]], "-", 
   RowBox[{"4", " ", 
    SqrtBox["x"]}], "+", "x", "+", 
   RowBox[{"3", " ", 
    RowBox[{"Log", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897461361148634`*^9, 3.58974614882459*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #23", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735183176796*^9, 3.58973545861455*^9, {
   3.5897366973073993`*^9, 3.5897366981164455`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "-", 
        SuperscriptBox["x", 
         RowBox[{"2", "/", "3"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        SqrtBox["x"]}], ")"}]}], 
     SuperscriptBox["x", 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"4", " ", 
    SqrtBox["x"]}], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", 
      RowBox[{"2", "/", "3"}]]}], "2"], "-", 
   FractionBox[
    RowBox[{"6", " ", 
     SuperscriptBox["x", 
      RowBox[{"7", "/", "6"}]]}], "7"], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746163363422*^9, 3.589746172433941*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #24", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735183176796*^9, 
  3.58973545861455*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "x"}], "-", "1"}], 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "3"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "-", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "3"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746183211557*^9, 3.5897461936861563`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #25", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351892541437`*^9, 
  3.589735458981571*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "x"}], "-", "5"}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], "-", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "-", 
      RowBox[{"5", " ", 
       SqrtBox["6"]}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      SqrtBox["6"], "-", 
      RowBox[{"3", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"5", " ", 
       SqrtBox["6"]}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      SqrtBox["6"], "+", 
      RowBox[{"3", " ", "x"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897462027066717`*^9, 3.5897462105511208`*^9}, 
   3.651621988889228*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #26", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735191971299*^9, 
  3.589735459344592*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "x"}], "-", "5"}], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], "+", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["5", 
      SqrtBox["6"]]}], 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      SqrtBox[
       FractionBox["3", "2"]], " ", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], "+", "2"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746224086895*^9, 3.589746233806451*^9}, {
   3.5897479497135954`*^9, 3.5897479568170013`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 27 - 33 (p. 27-28)", "Section"],

Cell[CellGroupData[{

Cell["Problem #27", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351980116444`*^9, 
  3.589735459717613*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", 
     FractionBox["x", "4"], "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["2", "3"], " ", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"3", " ", "x"}], "4"], "]"}]}], "-", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"5", " ", "x"}], "4"], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746250202389*^9, 3.589746256939774*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #28", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352014588413`*^9, 
  3.589735460082634*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], "+", 
   RowBox[{
    FractionBox["1", "14"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"7", " ", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897462654232593`*^9, 3.589746271591612*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #29", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352082782316`*^9, 
  3.5897354649849143`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"x", "-", "a"}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{
    RowBox[{"Cot", "[", "a", "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "-", "a"}], "]"}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"Cot", "[", "a", "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897462879295464`*^9, 3.5897462955649834`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #30a", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.5897354704472265`*^9, 
   3.5897463999839554`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "2"], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746308909746*^9, 3.5897463160141525`*^9}, 
   3.589819584187826*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #30b", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5897354709052534`*^9, {3.589746403622164*^9, 3.5897464045432167`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "2"], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897463287938843`*^9, 3.5897463364483213`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #31", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.5897354713922806`*^9, {3.58974641736595*^9, 3.5897464179579835`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "4"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746433953899*^9, 3.5897464462106*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #32", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.5897354713922806`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "4"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"Sin", "[", "x", "]"}]], "-", 
   FractionBox["1", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897464563541803`*^9, 3.589746463126567*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #33", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735180507643*^9, 
  3.589735471927312*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], "-", 
   RowBox[{"Cot", "[", "x", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897464743392086`*^9, 3.5897464827076874`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 34 - 37 (p. 28)", "Section"],

Cell[CellGroupData[{

Cell["Problem #34", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735183176796*^9, 
  3.589735472283332*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cot", "[", 
      FractionBox[
       RowBox[{"3", " ", "x"}], "4"], "]"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "-", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    RowBox[{"Cot", "[", 
     FractionBox[
      RowBox[{"3", " ", "x"}], "4"], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897465148015227`*^9, 3.589746522070939*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #35", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351892541437`*^9, 
  3.5897354727853603`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Tan", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897465300803967`*^9, 3.5897465370477953`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #36", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735191971299*^9, 
  3.5897354731513815`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], "-", 
       RowBox[{"Cot", "[", "x", "]"}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4"}], " ", "x"}], "-", 
   RowBox[{"Cot", "[", "x", "]"}], "+", 
   RowBox[{"Tan", "[", "x", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897465476704025`*^9, 3.5897465585800266`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #37", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351980116444`*^9, 
  3.589735473526403*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], "-", 
       RowBox[{"Sec", "[", "x", "]"}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], 
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746568511595*^9, 3.5897465775241103`*^9}, 
   3.65949812137799*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 38 - 40 (p. 28)", "Section"],

Cell[CellGroupData[{

Cell["Problem #38", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352014588413`*^9, 
  3.5897354738844233`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "+", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897465943160706`*^9, 3.58974659989239*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #39", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352082782316`*^9, 
  3.589735474243444*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "-", 
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "x", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746611461052*^9, 3.5897466178654175`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #40", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.589735484069006*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"x", "/", "2"}]], "-", "1"}], ")"}], "3"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["2", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"x", "/", "2"}]]], "-", 
   RowBox[{"6", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"x", "/", "2"}]]}], "+", 
   SuperscriptBox["\[ExponentialE]", "x"], "+", 
   RowBox[{"3", " ", "x"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897466293100724`*^9, 3.5897466360244565`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 41 - 43 (p. 35)", "Section"],

Cell[CellGroupData[{

Cell["Problem #41", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.589735484560034*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"5", "-", 
      RowBox[{"6", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"5", "-", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746650694296*^9, 3.5897466582877297`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #42", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.589735484922055*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"13", "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      SuperscriptBox["x", "6"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      SuperscriptBox["x", "3"]}], "2"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897466647891016`*^9, 3.5897466789059095`*^9}, 
   3.6899722137420726`*^9, {3.689972373633218*^9, 3.689972378671506*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #43", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735180507643*^9, 
  3.5897354853690805`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", "+", "x"}], 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"4", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "10"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "-", 
      RowBox[{"4", " ", 
       SqrtBox["5"]}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "-", 
      SqrtBox["5"], "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "10"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"4", " ", 
       SqrtBox["5"]}]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "+", 
      SqrtBox["5"], "-", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746691217613*^9, 3.589746700467142*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 44 - 48 (p. 35-36)", "Section",
 CellChangeTimes->{3.595045551469367*^9}],

Cell[CellGroupData[{

Cell["Problem #44", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735183176796*^9, 
  3.5897354857191005`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "+", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"2", "/", "3"}]]}], "+", 
   RowBox[{"3", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897467317319307`*^9, 3.589746741460487*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #45", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351892541437`*^9, 
  3.589735486099122*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SqrtBox["x"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "x"}], "+", "b"}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["2", 
    RowBox[{
     SqrtBox["a"], " ", 
     SqrtBox["b"]}]], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["a"], " ", 
      SqrtBox["x"]}], 
     SqrtBox["b"]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897467627327037`*^9, 3.5897467703741407`*^9}, {
   3.589747913993552*^9, 3.5897479187748256`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #46", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735191971299*^9, 
  3.589735486463143*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "3"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"5", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897467826818447`*^9, 3.5897467908633127`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #47", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351980116444`*^9, 
  3.589735486829164*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "4"], "-", 
       SuperscriptBox["x", "4"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "4"], "-", 
       SuperscriptBox["x", "4"]}]]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746806248193*^9, 3.5897468161907616`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #48a", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352014588413`*^9, 
  3.5897354905453763`*^9, 3.5897468372279644`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox["a", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["a", "2"]}]], "a"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897468556340175`*^9, 3.5897468621723914`*^9}, {
   3.5897478983126554`*^9, 3.589747901826856*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #48b", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352014588413`*^9, 
  3.5897354905453763`*^9, 3.5897468396851053`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "a"]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["x", "2"]}]], "a"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897468690327835`*^9, 3.5897468770462418`*^9}, {
   3.5897478899221754`*^9, 3.5897478933533716`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #48c", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897352082782316`*^9, 3.5897354928595085`*^9, 
   3.58974684186123*^9, {3.5897471289366493`*^9, 3.5897471297656965`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["a", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "a"]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["a", "2"]}]], "a"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.58974688976497*^9, 3.5897468966823654`*^9}, {
   3.589747883172789*^9, 3.589747886478978*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 49 - 54 (p. 36)", "Section"],

Cell[CellGroupData[{

Cell["Problem #49", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.589735498020804*^9, {
   3.589747149589831*^9, 3.5897471504468794`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"2", "+", "x", "-", 
       SuperscriptBox["x", "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"ArcSin", "[", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "x"}]}], ")"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897469206237345`*^9, 3.589746927453125*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #50", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.589735498442828*^9, {3.5897471529660234`*^9, 3.5897471533460455`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"5", "-", 
       RowBox[{"4", " ", "x"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["3"]]}], 
   RowBox[{"ArcSinh", "[", 
    FractionBox[
     RowBox[{"2", "-", 
      RowBox[{"3", " ", "x"}]}], 
     SqrtBox["11"]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.58974693732469*^9, 3.5897469434890423`*^9}, {
   3.5897478656087847`*^9, 3.589747868535952*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #51", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.589735498912855*^9, {3.589747172220125*^9, 3.589747172694152*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"x", "-", 
       SuperscriptBox["x", "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"ArcSin", "[", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", "x"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897469537696304`*^9, 3.589746961383066*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #52", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735180507643*^9, 3.5897354992738757`*^9, {
   3.5897471753533044`*^9, 3.5897471756893234`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox[
      RowBox[{"2", "+", "x", "-", 
       SuperscriptBox["x", "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SqrtBox[
     RowBox[{"2", "+", "x", "-", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "x"}]}], ")"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746967446413*^9, 3.5897469742158003`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #53", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735183176796*^9, 3.589735499638897*^9, {
   3.5897471933723345`*^9, 3.5897471936773524`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      SqrtBox[
       RowBox[{"2", "+", "x", "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"4", "+", "x"}], 
     RowBox[{"2", " ", 
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{"2", "+", "x", "-", 
        SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589746982579278*^9, 3.589746988482616*^9}, {
   3.589747842834482*^9, 3.5897478476997604`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #54", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, 3.589735500151926*^9, {
   3.589747079861842*^9, 3.589747080426875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], " ", 
      SqrtBox[
       RowBox[{"2", "+", "x", "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"2", "+", "x", "-", 
      SuperscriptBox["x", "2"]}]]}], 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897470013763533`*^9, 3.5897470116209393`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 55 - 60 (p. 36-37)", "Section"],

Cell[CellGroupData[{

Cell["Problem #55", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, 3.589735500515947*^9, {
   3.5897472384039106`*^9, 3.589747238860937*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", "+", 
      RowBox[{"3", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], "-", 
   FractionBox["1", 
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "x", "]"}]}]], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "x", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747249558549*^9, 3.589747258932085*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #56", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735191971299*^9, 
  3.589735500515947*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "+", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    SqrtBox["10"]], "-", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["10"]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      RowBox[{"2", "+", 
       SqrtBox["10"], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897472698977118`*^9, 3.5897472772361317`*^9}, {
   3.589747829019692*^9, 3.589747832382884*^9}, {3.5900004444045773`*^9, 
   3.5900005844295864`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #57", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351980116444`*^9, 
  3.5897355008919683`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"Tan", "[", "x", "]"}]}], 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Tan", "[", "x", "]"}], "]"}]}], "-", 
   FractionBox[
    RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897472916939583`*^9, 3.589747302455574*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #58", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352014588413`*^9, 
  3.5897355012539887`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Tan", "[", "x", "]"}], "2"]}], 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Tan", "[", "x", "]"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897473101610146`*^9, 3.589747315760335*^9}, 
   3.5910604995789824`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #59", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352082782316`*^9, 
  3.589735504805192*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "4"}]], 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "7"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], ")"}], 
    RowBox[{"7", "/", "4"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897473264129443`*^9, 3.5897473326022987`*^9}, {
   3.5897478057103586`*^9, 3.589747810611639*^9}, 3.589755439962013*^9, {
   3.5899969883519025`*^9, 3.5899969999895678`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #60", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.589735511134554*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", "8"]}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
    RowBox[{"2", "/", "3"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897473413577995`*^9, 3.5897473493692575`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 61 - 65 (p. 37)", "Section"],

Cell[CellGroupData[{

Cell["Problem #61", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5897355115685787`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"2", " ", "x"}]], "-", "1"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", 
       RowBox[{"2", " ", "x"}]], "-", "1"}]], "]"}], 
   RowBox[{"Log", "[", "a", "]"}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747366303226*^9, 3.5897473718515434`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #62", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.5897355120476065`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"x", "/", "2"}]], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "-", "1"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"2", " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"x", "/", "2"}]], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "-", "1"}]]], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897473792659674`*^9, 3.589747384978294*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #63", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735180507643*^9, 
  3.5897355124116273`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcTan", "[", "x", "]"}], "n"], 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcTan", "[", "x", "]"}], 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"n", "+", "1"}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747394149819*^9, 3.5897474008232*^9}, {
   3.5897477774697437`*^9, 3.589747784358137*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #64", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735183176796*^9, 
  3.589735512841652*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcSin", "[", 
       FractionBox["x", "a"], "]"}], 
      RowBox[{"3", "/", "2"}]], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["x", "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "a"}], 
    RowBox[{"5", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["x", "2"]}]]}]], 
   SqrtBox[
    RowBox[{"1", "-", 
     FractionBox[
      SuperscriptBox["x", "2"], 
      SuperscriptBox["a", "2"]]}]], " ", 
   SuperscriptBox[
    RowBox[{"ArcSin", "[", 
     FractionBox["x", "a"], "]"}], 
    RowBox[{"5", "/", "2"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897474144929824`*^9, 3.589747420763341*^9}, {
   3.5897481055885105`*^9, 3.5897481112678356`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #65", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351892541437`*^9, 
  3.589735513213673*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCos", "[", "x", "]"}], "3"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", "x", "]"}], "2"]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897474306669073`*^9, 3.589747436281228*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 66 - 68 (p. 41)", "Section"],

Cell[CellGroupData[{

Cell["Problem #66", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735191971299*^9, 
  3.5897355135716934`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], "4"], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Log", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "2"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897474593975506`*^9, 3.5897474665829616`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #67", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351980116444`*^9, 
  3.5897355139347143`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", "x", "]"}], 
     SuperscriptBox["x", "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"16", " ", 
      SuperscriptBox["x", "4"]}]]}], "-", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "4"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747472639308*^9, 3.5897474794186954`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #68", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352014588413`*^9, 
  3.5897355143127356`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"x", "-", "1"}], "x"], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["x", "3"]}], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "6"], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"x", "-", "1"}], "x"], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "-", "1"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897474876861687`*^9, 3.5897474944145536`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 69 - 71 (p. 41)", "Section"],

Cell[CellGroupData[{

Cell["Problem #69", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352082782316`*^9, 
  3.5897355146747565`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}], "3"], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "5"], "5"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897475141146803`*^9, 3.589747522074136*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #70", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.5897355949273467`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "16"], "+", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747530123596*^9, 3.5897475374230137`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #71", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5897355954213753`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "8"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "8"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    RowBox[{"Csc", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747543923385*^9, 3.5897475525408783`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 72 - 76 (p. 42)", "Section"],

Cell[CellGroupData[{

Cell["Problem #72", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.5897355958774014`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     SuperscriptBox["\[ExponentialE]", "x"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", "x"]}]]}], "-", 
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", "x"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747568026764*^9, 3.5897475754261875`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #73", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735180507643*^9, 
  3.5897355962134204`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "x"}]], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "13"]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "x"}]], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["2", "13"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "x"}]], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747583395643*^9, 3.5897475903030376`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #74", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735183176796*^9, 
  3.5897355966334443`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["a", "x"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "x"], " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}], 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"Log", "[", "a", "]"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "x"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"Log", "[", "a", "]"}], "2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897476001245995`*^9, 3.589747606580969*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #75", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351892541437`*^9, 
  3.5897355969904647`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"Log", "[", "x", "]"}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "x", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"Log", "[", "x", "]"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "x", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"Log", "[", "x", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747617594599*^9, 3.5897476239799643`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #76", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735191971299*^9, 
  3.5897355973444853`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"Tan", "[", "x", "]"}], "+", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747632624459*^9, 3.589747642347015*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 77 - 81 (p. 42)", "Section"],

Cell[CellGroupData[{

Cell["Problem #77", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351980116444`*^9, 
  3.5897356101092153`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"Cos", "[", "x", "]"}], "]"}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"Tan", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747655185749*^9, 3.5897476624471645`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #78", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352014588413`*^9, 
  3.5897356113722873`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcSin", "[", "x", "]"}], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcSin", "[", "x", "]"}], "x"]}], "-", 
   RowBox[{"ArcTanh", "[", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897476693905616`*^9, 3.5897476756829214`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #79", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352082782316`*^9, 
  3.5897356128383713`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcSin", "[", "x", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "x"}], "+", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]], " ", 
    RowBox[{"ArcSin", "[", "x", "]"}]}], "+", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcSin", "[", "x", "]"}], "2"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747686042514*^9, 3.589747692312873*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #80", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.589735440337505*^9, {
   3.5897356200877857`*^9, 3.589735621764882*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"ArcTan", "[", "x", "]"}], " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"ArcTan", "[", "x", "]"}]}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcTan", "[", "x", "]"}], "2"], "2"], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747702370448*^9, 3.589747709769871*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #81", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.589735440337505*^9, {
   3.5897356200877857`*^9, 3.5897356361007013`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCos", "[", 
     SqrtBox[
      FractionBox["x", 
       RowBox[{"1", "+", "x"}]]], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SqrtBox[
       FractionBox["1", 
        RowBox[{"1", "+", "x"}]]], " ", 
      SqrtBox[
       FractionBox["x", 
        RowBox[{"1", "+", "x"}]]]}], "+", 
     RowBox[{"ArcCos", "[", 
      SqrtBox[
       FractionBox["x", 
        RowBox[{"1", "+", "x"}]]], "]"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589747719991456*^9, 3.5897477264728265`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Chapter 2 (p. 43-97)\n",
 StyleBox["Rational Function Integration Problems",
  FontSize->24]
}], "Subtitle",
 CellChangeTimes->{{3.5950910754931736`*^9, 3.59509110077662*^9}, {
  3.5950912838890934`*^9, 3.5950912940646753`*^9}, {3.5950915699164534`*^9, 
  3.595091573048632*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->28],

Cell[CellGroupData[{

Cell["Problems 1 - 3 (p. 60)", "Section",
 CellChangeTimes->{3.594154869972735*^9}],

Cell[CellGroupData[{

Cell["Problem #1", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561390193644`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"2", " ", "x"}]}], ")"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   FractionBox[
    RowBox[{"36", " ", 
     SuperscriptBox["x", "5"]}], "5"], "+", 
   RowBox[{"9", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   FractionBox[
    RowBox[{"27", " ", 
     SuperscriptBox["x", "7"]}], "7"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561401113663`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"2", " ", "x"}], "-", "1"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "2"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "3"], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "4"]}], "2"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "5"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "6"]}], "2"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155158276841*^9, 
   3.5941551625668488`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "k"]}]}], ")"}], "n"], " ", 
    SuperscriptBox["x", 
     RowBox[{"k", "-", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "k"]}]}], ")"}], 
    RowBox[{"1", "+", "n"}]], 
   RowBox[{"b", " ", "k", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551682764587`*^9, 
   3.594155172394866*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 4 - 9 (p. 62-63)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.594154909253604*^9}],

Cell[CellGroupData[{

Cell["Problem #4", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561439177723`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "8"], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "8"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155179118478*^9, 
   3.5941551830496845`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561455401754`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "6"], 
     RowBox[{"2", "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"4", " ", "x"}], "27"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "27"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "15"], "-", 
   RowBox[{
    FractionBox["4", "27"], " ", 
    SqrtBox[
     FractionBox["2", "3"]], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      SqrtBox[
       FractionBox["3", "2"]], " ", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551874956927`*^9, 
   3.5941551918481007`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156147630579*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{"7", " ", "x"}], "+", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "5"]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      RowBox[{"3", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "-", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551966841087`*^9, 
   3.594155203360921*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #7", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561494869823`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", "x"}], "-", "1"}], 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "x", "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}], 
     SqrtBox["3"]]}], "+", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.59415520864933*^9, 
   3.5941552135633383`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #8", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561518893867`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"5", "+", 
      RowBox[{"2", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "-", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", "x"}], "2"], "]"}]}], "-", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", "x"}], "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941552284613647`*^9, 
   3.5941552329697723`*^9}, 3.6899722596696997`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #9", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561537457895`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["x", "4"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["x", "2"]}]}], 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "-", "x", "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}], "+", 
   SuperscriptBox["x", "3"], "-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"4", " ", "x"}]}], 
      SqrtBox["7"]], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["7"]}]], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.59415523710378*^9, 
   3.5941552409257865`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 10 - 14 (p. 63)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.5941549135124116`*^9}],

Cell[CellGroupData[{

Cell["Problem #10", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, {3.594156155680193*^9, 3.594156156475795*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "x", "-", "1"}], 
     RowBox[{
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"6", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "-", "x"}], "]"}]}], "+", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], "6"], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941552522514067`*^9, 
   3.594155255979813*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #11", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, {3.594156158519398*^9, 3.5941561587221985`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{"7", " ", "a", " ", "x"}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["a", "2"]}]}], 
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["a", "2"], " ", "x"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["a", "3"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["9", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "-", "x"}], "]"}]}], "-", 
   RowBox[{"17", " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"2", " ", "a"}], "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["35", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"3", " ", "a"}], "-", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.59415525989542*^9, 
   3.594155263998227*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #12", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561607658024`*^9, 3.5941563282788963`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "-", "x", "+", "2"}], 
     RowBox[{
      SuperscriptBox["x", "4"], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "2"]}], "+", "4"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "3"]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941552688498354`*^9, 
   3.5941552726874423`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #13", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156162279005*^9, 3.5941563295268984`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "-", "5"}], 
     RowBox[{
      SuperscriptBox["x", "4"], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "2"]}], "+", "6"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTanh", "[", 
      FractionBox["x", 
       SqrtBox["2"]], "]"}], 
     SqrtBox["2"]]}], "-", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox["x", 
      SqrtBox["3"]], "]"}], 
    SqrtBox["3"]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941552767434497`*^9, 
   3.5941552806590567`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #14", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561636830072`*^9, 3.5941563306501007`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "4"}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "6"]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "-", "x"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"4", "-", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941552865714664`*^9, 
   3.5941552905806737`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 15 - 17 (p. 64)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.59415491827042*^9}],

Cell[CellGroupData[{

Cell["Problem #15", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561653990107`*^9, 3.594156332568904*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "1"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], "2"]]}], "+", 
   FractionBox["2", 
    RowBox[{"1", "-", "x"}]], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941552978346863`*^9, 
   3.594155301531893*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #16", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156166600212*^9, 3.594156334487707*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "5"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "108"}], " ", "x"}], "+", 
   FractionBox[
    RowBox[{"27", " ", 
     SuperscriptBox["x", "2"]}], "2"], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "4"], "+", 
   FractionBox["243", 
    RowBox[{"3", "+", "x"}]], "+", 
   RowBox[{"405", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941553054475*^9, 
   3.5941553091291065`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #17", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156174821427*^9, 3.594156336718511*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["x", "3"]}], "-", "2"}], 
     RowBox[{
      SuperscriptBox["x", "4"], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"18", " ", 
       SuperscriptBox["x", "2"]}], "-", "27"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["133", 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "-", "x"}], ")"}], "2"]}]]}], "+", 
   FractionBox["407", 
    RowBox[{"16", " ", 
     RowBox[{"(", 
      RowBox[{"3", "-", "x"}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["313", "64"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["7", "64"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155314885516*^9, 
   3.5941553189103236`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 18 - 20 (p. 65)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.594154922217227*^9}],

Cell[CellGroupData[{

Cell["Problem #18", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.59415617684943*^9, 3.5941563405093184`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"3", " ", "x"}], "-", "9"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "3"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "4"}], ")"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["99", 
    RowBox[{"3", "+", "x"}]], "+", 
   FractionBox["181", 
    RowBox[{"4", "+", "x"}]], "+", 
   RowBox[{"264", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", "x"}], "]"}]}], "-", 
   RowBox[{"263", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"4", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155326725937*^9, 
   3.594155330313944*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #19", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561780506325`*^9, 3.5941563437073236`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "2"], "+", "2"}], 
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "1"}], ")"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"3", "+", "x"}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "-", 
   RowBox[{
    FractionBox["3", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["5", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155334791151*^9, 
   3.5941553382699575`*^9}, 3.641049445865606*^9, 3.7010667174658756`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #20", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561827930408`*^9, 3.5941563460941277`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      SuperscriptBox["x", "4"], "-", 
      SuperscriptBox["x", "5"], "+", 
      SuperscriptBox["x", "6"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}]], "-", 
   FractionBox["1", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]], "-", 
   FractionBox["1", "x"], "-", 
   RowBox[{
    FractionBox["7", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941553434647665`*^9, 
   3.5941553474115734`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 21 - 25 (p. 66)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.5941549259768333`*^9}],

Cell[CellGroupData[{

Cell["Problem #21", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156184493444*^9, 3.594156350228135*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "4"], "+", "1"}], 
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      SuperscriptBox["x", "2"], "+", "x", "-", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   RowBox[{"ArcTan", "[", "x", "]"}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941553557575884`*^9, 
   3.594155359470395*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #22", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561857570457`*^9, 3.5941563514917374`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", "x", "]"}], "2"]}], "+", 
   RowBox[{"Log", "[", "x", "]"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941553657260056`*^9, 
   3.594155370328014*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #23", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156186958248*^9, 3.5941563526929393`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["x", "2"], "-", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox["2"]], "]"}]}], "-", 
   FractionBox[
    RowBox[{"ArcTanh", "[", "x", "]"}], "3"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941553746180215`*^9, 
   3.5941553787676287`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #24", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561886898513`*^9, 3.5941563539097414`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "3"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"6", " ", "x"}]}], 
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"4", " ", "x"}], "+", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "x"}]], "+", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox["2"]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155383432037*^9, 
   3.594155387519244*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #25", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561897662535`*^9, 3.594156355064143*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "x"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["2", 
    RowBox[{"5", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], "50"], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["16", "25"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["7", "100"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155391388051*^9, 
   3.5941553962552595`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 26 - 27 (p. 67)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.5941549306412416`*^9}],

Cell[CellGroupData[{

Cell["Problem #26", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156191373056*^9, 3.594156363254158*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], "+", "x", "-", "2"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "2"]}]]}], "+", 
   FractionBox["5", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}]], "-", 
   RowBox[{"ArcTan", "[", "x", "]"}], "-", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["3", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155404211273*^9, 
   3.5941554079084797`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #27", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561924026575`*^9, 3.5941563652665615`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["x", "2"], "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}], 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]]}], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["3"]}]], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941554119176865`*^9, 
   3.5941554155056934`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 28 - 32 (p. 68)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.594154937583254*^9}],

Cell[CellGroupData[{

Cell["Problem #28", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561943994613`*^9, 3.594156367980966*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["x", "3"]}], "+", "3"}], 
     RowBox[{
      SuperscriptBox["x", "5"], "-", 
      RowBox[{"9", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox["3"]], "]"}], 
    SqrtBox["3"]], "-", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox["x", 
      SqrtBox["3"]], "]"}], 
    SqrtBox["3"]], "-", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], "3"], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"9", "-", 
      SuperscriptBox["x", "4"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941554233213067`*^9, 
   3.5941554287501163`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #29", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561956942635`*^9, 3.59415637010257*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"8", " ", "x"}], "-", "20"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "4"}], ")"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"4", " ", "x"}], "+", "8"}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["83", 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "-", "x"}], ")"}], "2"]}]]}], "+", 
   FractionBox["41", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"4", "-", "x"}], ")"}]}]], "-", 
   RowBox[{
    FractionBox["3", "16"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"1", "-", 
      FractionBox["x", "2"]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["45", "16"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"4", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["45", "32"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"8", "-", 
      RowBox[{"4", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155434054126*^9, 
   3.5941554390929346`*^9}, {3.6899724207629137`*^9, 3.6899724794802723`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #30", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, {3.5941561986270685`*^9, 3.594156200483472*^9}, 
   3.594156372520574*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "4"}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "12"]}], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", "2"], "]"}]}], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], "6"], "-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox["2"]], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox["3"]], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["3"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155446580948*^9, 
   3.5941554509021554`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #31", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562020746746`*^9, 3.5941563755157795`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "3"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "4"}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"4", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155455363763*^9, 
   3.594155459825371*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #32", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156203572277*^9, 3.5941563768729815`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["a", "3"], "+", 
      SuperscriptBox["x", "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "x"}]}], 
       RowBox[{
        SqrtBox["3"], " ", "a"}]], "]"}], 
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox["a", "2"]}]]}], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941554656441813`*^9, 
   3.59415547048019*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 33 - 44 (p. 69)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.594154941623661*^9}],

Cell[CellGroupData[{

Cell["Problem #33", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562052726803`*^9, 3.5941563789009852`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      SuperscriptBox["a", "3"], "+", 
      SuperscriptBox["x", "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"a", "-", 
        RowBox[{"2", " ", "x"}]}], 
       RowBox[{
        SqrtBox["3"], " ", "a"}]], "]"}], 
     RowBox[{
      SqrtBox["3"], " ", "a"}]]}], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"3", " ", "a"}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"6", " ", "a"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941554787950044`*^9, 
   3.5941554825078106`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #34", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562077218847`*^9, 3.594156380367388*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{
      SuperscriptBox["a", "3"], "+", 
      SuperscriptBox["x", "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox["a", "3"], "+", 
     SuperscriptBox["x", "3"]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941554863610177`*^9, 
   3.5941554931626296`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #35", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562088762865`*^9, 3.594156382052191*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        SuperscriptBox["x", "3"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    SuperscriptBox["a", "3"]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "3"], "+", 
      SuperscriptBox["x", "3"]}], "]"}], 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "3"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155498435439*^9, 
   3.594155502023445*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #36", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562105766897`*^9, 3.5941563858273973`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        SuperscriptBox["x", "3"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["a", "3"], " ", "x"}]]}], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"a", "-", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["3"], " ", "a"}]], "]"}], 
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["a", "4"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "4"]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "4"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941555067346535`*^9, 
   3.5941555106502604`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #37.3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562116530914`*^9, 3.5941563872782*^9, {
   3.595620207230233*^9, 3.5956202324002686`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        SuperscriptBox["x", "3"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"a", "-", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["3"], " ", "a"}]], "]"}], 
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["a", "5"]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "5"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "5"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155517171072*^9, 
   3.5941555214454794`*^9}, {3.5941556901285753`*^9, 3.594155692078579*^9}, {
   3.595620245660287*^9, 3.595620259030306*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #37.4", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562116530914`*^9, 3.5941563872782*^9, {
   3.595620207230233*^9, 3.595620257020303*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        SuperscriptBox["x", "3"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"3", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["x", "3"]}]]}], "-", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    SuperscriptBox["a", "6"]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "3"], "+", 
      SuperscriptBox["x", "3"]}], "]"}], 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "6"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155517171072*^9, 
   3.5941555214454794`*^9}, {3.5941556901285753`*^9, 3.594155692078579*^9}, {
   3.595620245660287*^9, 3.5956202759303293`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #37.5", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562116530914`*^9, 3.5941563872782*^9, {
   3.595620207230233*^9, 3.595620257020303*^9}, {3.5956204604505877`*^9, 
   3.595620460820588*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        SuperscriptBox["x", "3"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"4", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["x", "4"]}]]}], "+", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "6"], " ", "x"}]], "-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"a", "-", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["3"], " ", "a"}]], "]"}], 
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["a", "7"]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"3", " ", 
     SuperscriptBox["a", "7"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{"a", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"6", " ", 
     SuperscriptBox["a", "7"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155517171072*^9, 
   3.5941555214454794`*^9}, {3.5941556901285753`*^9, 3.594155692078579*^9}, {
   3.595620245660287*^9, 3.5956202759303293`*^9}, {3.5956204630105915`*^9, 
   3.595620469690601*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #37.m", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562116530914`*^9, 3.5941563872782*^9, {
   3.595620207230233*^9, 3.5956202083702345`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        SuperscriptBox["x", "3"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"1", "-", "m"}]], 
    RowBox[{
     SuperscriptBox["a", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "m"}], ")"}]}]], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", 
     FractionBox[
      RowBox[{"1", "-", "m"}], "3"], ",", 
     FractionBox[
      RowBox[{"4", "-", "m"}], "3"], ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["x", "3"], 
       SuperscriptBox["a", "3"]]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155517171072*^9, 
   3.5941555214454794`*^9}, {3.5941556901285753`*^9, 3.594155692078579*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #38", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156213322294*^9, 3.594156389025403*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      SuperscriptBox["x", "4"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["x", "a"], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"]}]], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox["x", "a"], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "3"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155525688687*^9, 
   3.5941555299786944`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #39", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156214414296*^9, 3.5941563911158066`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      SuperscriptBox["x", "4"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     SuperscriptBox["a", "2"]], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155535079903*^9, 
   3.5941555386991096`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #40", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562177527027`*^9, 3.594156394501013*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["x", "4"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    SuperscriptBox["a", "4"]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      SuperscriptBox["x", "4"]}], "]"}], 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941555473727245`*^9, 
   3.5941555512259316`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #41.2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562189383044`*^9, 3.594156396575816*^9, {
   3.5956205480507107`*^9, 3.5956205482907104`*^9}, {3.595620588230767*^9, 
   3.5956205893607683`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["x", "4"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["a", "4"], " ", "x"}]]}], "-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["x", "a"], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "5"]}]], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox["x", "a"], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "5"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941555574191427`*^9, 
   3.594155561053949*^9}, {3.5941556969457874`*^9, 3.5941556986929903`*^9}, {
   3.595620591430771*^9, 3.595620605930792*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #41.3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562189383044`*^9, 3.594156396575816*^9, {
   3.5956205480507107`*^9, 3.5956205482907104`*^9}, {3.595620588230767*^9, 
   3.5956205893607683`*^9}, {3.595620625730819*^9, 3.5956206260808196`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["x", "4"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SuperscriptBox["x", "2"], 
      SuperscriptBox["a", "2"]], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "6"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941555574191427`*^9, 
   3.594155561053949*^9}, {3.5941556969457874`*^9, 3.5941556986929903`*^9}, {
   3.595620591430771*^9, 3.595620643120844*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #41.4", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562189383044`*^9, 3.594156396575816*^9, {
   3.5956205480507107`*^9, 3.5956205482907104`*^9}, {3.595620588230767*^9, 
   3.5956205893607683`*^9}, {3.5956206303908253`*^9, 3.595620630710826*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["x", "4"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"3", " ", 
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["x", "3"]}]]}], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["x", "a"], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "7"]}]], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox["x", "a"], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "7"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941555574191427`*^9, 
   3.594155561053949*^9}, {3.5941556969457874`*^9, 3.5941556986929903`*^9}, {
   3.595620591430771*^9, 3.595620654370859*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #41.m", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562189383044`*^9, 3.594156396575816*^9, {
   3.5956205480507107`*^9, 3.5956205482907104`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["x", "4"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"1", "-", "m"}]], 
    RowBox[{
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "m"}], ")"}]}]], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", 
     FractionBox[
      RowBox[{"1", "-", "m"}], "4"], ",", 
     FractionBox[
      RowBox[{"5", "-", "m"}], "4"], ",", 
     FractionBox[
      SuperscriptBox["x", "4"], 
      SuperscriptBox["a", "4"]]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941555574191427`*^9, 
   3.594155561053949*^9}, {3.5941556969457874`*^9, 3.5941556986929903`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #42", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562206543074`*^9, 3.594156397886219*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["x", "4"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     SuperscriptBox["a", "2"]], "]"}], 
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941555656715565`*^9, 
   3.594155569743164*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #43", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562217619095`*^9, 3.5941563991030207`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["x", "4"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "x"}], "a"]}], "]"}], 
     RowBox[{"2", " ", 
      SqrtBox["2"], " ", "a"}]]}], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], "a"]}], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", "a"}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{
       SqrtBox["2"], " ", "a", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", "a"}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{
       SqrtBox["2"], " ", "a", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], "]"}], 
    RowBox[{"4", " ", 
     SqrtBox["2"], " ", "a"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155579415181*^9, 
   3.5941555854991918`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #44", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156223493512*^9, {3.594156400460223*^9, 
   3.594156402113826*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["a", "5"], "+", 
      SuperscriptBox["x", "5"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          SqrtBox["5"]}], ")"}]}]], " ", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
         RowBox[{"4", " ", "x"}]}], 
        RowBox[{
         SqrtBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", 
             SqrtBox["5"]}], ")"}]}]], " ", "a"}]], "]"}]}], 
     RowBox[{"5", " ", 
      SuperscriptBox["a", "4"]}]]}], "-", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          FractionBox["1", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
          RowBox[{"4", " ", "x"}]}], ")"}]}], 
       RowBox[{"2", " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "4"]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "4"]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "4"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941555913180017`*^9, 
   3.594155598026014*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 45 - 50 (p. 71-72)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.594154945118067*^9}],

Cell[CellGroupData[{

Cell["Problem #45", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156225646316*^9, 3.594156405920233*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      SuperscriptBox["a", "5"], "+", 
      SuperscriptBox["x", "5"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
        RowBox[{"4", " ", "x"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"]}]], "-", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          FractionBox["1", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
          RowBox[{"4", " ", "x"}]}], ")"}]}], 
       RowBox[{"2", " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "3"]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "3"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155615357644*^9, 
   3.594155619710052*^9}, 3.6293110635195503`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #46", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562286727214`*^9, 3.594156407620636*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{
      SuperscriptBox["a", "5"], "+", 
      SuperscriptBox["x", "5"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
        RowBox[{"4", " ", "x"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"]}]], "-", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          FractionBox["1", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
          RowBox[{"4", " ", "x"}]}], ")"}]}], 
       RowBox[{"2", " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "2"]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941556244680605`*^9, 
   3.594155628539667*^9}, 3.629311100213602*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #47", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156229624323*^9, 3.594156409383439*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], 
     RowBox[{
      SuperscriptBox["a", "5"], "+", 
      SuperscriptBox["x", "5"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"5", "+", 
          SqrtBox["5"]}], ")"}]}]], " ", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
         RowBox[{"4", " ", "x"}]}], 
        RowBox[{
         SqrtBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"5", "+", 
             SqrtBox["5"]}], ")"}]}]], " ", "a"}]], "]"}]}], 
     RowBox[{"5", " ", "a"}]]}], "-", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          FractionBox["1", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
          RowBox[{"4", " ", "x"}]}], ")"}]}], 
       RowBox[{"2", " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", "a"}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"5", " ", "a"}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", "a"}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", "a"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941556354972796`*^9, 
   3.5941556397560873`*^9}, 3.6293111189316287`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #48", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156230669525*^9, 3.5941564111150417`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "4"], 
     RowBox[{
      SuperscriptBox["a", "5"], "+", 
      SuperscriptBox["x", "5"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "5"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox["a", "5"], "+", 
     SuperscriptBox["x", "5"]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155646464099*^9, 
   3.5941556524233093`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #49", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562332123294`*^9, 3.5941564134550457`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "5"], "+", 
        SuperscriptBox["x", "5"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    SuperscriptBox["a", "5"]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "5"], "+", 
      SuperscriptBox["x", "5"]}], "]"}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "5"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941556566197166`*^9, 
   3.5941556605977235`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #50.2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562350999327`*^9, 3.5941564152178493`*^9, {
   3.595620793881055*^9, 3.5956207942010555`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "5"], "+", 
        SuperscriptBox["x", "5"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["a", "5"], " ", "x"}]]}], "+", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
        RowBox[{"4", " ", "x"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "6"]}]], "+", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          FractionBox["1", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
          RowBox[{"4", " ", "x"}]}], ")"}]}], 
       RowBox[{"2", " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "6"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "6"]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "6"]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "6"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155666385334*^9, 
   3.594155680378558*^9}, 3.595620834621112*^9, 3.5956208981512003`*^9, 
   3.629311154361679*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #50.3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562350999327`*^9, 3.5941564152178493`*^9, {
   3.5956207967510586`*^9, 3.5956207970510592`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "5"], "+", 
        SuperscriptBox["x", "5"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "5"], " ", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
        RowBox[{"4", " ", "x"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "7"]}]], "+", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          FractionBox["1", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
          RowBox[{"4", " ", "x"}]}], ")"}]}], 
       RowBox[{"2", " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "7"]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "7"]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "7"]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "7"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155666385334*^9, 
   3.594155680378558*^9}, 3.5956208326511087`*^9, 3.5956209115312195`*^9, 
   3.629311175581709*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #50.4", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562350999327`*^9, 3.5941564152178493`*^9, {
   3.5956208188510895`*^9, 3.59562081917109*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "5"], "+", 
        SuperscriptBox["x", "5"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"3", " ", 
      SuperscriptBox["a", "5"], " ", 
      SuperscriptBox["x", "3"]}]]}], "-", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
        RowBox[{"4", " ", "x"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "8"]}]], "+", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          FractionBox["1", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SqrtBox["5"]}], ")"}], " ", "a"}], "-", 
          RowBox[{"4", " ", "x"}]}], ")"}]}], 
       RowBox[{"2", " ", "a"}]], "]"}]}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "8"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", "x"}], "]"}], 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "8"]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "8"]}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["a", "8"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155666385334*^9, 
   3.594155680378558*^9}, 3.5956208300011053`*^9, 3.5956209293712444`*^9, 
   3.6293111918617315`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #50.m", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562350999327`*^9, 3.5941564152178493`*^9, {
   3.5956208000410633`*^9, 3.5956208230010953`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "5"], "+", 
        SuperscriptBox["x", "5"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"1", "-", "m"}]], 
    RowBox[{
     SuperscriptBox["a", "5"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "m"}], ")"}]}]], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", 
     FractionBox[
      RowBox[{"1", "-", "m"}], "5"], ",", 
     FractionBox[
      RowBox[{"6", "-", "m"}], "5"], ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["x", "5"], 
       SuperscriptBox["a", "5"]]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155666385334*^9, 
   3.594155680378558*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 51 - 57 (p. 77-79)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.5941549498760757`*^9}],

Cell[CellGroupData[{

Cell["Problem #51", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562387347393`*^9, 3.5941564209742594`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "4"], "+", "1"}], 
     RowBox[{
      SuperscriptBox["x", "6"], "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "3"]}], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      SqrtBox["3"], "-", 
      RowBox[{"2", " ", "x"}]}], "]"}]}], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"ArcTan", "[", "x", "]"}]}], "3"], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      SqrtBox["3"], "+", 
      RowBox[{"2", " ", "x"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941557108766117`*^9, 
   3.594155714714219*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #52", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562397175407`*^9, 3.5941564233922634`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"3", " ", "x"}], "+", "5"}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"3", "+", 
     RowBox[{"2", " ", "x"}]}], 
    RowBox[{"22", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"3", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "x"}]}], ")"}]}], 
    RowBox[{"121", " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"3", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"12", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"3", "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["11"]], "]"}]}], 
    RowBox[{"121", " ", 
     SqrtBox["11"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941557191446266`*^9, 
   3.594155722919833*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #53", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562406847425`*^9, 3.594156425326667*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["x", "2"], "+", "1"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}], ")"}], "4"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "3"]}]], "-", 
   FractionBox["x", 
    RowBox[{"24", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"7", " ", "x"}], 
    RowBox[{"16", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"7", " ", 
     RowBox[{"ArcTan", "[", "x", "]"}]}], "16"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.59415572694464*^9, 
   3.5941557310630474`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #54", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156242166745*^9, 3.59415642702707*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"A", " ", "x"}], "+", "B"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", "c"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "B"}], "-", 
      RowBox[{"A", " ", "c"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"A", " ", "b"}], "-", 
         RowBox[{"a", " ", "B"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A", " ", "b"}], "-", 
       RowBox[{"a", " ", "B"}]}], ")"}], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "+", 
        RowBox[{"a", " ", "x"}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"a", " ", "c"}]}]]], "]"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155736367057*^9, 
   3.5941557407974644`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #55", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156243165147*^9, 3.5941564313326774`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["x", "3"]}], "-", 
      RowBox[{"27", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"55", " ", "x"}], "-", "41"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"4", " ", "x"}], "+", "5"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "-", "x"}], 
    RowBox[{"5", "-", 
     RowBox[{"4", " ", "x"}], "+", 
     SuperscriptBox["x", "2"]}]], "-", 
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"2", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["5", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"5", "-", 
      RowBox[{"4", " ", "x"}], "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155747739477*^9, 
   3.5941557517018833`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #56", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562446939497`*^9, 3.5941564326430798`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", "1"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "3"]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], "-", 
   RowBox[{
    FractionBox["2", "9"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941557559138913`*^9, 
   3.5941557597826977`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #57", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562476267548`*^9, 3.594156434405883*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "4"]}], "+", "4"}], 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "1"}], ")"}], "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["4", "x"]}], "-", 
   FractionBox[
    RowBox[{"7", " ", "x"}], 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{"25", " ", "x"}], 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "-", 
   FractionBox[
    RowBox[{"57", " ", 
     RowBox[{"ArcTan", "[", "x", "]"}]}], "8"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941557641507053`*^9, 
   3.594155768019512*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 58 - 65 (p. 80-81)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.594154954212883*^9}],

Cell[CellGroupData[{

Cell["Problem #58", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156248765557*^9, 3.5941564359034853`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      SuperscriptBox["x", "6"], "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], 
       SqrtBox["3"]], "]"}], 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "4"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941557796259327`*^9, 
   3.59415578368194*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #59", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562514643617`*^9, 3.594156437853489*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"n", "-", "1"}]], "-", "1"}], 
     RowBox[{
      SuperscriptBox["x", "n"], "-", 
      RowBox[{"n", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox["x", "n"], "-", 
     RowBox[{"n", " ", "x"}]}], "]"}], "n"]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941557874571466`*^9, 
   3.594155791138753*^9}, 3.59416121304144*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #60", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562541475663`*^9, 3.594156440193493*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}]}], 
       SqrtBox["2"]], "]"}], 
     RowBox[{"6", " ", 
      SqrtBox["2"]}]]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "4"]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941557959279613`*^9, 
   3.594155799749968*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #61", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562569711714`*^9, 3.5941564446083007`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "5"], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      SuperscriptBox["x", "2"], "-", "4"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], "6"], "+", 
   RowBox[{
    FractionBox["1", "14"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["8", "63"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"4", "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941558084859834`*^9, 
   3.594155817268799*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #62", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562582347736`*^9, 3.5941564460279036`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"9", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      SuperscriptBox["x", "6"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "24"]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "3"]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"9", "-", 
      SuperscriptBox["x", "3"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155827159216*^9, 
   3.594155832369625*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #63", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562591863747`*^9, 3.594156447244705*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["x", "2"]}], "+", "1"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "4"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["7", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "-", "x"}], ")"}], "3"]}]]}], "+", 
   FractionBox["2", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "-", "x"}], ")"}], "2"]], "+", 
   FractionBox["2", 
    RowBox[{"2", "-", "x"}]], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"2", "-", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941558366440325`*^9, 
   3.5941558404192395`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #64", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156260184777*^9, 3.594156448633108*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "12"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"11", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], "11"]}]], "-", 
   FractionBox["3", 
    RowBox[{"10", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], "10"]}]], "+", 
   FractionBox["1", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], "9"]}]], "-", 
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], "8"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941558454268484`*^9, 
   3.5941558495140553`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #65", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562611363783`*^9, 3.594156450458311*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "4"], "-", 
      RowBox[{"3", " ", "x"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], ")"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["25", 
     RowBox[{"128", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "x"}]}], ")"}], "4"]}]]}], "+", 
   FractionBox["7", 
    RowBox[{"24", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], ")"}], "3"]}]], "-", 
   FractionBox["3", 
    RowBox[{"32", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], ")"}], "2"]}]], "+", 
   FractionBox["1", 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["1", "32"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155855566866*^9, 
   3.594155859482473*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 66 - 70 (p. 83-78)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.5941549587212906`*^9}],

Cell[CellGroupData[{

Cell["Problem #66", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156263679183*^9, 3.594156454467518*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}]], "-", 
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], "2"]}]], "-", 
   FractionBox["1", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"ArcTanh", "[", "x", "]"}]}], "8"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155879403708*^9, 
   3.5941558830229144`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #67", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562650987854`*^9, 3.594156456043121*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "-", 
         RowBox[{"6", " ", "x"}]}], ")"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["6", 
    RowBox[{"25", " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"6", " ", "x"}]}], ")"}]}]], "-", 
   FractionBox["1", 
    RowBox[{"25", " ", "x"}]], "-", 
   RowBox[{
    FractionBox["12", "125"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"5", "-", 
      RowBox[{"6", " ", "x"}]}], "]"}]}], "+", 
   FractionBox[
    RowBox[{"12", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "125"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941558868605213`*^9, 
   3.594155890354927*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #68", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156267001989*^9, 3.5941564587263255`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"2", " ", "x"}], "-", "3"}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "-", "x"}], 
    RowBox[{"16", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}], 
    RowBox[{"128", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["3", "512"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "-", "x"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "512"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941558955029364`*^9, 
   3.594155899293743*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #69", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156268281191*^9, 3.594156462236332*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"4", " ", "x"}], "+", "13"}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", "-", "x"}], 
     RowBox[{"36", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"13", "-", 
         RowBox[{"4", " ", "x"}], "+", 
         SuperscriptBox["x", "2"]}], ")"}], "2"]}]]}], "-", 
   FractionBox[
    RowBox[{"2", "-", "x"}], 
    RowBox[{"216", " ", 
     RowBox[{"(", 
      RowBox[{"13", "-", 
       RowBox[{"4", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "-", 
   RowBox[{
    FractionBox["1", "648"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"2", "-", "x"}], "3"], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941559029753494`*^9, 
   3.594155907109357*^9}, {3.6899727357099276`*^9, 3.6899727398031616`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #70", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562712607965`*^9, 3.5941564636091337`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "2"}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "3"}], ")"}], "4"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "+", "x"}], ")"}], "2"]}]]}], "+", 
   FractionBox["4", 
    RowBox[{"2", "+", "x"}]], "+", 
   FractionBox["1", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}], "3"]}]], "+", 
   FractionBox["3", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}], "2"]}]], "+", 
   FractionBox["6", 
    RowBox[{"3", "+", "x"}]], "+", 
   RowBox[{"10", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "+", "x"}], "]"}]}], "-", 
   RowBox[{"10", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941559126005664`*^9, 
   3.594155917576975*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 71 - 82 (p. 86-87)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.5941549641501007`*^9}],

Cell[CellGroupData[{

Cell["Problem #71", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562737412004`*^9, 3.594156468133142*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "6"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "2"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"4", " ", "x"}], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "-", 
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    RowBox[{
     SuperscriptBox["x", "2"], "-", "2"}]], "-", 
   RowBox[{"5", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox["x", 
      SqrtBox["2"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941559270149918`*^9, 
   3.5941559308837986`*^9}, 3.5941658065276313`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #72", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562748956027`*^9, 3.594156469646345*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "8"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "4"}], ")"}], "4"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"35", " ", "x"}], "16"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"4", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "3"]}]], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "5"]}], 
    RowBox[{"24", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"4", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"48", " ", 
     RowBox[{"(", 
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "-", 
   RowBox[{
    FractionBox["35", "8"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", "2"], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155934456205*^9, 
   3.594155938153411*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #73", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156278109208*^9, 3.5941564710815473`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"7", " ", "x"}], "-", "4"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"2", " ", "x"}], "+", "5"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"39", "+", 
      RowBox[{"19", " ", "x"}]}], 
     RowBox[{"28", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"2", " ", "x"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}], "-", 
   FractionBox[
    RowBox[{"19", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"3", " ", "x"}]}], 
       SqrtBox["14"]], "]"}]}], 
    RowBox[{"28", " ", 
     SqrtBox["14"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155942474619*^9, 
   3.5941559469830265`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #74", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562846612196`*^9, 3.5941564732031507`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"5", "-", 
      RowBox[{"4", " ", "x"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"4", " ", "x"}], "-", "2"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"18", "-", 
      RowBox[{"7", " ", "x"}]}], 
     RowBox[{"20", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"4", " ", "x"}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"2", "-", 
        RowBox[{"3", " ", "x"}]}], 
       SqrtBox["10"]], "]"}]}], 
    RowBox[{"20", " ", 
     SqrtBox["10"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155950695833*^9, 
   3.59415595470504*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #75", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156285706422*^9, 3.5941564750283537`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "5"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "+", "1"}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["x", "4"]}], ")"}], "2"]}]]}], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"16", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "4"]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     SuperscriptBox["x", "2"], "]"}], "16"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941559627546544`*^9, 
   3.594155966576661*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #76", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156286658023*^9, 3.5941564771343575`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "1"}], ")"}], "3"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "+", "2"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}], "+", "2"}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", "2"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941559710850687`*^9, 
   3.5941559748602753`*^9}, {3.5941629340844655`*^9, 3.5941629516032963`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #77", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156287812425*^9, 3.594156480191963*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["x", "4"]}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["x", "4"]}], ")"}], "2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594155980757086*^9, 
   3.594155985749095*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #78", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.59415629046443*^9, 3.594156481861166*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "+", 
         SuperscriptBox["x", "4"]}], ")"}], "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["x", "4"]}], ")"}], "2"]}]], "+", 
   FractionBox["1", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "8"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "+", 
       SuperscriptBox["x", "4"]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    SuperscriptBox["a", "12"]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["x", "4"]}], "]"}], 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "12"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941559898987017`*^9, 
   3.5941559936739087`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #79", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.59415629595564*^9, 3.5941564837175694`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "+", 
         SuperscriptBox["x", "4"]}], ")"}], "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["45", 
     RowBox[{"32", " ", 
      SuperscriptBox["a", "12"], " ", "x"}]]}], "+", 
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", "x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["x", "4"]}], ")"}], "2"]}]], "+", 
   FractionBox["9", 
    RowBox[{"32", " ", 
     SuperscriptBox["a", "8"], " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "+", 
       SuperscriptBox["x", "4"]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"45", " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "x"}], "a"]}], "]"}]}], 
    RowBox[{"64", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["a", "13"]}]], "-", 
   FractionBox[
    RowBox[{"45", " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "x"}], "a"]}], "]"}]}], 
    RowBox[{"64", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["a", "13"]}]], "-", 
   FractionBox[
    RowBox[{"45", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        SqrtBox["2"], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"128", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["a", "13"]}]], "+", 
   FractionBox[
    RowBox[{"45", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{
        SqrtBox["2"], " ", "a", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], "]"}]}], 
    RowBox[{"128", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["a", "13"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594156001910723*^9, 
   3.5941560059199305`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #80", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941562982644434`*^9, 3.594156485589573*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "+", 
         SuperscriptBox["x", "4"]}], ")"}], "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["15", 
     RowBox[{"16", " ", 
      SuperscriptBox["a", "12"], " ", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["x", "4"]}], ")"}], "2"]}]], "+", 
   FractionBox["5", 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "8"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "+", 
       SuperscriptBox["x", "4"]}], ")"}]}]], "-", 
   FractionBox[
    RowBox[{"15", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       SuperscriptBox["x", "2"], 
       SuperscriptBox["a", "2"]], "]"}]}], 
    RowBox[{"16", " ", 
     SuperscriptBox["a", "14"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594156009929137*^9, 
   3.5941560136887436`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #81", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941563009788485`*^9, 3.5941564887875786`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "14"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "5"]}]}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["9", 
     RowBox[{"80", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "5"]}]}], ")"}], "2"]}]]}], "+", 
   FractionBox["3", 
    RowBox[{"20", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "5"]}]}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["1", "40"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "5"]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941560187431526`*^9, 
   3.594156025076764*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #82", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156303006852*^9, 3.594156490160381*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "6"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "5"]}]}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{"20", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "5"]}]}], ")"}], "2"]}]]}], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"150", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "5"]}]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{"5", "-", 
       SqrtBox["5"]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["3", 
          RowBox[{"1", "/", "5"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SqrtBox["5"]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["2", 
          RowBox[{"1", "/", "5"}]], " ", "x"}]}], 
       RowBox[{
        SuperscriptBox["3", 
         RowBox[{"1", "/", "5"}]], " ", 
        SqrtBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]]}]], "]"}]}], 
    RowBox[{"250", " ", 
     SuperscriptBox["2", 
      RowBox[{"9", "/", "10"}]], " ", 
     SuperscriptBox["3", 
      RowBox[{"3", "/", "5"}]]}]], "-", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{"5", "+", 
       SqrtBox["5"]}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{
          FractionBox["1", "10"], " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            SqrtBox["5"]}], ")"}]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["3", 
            RowBox[{"1", "/", "5"}]], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SqrtBox["5"]}], ")"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["2", 
            RowBox[{"1", "/", "5"}]], " ", "x"}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "5"}]]}]], "]"}]}], 
    RowBox[{"250", " ", 
     SuperscriptBox["2", 
      RowBox[{"9", "/", "10"}]], " ", 
     SuperscriptBox["3", 
      RowBox[{"3", "/", "5"}]]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{"1", "/", "5"}]], "+", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"1", "/", "5"}]], " ", "x"}]}], "]"}], 
    RowBox[{"250", " ", 
     SuperscriptBox["2", 
      RowBox[{"2", "/", "5"}]], " ", 
     SuperscriptBox["3", 
      RowBox[{"3", "/", "5"}]]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{"2", "/", "5"}]], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["3", 
          RowBox[{"1", "/", "5"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SqrtBox["5"]}], ")"}], " ", "x"}], 
        SuperscriptBox["2", 
         RowBox[{"4", "/", "5"}]]], "+", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"2", "/", "5"}]], " ", 
        SuperscriptBox["x", "2"]}]}], "]"}]}], 
    RowBox[{"1000", " ", 
     SuperscriptBox["2", 
      RowBox[{"2", "/", "5"}]], " ", 
     SuperscriptBox["3", 
      RowBox[{"3", "/", "5"}]]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox["5"]}], ")"}], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{"2", "/", "5"}]], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["3", 
          RowBox[{"1", "/", "5"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["5"]}], ")"}], " ", "x"}], 
        SuperscriptBox["2", 
         RowBox[{"4", "/", "5"}]]], "+", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"2", "/", "5"}]], " ", 
        SuperscriptBox["x", "2"]}]}], "]"}]}], 
    RowBox[{"1000", " ", 
     SuperscriptBox["2", 
      RowBox[{"2", "/", "5"}]], " ", 
     SuperscriptBox["3", 
      RowBox[{"3", "/", "5"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.594156031207575*^9, 
   3.5941560351075816`*^9}, 3.610307052947581*^9, 3.6293112800038595`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 83 - 87 (p. 90-91)", "Section",
 CellChangeTimes->{
  3.594154869972735*^9, {3.5941549641501007`*^9, 3.594154977706524*^9}}],

Cell[CellGroupData[{

Cell["Problem #83", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941563086852617`*^9, 3.5941564926563854`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["9", 
     RowBox[{"5", " ", 
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"8", " ", "x"}]]}], "+", 
   FractionBox["3", 
    RowBox[{"20", " ", "x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]}]], "+", 
   FractionBox["1", 
    RowBox[{"8", " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      SqrtBox[
       FractionBox["2", "3"]], " ", "x"}], "]"}], 
    RowBox[{"4", " ", 
     SqrtBox["6"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941560485392056`*^9, 
   3.5941560527980127`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #84", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941563098240643`*^9, 3.594156494731189*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "4"]}], "+", "4"}], 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "1"}], ")"}], "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["4", "x"]}], "-", 
   FractionBox[
    RowBox[{"7", " ", "x"}], 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{"25", " ", "x"}], 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "-", 
   FractionBox[
    RowBox[{"57", " ", 
     RowBox[{"ArcTan", "[", "x", "]"}]}], "8"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941560587260227`*^9, 
   3.594156063125231*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #85", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941563108848658`*^9, 3.5941564964003916`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"5", "-", 
      RowBox[{"3", " ", "x"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "3"]}], "-", 
      SuperscriptBox["x", "4"]}], 
     RowBox[{
      SuperscriptBox["x", "5"], "-", 
      SuperscriptBox["x", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", "x", "-", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "2"]}]]}], "+", 
   FractionBox["2", 
    RowBox[{"1", "-", "x"}]], "+", 
   FractionBox["1", 
    RowBox[{"1", "+", "x"}]], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941560673372383`*^9, 
   3.5941560720172462`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #86", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941563120548677`*^9, 3.5941564987091956`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "1"}], 
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "3"], "+", "1"}], ")"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}], 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "3"], "+", "1"}], ")"}]}]], "-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}], 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], "+", 
   RowBox[{"Log", "[", "x", "]"}], "-", 
   RowBox[{
    FractionBox["4", "9"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["5", "18"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941560777424564`*^9, 
   3.5941560830308657`*^9}, {3.641049513320124*^9, 3.6410495207925377`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #87", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156313677271*^9, 3.594156500565599*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"3", " ", "x"}], "-", "2"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "x", "+", "1"}], ")"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["2", 
     RowBox[{"1", "+", "x"}]]}], "-", 
   FractionBox[
    RowBox[{"7", "+", 
     RowBox[{"5", " ", "x"}]}], 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "-", 
   FractionBox[
    RowBox[{"25", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], 
       SqrtBox["3"]], "]"}]}], 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], "-", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941560870244727`*^9, 
   3.594156092219282*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 88 - 90 (p. 97)", "Section",
 CellChangeTimes->{
  3.594154869972735*^9, {3.5941549641501007`*^9, 3.594154981949732*^9}}],

Cell[CellGroupData[{

Cell["Problem #88", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941563153776736`*^9, 3.594156503888405*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"3", " ", "x"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"4", " ", "x"}]}], ")"}], "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"10", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "x"}]}], ")"}], "2"]}]], "-", 
   FractionBox["3", 
    RowBox[{"25", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"4", " ", "x"}]}], ")"}]}]], "-", 
   RowBox[{
    FractionBox["9", "125"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      RowBox[{"4", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["9", "125"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "-", 
      RowBox[{"3", " ", "x"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941560998632956`*^9, 
   3.5941561035761013`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #89", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941563171404767`*^9, 3.594156506166009*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "7"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"150", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "6"]}]], "-", 
   FractionBox["1", 
    RowBox[{"250", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "5"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941561078349094`*^9, 
   3.5941561118129163`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #90", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.594156320198082*^9, 3.5941565076792116`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "7"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "250"]}], "+", 
   FractionBox["2", 
    RowBox[{"625", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]}]], "-", 
   FractionBox["6", 
    RowBox[{"625", " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "-", 
   RowBox[{
    FractionBox["3", "625"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941561159469233`*^9, 
   3.5941561199093304`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Chapter 3 (p. 98-113)\n",
 StyleBox["Rational Function Integration Problems",
  FontSize->24]
}], "Subtitle",
 CellChangeTimes->{{3.5950910754931736`*^9, 3.59509110077662*^9}, {
  3.595091316539961*^9, 3.5950913254504704`*^9}, {3.5950916201573267`*^9, 
  3.5950916232525034`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->28],

Cell[CellGroupData[{

Cell["Problems 1 - 3 (p. 101)", "Section"],

Cell[CellGroupData[{

Cell["Problem #1", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834982865099*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "2"}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"18", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "2"}], ")"}], "2"]}]]}], "+", 
   FractionBox["2", 
    RowBox[{"27", " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}]}]], "+", 
   FractionBox["1", 
    RowBox[{"27", " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["1", "27"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "-", "2"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "27"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "1"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834985370242*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "2"}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "3"}], ")"}], "4"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "2"}], ")"}], "2"]}]]}], "+", 
   FractionBox["4", 
    RowBox[{"x", "+", "2"}]], "+", 
   FractionBox["1", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "3"}], ")"}], "3"]}]], "+", 
   FractionBox["3", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "3"}], ")"}], "2"]}]], "+", 
   FractionBox["6", 
    RowBox[{"x", "+", "3"}]], "+", 
   RowBox[{"10", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "2"}], "]"}]}], "-", 
   RowBox[{"10", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "3"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898351292794733`*^9, 3.5898351357718444`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834987871385*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "5"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "108"}], " ", "x"}], "+", 
   FractionBox[
    RowBox[{"27", " ", 
     SuperscriptBox["x", "2"]}], "2"], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "4"], "+", 
   FractionBox["243", 
    RowBox[{"3", "+", "x"}]], "+", 
   RowBox[{"405", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898351437573013`*^9, 3.5898351523337917`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 4 - 9 (p. 105)", "Section"],

Cell[CellGroupData[{

Cell["Problem #4.1", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834990321525*^9, {3.595621155411561*^9, 
   3.595621171241583*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"2", " ", "b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "1"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"a", " ", "b1", " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "b", " ", "b1"}], "+", 
      RowBox[{"a", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b1", " ", "c"}], "+", 
      RowBox[{"2", " ", "b", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", "c", " ", "c1", " ", 
    SuperscriptBox["x", "4"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898351934501433`*^9, 3.5898352018806257`*^9}, {
   3.589835584938535*^9, 3.589835589183778*^9}, {3.589835646806074*^9, 
   3.5898357089226265`*^9}, 3.5956211809415965`*^9, 3.5956214086619153`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #4.2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834990321525*^9, {3.595621155411561*^9, 
   3.595621173341586*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"2", " ", "b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", "b1", " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "b", " ", "b1"}], "+", 
      RowBox[{"a", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", "b1"}], "+", 
      RowBox[{"a", " ", "b1", " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "b", " ", "b1", " ", "c"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", "c1"}], "+", 
      RowBox[{"a", " ", "c", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b1", " ", "c"}], "+", 
      RowBox[{"4", " ", "b", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["c", "2"], " ", "c1", " ", 
    SuperscriptBox["x", "6"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898351934501433`*^9, 3.5898352018806257`*^9}, {
   3.589835584938535*^9, 3.589835589183778*^9}, {3.589835646806074*^9, 
   3.5898357089226265`*^9}, 3.595621182541599*^9, 3.5956214330619497`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #4.3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834990321525*^9, {3.595621155411561*^9, 
   3.595621175511589*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"2", " ", "b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "3"], " ", "b1", " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", "b", " ", "b1"}], "+", 
      RowBox[{"a", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", "b1"}], "+", 
      RowBox[{"a", " ", "b1", " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["b", "3"], " ", "b1"}], "+", 
      RowBox[{"12", " ", "a", " ", "b", " ", "b1", " ", "c"}], "+", 
      RowBox[{"12", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", "c", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"12", " ", 
       SuperscriptBox["b", "2"], " ", "b1", " ", "c"}], "+", 
      RowBox[{"3", " ", "a", " ", "b1", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "3"], " ", "c1"}], "+", 
      RowBox[{"12", " ", "a", " ", "b", " ", "c", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "b", " ", "b1", " ", "c"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", "c1"}], "+", 
      RowBox[{"a", " ", "c", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{
    FractionBox["1", "7"], " ", 
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b1", " ", "c"}], "+", 
      RowBox[{"6", " ", "b", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox["c", "3"], " ", "c1", " ", 
    SuperscriptBox["x", "8"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898351934501433`*^9, 3.5898352018806257`*^9}, {
   3.589835584938535*^9, 3.589835589183778*^9}, {3.589835646806074*^9, 
   3.5898357089226265`*^9}, 3.595621184391601*^9, 3.595621457341984*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #4.4", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834990321525*^9, {3.595621155411561*^9, 
   3.5956211776515923`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"2", " ", "b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "4"], " ", "b1", " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["a", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "b", " ", "b1"}], "+", 
      RowBox[{"a", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["b", "2"], " ", "b1"}], "+", 
      RowBox[{"a", " ", "b1", " ", "c"}], "+", 
      RowBox[{"2", " ", "a", " ", "b", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["b", "3"], " ", "b1"}], "+", 
      RowBox[{"6", " ", "a", " ", "b", " ", "b1", " ", "c"}], "+", 
      RowBox[{"6", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c1"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "c", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{
    FractionBox["2", "5"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["b", "4"], " ", "b1"}], "+", 
      RowBox[{"24", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "b1", " ", "c"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", "b1", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"16", " ", "a", " ", 
       SuperscriptBox["b", "3"], " ", "c1"}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", "c1"}]}], ")"}], 
    " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"16", " ", 
       SuperscriptBox["b", "3"], " ", "b1", " ", "c"}], "+", 
      RowBox[{"12", " ", "a", " ", "b", " ", "b1", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "4"], " ", "c1"}], "+", 
      RowBox[{"24", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c", " ", "c1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{
    FractionBox["4", "7"], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["b", "2"], " ", "b1", " ", "c"}], "+", 
      RowBox[{"a", " ", "b1", " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "3"], " ", "c1"}], "+", 
      RowBox[{"6", " ", "a", " ", "b", " ", "c", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "b", " ", "b1", " ", "c"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["b", "2"], " ", "c1"}], "+", 
      RowBox[{"a", " ", "c", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    SuperscriptBox["c", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b1", " ", "c"}], "+", 
      RowBox[{"8", " ", "b", " ", "c1"}]}], ")"}], " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{
    FractionBox["1", "10"], " ", 
    SuperscriptBox["c", "4"], " ", "c1", " ", 
    SuperscriptBox["x", "10"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898351934501433`*^9, 3.5898352018806257`*^9}, {
   3.589835584938535*^9, 3.589835589183778*^9}, {3.589835646806074*^9, 
   3.5898357089226265`*^9}, 3.5956211864016037`*^9, 3.5956214815820174`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #4.n", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834990321525*^9, {3.595621155411561*^9, 
   3.595621156161562*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"2", " ", "b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"c1", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]]}], 
    RowBox[{"2", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], "-", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b1", " ", "c"}], "-", 
        RowBox[{"b", " ", "c1"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"2", " ", "b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]]}], 
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", "+", 
           RowBox[{"c", " ", "x"}], "-", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"a", " ", "c"}]}]]}], 
          RowBox[{"2", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"a", " ", "c"}]}]]}]]}], ")"}], 
       RowBox[{"n", "+", "1"}]]}]], " ", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{
      RowBox[{"-", "n"}], ",", 
      RowBox[{"1", "+", "n"}], ",", 
      RowBox[{"2", "+", "n"}], ",", 
      FractionBox[
       RowBox[{"b", "+", 
        RowBox[{"c", " ", "x"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"a", " ", "c"}]}]]}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898351934501433`*^9, 3.5898352018806257`*^9}, {
   3.589835584938535*^9, 3.589835589183778*^9}, {3.589835646806074*^9, 
   3.5898357089226265`*^9}, 3.627435012907057*^9, {3.6274351150322027`*^9, 
   3.6274351268442187`*^9}, {3.6274354842267256`*^9, 3.6274354905267344`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5.1", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834992433646*^9, {3.5956212060016317`*^9, 
   3.5956212152916446`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "1"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b1", " ", "c"}], "-", 
        RowBox[{"b", " ", "c1"}]}], ")"}], " ", 
      RowBox[{"ArcTanh", "[", 
       FractionBox[
        RowBox[{"b", "+", 
         RowBox[{"c", " ", "x"}]}], 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"a", " ", "c"}]}]]], "]"}]}], 
     RowBox[{"c", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}]]}]]}], "+", 
   FractionBox[
    RowBox[{"c1", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"2", " ", "b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}]}], 
    RowBox[{"2", " ", "c"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898352231058397`*^9, 3.5898352305502653`*^9}, {
   3.5898355703016977`*^9, 3.5898355755479984`*^9}, {3.589835608937908*^9, 
   3.58983561632633*^9}, 3.595621224811658*^9, 3.595621524532078*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5.2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834992433646*^9, {3.5956212060016317`*^9, 
   3.5956212164916463`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "b1"}], "-", 
      RowBox[{"a", " ", "c1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b1", " ", "c"}], "-", 
         RowBox[{"b", " ", "c1"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b1", " ", "c"}], "-", 
       RowBox[{"b", " ", "c1"}]}], ")"}], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "+", 
        RowBox[{"c", " ", "x"}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"a", " ", "c"}]}]]], "]"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898352231058397`*^9, 3.5898352305502653`*^9}, {
   3.5898355703016977`*^9, 3.5898355755479984`*^9}, {3.589835608937908*^9, 
   3.58983561632633*^9}, 3.59562122630166*^9, 3.5956215465921087`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5.3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834992433646*^9, {3.5956212060016317`*^9, 
   3.595621217811648*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "b1"}], "-", 
      RowBox[{"a", " ", "c1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b1", " ", "c"}], "-", 
         RowBox[{"b", " ", "c1"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"2", " ", "b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "2"]}]]}], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b1", " ", "c"}], "-", 
       RowBox[{"b", " ", "c1"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"c", " ", "x"}]}], ")"}]}], 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"2", " ", "b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "-", 
   FractionBox[
    RowBox[{"3", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b1", " ", "c"}], "-", 
       RowBox[{"b", " ", "c1"}]}], ")"}], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "+", 
        RowBox[{"c", " ", "x"}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"a", " ", "c"}]}]]], "]"}]}], 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], 
      RowBox[{"5", "/", "2"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898352231058397`*^9, 3.5898352305502653`*^9}, {
   3.5898355703016977`*^9, 3.5898355755479984`*^9}, {3.589835608937908*^9, 
   3.58983561632633*^9}, 3.5956212280616627`*^9, 3.595621566122136*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5.4", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834992433646*^9, {3.5956212060016317`*^9, 
   3.5956212190316496`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "4"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "b1"}], "-", 
      RowBox[{"a", " ", "c1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b1", " ", "c"}], "-", 
         RowBox[{"b", " ", "c1"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"6", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"2", " ", "b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "3"]}]]}], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b1", " ", "c"}], "-", 
       RowBox[{"b", " ", "c1"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"c", " ", "x"}]}], ")"}]}], 
    RowBox[{"24", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{"5", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b1", " ", "c"}], "-", 
       RowBox[{"b", " ", "c1"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"c", " ", "x"}]}], ")"}]}], 
    RowBox[{"16", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], "3"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"2", " ", "b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b1", " ", "c"}], "-", 
       RowBox[{"b", " ", "c1"}]}], ")"}], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"b", "+", 
        RowBox[{"c", " ", "x"}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"a", " ", "c"}]}]]], "]"}]}], 
    RowBox[{"16", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}], 
      RowBox[{"7", "/", "2"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898352231058397`*^9, 3.5898352305502653`*^9}, {
   3.5898355703016977`*^9, 3.5898355755479984`*^9}, {3.589835608937908*^9, 
   3.58983561632633*^9}, 3.5956212310616665`*^9, 3.595621594132175*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5.n", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834992433646*^9, {3.5956212060016317`*^9, 
   3.5956212217116537`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"b1", "+", 
      RowBox[{"c1", " ", "x"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"2", " ", "b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["c1", 
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"2", " ", "b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]]}]]}], "+", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b1", " ", "c"}], "-", 
        RowBox[{"b", " ", "c1"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", "-", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"a", " ", "c"}]}]], "+", 
           RowBox[{"c", " ", "x"}]}], 
          RowBox[{"2", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"a", " ", "c"}]}]]}]]}], ")"}], 
       RowBox[{"n", "-", "1"}]]}], 
     RowBox[{"2", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"2", " ", "b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]]}]], 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{
      RowBox[{"1", "-", "n"}], ",", "n", ",", 
      RowBox[{"2", "-", "n"}], ",", 
      FractionBox[
       RowBox[{"b", "+", 
        RowBox[{"c", " ", "x"}], "+", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"a", " ", "c"}]}]]}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"a", " ", "c"}]}]]}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898352231058397`*^9, 3.5898352305502653`*^9}, {
   3.5898355703016977`*^9, 3.5898355755479984`*^9}, {3.589835608937908*^9, 
   3.58983561632633*^9}, 3.6274353850165863`*^9, 3.6274354525746813`*^9, 
   3.6274354948067403`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.5898349952288055`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{"3", "+", 
      RowBox[{"6", " ", "x"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox["3"]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "-", 
      SqrtBox["3"], "+", 
      RowBox[{"2", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["3"]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", 
      SqrtBox["3"], "+", 
      RowBox[{"2", " ", "x"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.589835248695303*^9, 3.5898352562727365`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #7", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834998651002*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "x"}], "-", "3"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"6", " ", "x"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"5", "+", 
     RowBox[{"4", " ", "x"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"6", " ", "x"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{"3", "+", 
     RowBox[{"2", " ", "x"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"6", " ", "x"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["3"]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898352704975505`*^9, 3.5898352766769037`*^9}, {
   3.589835526166174*^9, 3.589835529827383*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #8", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589835009380615*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", "-", "1"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"5", " ", "x"}], "+", "4"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"7", " ", "x"}], "+", "13"}], 
    RowBox[{"9", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"5", " ", "x"}], "+", "4"}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["7", "27"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "1"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["7", "27"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "4"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898352877805386`*^9, 3.5898352964320335`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #9", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.5898350122887816`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"3", " ", "x"}], "+", "2"}], ")"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "3"}], 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"3", " ", "x"}], "+", "2"}], ")"}], "4"]}]]}], "+", 
   FractionBox[
    RowBox[{"7", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", "3"}], ")"}]}], 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"3", " ", "x"}], "+", "2"}], ")"}], "3"]}]], "-", 
   FractionBox[
    RowBox[{"35", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", "3"}], ")"}]}], 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"3", " ", "x"}], "+", "2"}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", "3"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"3", " ", "x"}], "+", "2"}]], "+", 
   RowBox[{"70", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "1"}], "]"}]}], "-", 
   RowBox[{"70", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "2"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898353155761285`*^9, 3.58983532258453*^9}, {
   3.589835498562595*^9, 3.5898355145335083`*^9}, {3.6967145539246473`*^9, 
   3.6967145752850857`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 10 - 12 (p. 109)", "Section"],

Cell[CellGroupData[{

Cell["Problem #10", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, {3.5898350149319324`*^9, 3.589835015293954*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"7", "-", 
         RowBox[{"6", " ", "x"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"490", " ", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   FractionBox["69", 
    RowBox[{"1715", " ", "x"}]], "-", 
   FractionBox[
    RowBox[{"2", "-", 
     RowBox[{"3", " ", "x"}]}], 
    RowBox[{"35", " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"6", " ", "x"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "-", 
   RowBox[{
    FractionBox["234", 
     RowBox[{"12005", " ", 
      SqrtBox["5"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"3", "-", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["5"]], "]"}]}], "+", 
   FractionBox[
    RowBox[{"80", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "2401"], "-", 
   FractionBox[
    RowBox[{"40", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"7", "-", 
       RowBox[{"6", " ", "x"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}]}], "2401"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.589835339173478*^9, 3.589835345603846*^9}, {
   3.5898354733821545`*^9, 3.589835478395441*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #11", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, {3.5898350177390933`*^9, 3.5898350179471054`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "9"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"3", " ", "x"}], "+", "2"}], ")"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"735", " ", "x"}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "8"], " ", 
     RowBox[{"(", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "x"}]}], ")"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"3", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}], "4"]}]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"110", "+", 
       RowBox[{"81", " ", "x"}]}], ")"}]}], 
    RowBox[{"12", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"3", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}], "3"]}]], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"184", "+", 
       RowBox[{"135", " ", "x"}]}], ")"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"3", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"2206", "+", 
       RowBox[{"1593", " ", "x"}]}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"3", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "-", 
   RowBox[{"1471", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}], "+", 
   RowBox[{"1472", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.589835365907007*^9, 3.5898353742134824`*^9}, 
   3.639589841459836*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #12", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, {3.589835020023224*^9, 3.5898350202572374`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], ")"}], "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"5", " ", "x"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"7", "+", 
       RowBox[{"6", " ", "x"}]}], ")"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"5", " ", "x"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "4"]}]], "+", 
   FractionBox[
    RowBox[{"73", "+", 
     RowBox[{"62", " ", "x"}]}], 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"5", " ", "x"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "3"]}]], "-", 
   FractionBox[
    RowBox[{"155", " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"4", " ", "x"}]}], ")"}]}], 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"5", " ", "x"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"620", " ", 
     RowBox[{"(", 
      RowBox[{"5", "+", 
       RowBox[{"4", " ", "x"}]}], ")"}]}], 
    RowBox[{"3", "+", 
     RowBox[{"5", " ", "x"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}]}]], "+", 
   RowBox[{"2480", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "1"}], "]"}]}], "-", 
   RowBox[{"2480", " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "3"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.589835385401122*^9, 3.589835393667595*^9}, {
   3.696714722292946*^9, 3.6967147344931674`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 13 - 14 (p. 113)", "Section"],

Cell[CellGroupData[{

Cell["Problem #13", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, {3.5898350223943596`*^9, 3.5898350226383734`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "3"], 
     SuperscriptBox["x", "7"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["a", "3"], 
     RowBox[{"6", " ", 
      SuperscriptBox["x", "6"]}]]}], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", "2"], " ", "b"}], 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "4"]}]], "-", 
   FractionBox[
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["b", "2"]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]], "-", 
   RowBox[{
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"Log", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.589835407546389*^9, 3.5898354146507955`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #14", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, {3.5898350245924854`*^9, 3.589835024868501*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "13"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["x", "4"]}], ")"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "10"], 
     RowBox[{"16", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "+", 
         SuperscriptBox["x", "4"]}], ")"}], "4"]}]]}], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "6"]}], 
    RowBox[{"96", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["x", "4"]}], ")"}], "3"]}]], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"128", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["x", "4"]}], ")"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"256", " ", 
     SuperscriptBox["a", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "4"], "+", 
       SuperscriptBox["x", "4"]}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["5", 
     RowBox[{"256", " ", 
      SuperscriptBox["a", "6"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      SuperscriptBox["x", "2"], 
      SuperscriptBox["a", "2"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898354255234175`*^9, 3.5898354548540945`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Chapter 4 (p. 114-200)\n",
 StyleBox["Algebraic Function Integration Problems",
  FontSize->24]
}], "Subtitle",
 CellChangeTimes->{{3.5950910754931736`*^9, 3.59509110077662*^9}, {
  3.595091339326264*^9, 3.5950913478157496`*^9}, {3.5950916702111893`*^9, 
  3.595091674556438*^9}, {3.5952739623168087`*^9, 3.5952739629468093`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->28],

Cell[CellGroupData[{

Cell["Problems 1 - 9 (p. 115-116)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9}],

Cell[CellGroupData[{

Cell["Problem #1", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"3", "/", "2"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SqrtBox["x"]}], "-", "x"}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox["x", 
      RowBox[{"7", "/", "2"}]]}], "7"], "-", 
   SuperscriptBox["x", "4"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", 
      RowBox[{"9", "/", "2"}]]}], "9"], "+", 
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox["x", 
      RowBox[{"11", "/", "2"}]]}], "11"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "6"]}], "3"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", 
      RowBox[{"13", "/", "2"}]]}], "13"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947877240288563`*^9, 
   3.5947877307032375`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"3", "/", "2"}]], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", 
         RowBox[{"3", "/", "5"}]]}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["x", 
        RowBox[{"3", "/", "2"}]]}], "-", 
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"2", "/", "3"}]], "3"]}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"45", " ", 
      SuperscriptBox["x", 
       RowBox[{"43", "/", "15"}]]}], "43"]}], "+", 
   FractionBox[
    RowBox[{"360", " ", 
     SuperscriptBox["x", 
      RowBox[{"37", "/", "10"}]]}], "37"], "+", 
   FractionBox[
    RowBox[{"60", " ", 
     SuperscriptBox["x", 
      RowBox[{"113", "/", "30"}]]}], "113"], "-", 
   FractionBox[
    RowBox[{"120", " ", 
     SuperscriptBox["x", 
      RowBox[{"23", "/", "5"}]]}], "23"], "-", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"14", "/", "3"}]], "14"], "+", 
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox["x", 
      RowBox[{"11", "/", "2"}]]}], "11"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594787739353732*^9, 
   3.59478774770821*^9}, {3.594827735082012*^9, 3.5948277402793093`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "+", "x"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"1", "+", "x"}]]}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "+", "x"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594787757812788*^9, 
   3.594787766982313*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #4", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "+", "x"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["2", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "-", "x"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947877754997997`*^9, 
   3.5947877818711643`*^9}, {3.59552653031241*^9, 3.595526533562414*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", "x"}]], "+", "1"}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", "x"}]], "-", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "+", 
   RowBox[{"4", " ", 
    SqrtBox[
     RowBox[{"1", "+", "x"}]]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{"1", "+", "x"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947878084986873`*^9, 
   3.594787815316077*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"2", "/", "3"}]], "-", 
      SqrtBox[
       RowBox[{"1", "+", "x"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"6", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"1", "/", "6"}]]}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "+", 
   RowBox[{"6", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"1", "/", "6"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947878250916367`*^9, 
   3.594787831366995*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #7", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", 
         RowBox[{"1", "/", "4"}]]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SqrtBox["x"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["12", "7"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", 
        RowBox[{"1", "/", "4"}]]}], ")"}], 
     RowBox[{"7", "/", "3"}]]}], "-", 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", 
        RowBox[{"1", "/", "4"}]]}], ")"}], 
     RowBox[{"4", "/", "3"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594787845894826*^9, 
   3.5947878517221594`*^9}, {3.5955271489932756`*^9, 3.5955271527832813`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #8", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["2", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     SqrtBox[
      RowBox[{"1", "+", "x"}]]}]], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SqrtBox[
      RowBox[{"1", "+", "x"}]]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]], "+", 
   FractionBox[
    RowBox[{"15", " ", 
     SqrtBox[
      RowBox[{"1", "+", "x"}]]}], 
    RowBox[{"4", " ", "x"}]], "-", 
   RowBox[{
    FractionBox["15", "4"], " ", 
    RowBox[{"ArcTanh", "[", 
     SqrtBox[
      RowBox[{"1", "+", "x"}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947878614807177`*^9, 
   3.5947878672830496`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #9", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "5"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], 
       RowBox[{"7", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["2", 
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], 
      RowBox[{"5", "/", "2"}]], " ", 
     SuperscriptBox["x", "4"]}]], "+", 
   FractionBox["26", 
    RowBox[{"15", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     SuperscriptBox["x", "4"]}]], "+", 
   FractionBox["286", 
    RowBox[{"15", " ", 
     SqrtBox[
      RowBox[{"1", "-", "x"}]], " ", 
     SuperscriptBox["x", "4"]}]], "-", 
   FractionBox[
    RowBox[{"429", " ", 
     SqrtBox[
      RowBox[{"1", "-", "x"}]]}], 
    RowBox[{"20", " ", 
     SuperscriptBox["x", "4"]}]], "-", 
   FractionBox[
    RowBox[{"1001", " ", 
     SqrtBox[
      RowBox[{"1", "-", "x"}]]}], 
    RowBox[{"40", " ", 
     SuperscriptBox["x", "3"]}]], "-", 
   FractionBox[
    RowBox[{"1001", " ", 
     SqrtBox[
      RowBox[{"1", "-", "x"}]]}], 
    RowBox[{"32", " ", 
     SuperscriptBox["x", "2"]}]], "-", 
   FractionBox[
    RowBox[{"3003", " ", 
     SqrtBox[
      RowBox[{"1", "-", "x"}]]}], 
    RowBox[{"64", " ", "x"}]], "-", 
   RowBox[{
    FractionBox["3003", "64"], " ", 
    RowBox[{"ArcTanh", "[", 
     SqrtBox[
      RowBox[{"1", "-", "x"}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594787879919772*^9, 
   3.5947878854070864`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 10 - 12 (p. 117-118)", "Section",
 CellChangeTimes->{
  3.5947859030967045`*^9, {3.594786312986149*^9, 3.594786332729278*^9}}],

Cell[CellGroupData[{

Cell["Problem #10", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.5947860539813347`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "5"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], 
       RowBox[{"2", "/", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], 
     RowBox[{"1", "/", "3"}]], 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "4"]}]], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], 
    RowBox[{"36", " ", 
     SuperscriptBox["x", "3"]}]], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], 
    RowBox[{"27", " ", 
     SuperscriptBox["x", "2"]}]], "+", 
   FractionBox[
    RowBox[{"55", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], 
    RowBox[{"81", " ", "x"}]], "-", 
   RowBox[{
    FractionBox["110", 
     RowBox[{"81", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]}], 
      SqrtBox["3"]], "]"}]}], "+", 
   RowBox[{
    FractionBox["55", "81"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}], "-", 
   FractionBox[
    RowBox[{"55", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "243"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594787912823654*^9, 
   3.59478792043209*^9}, {3.5948268148863797`*^9, 3.59482684286598*^9}, 
   3.594827657630582*^9, {3.5948451041914682`*^9, 3.5948451173432207`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #11", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.5947860572075195`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{"1", "-", "x"}], 
      RowBox[{"1", "+", "x"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], 
    SqrtBox[
     FractionBox[
      RowBox[{"1", "-", "x"}], 
      RowBox[{"1", "+", "x"}]]]}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", 
     SqrtBox[
      FractionBox[
       RowBox[{"1", "-", "x"}], 
       RowBox[{"1", "+", "x"}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594787931545725*^9, 
   3.594787938435119*^9}, {3.594827143596181*^9, 3.5948271500435495`*^9}, {
   3.5955273003834877`*^9, 3.5955273030734916`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #12", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.5947860588966155`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{"x", "-", "a"}], 
      RowBox[{"b", "-", "x"}]]], "x", 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"x", "-", "a"}], 
        RowBox[{"b", "-", "x"}]]]}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"3", " ", "b"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"b", "-", "x"}], ")"}], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{"x", "-", "a"}], 
      RowBox[{"b", "-", "x"}]]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"3", " ", "b"}]}], ")"}], " ", 
    RowBox[{"ArcTan", "[", 
     SqrtBox[
      FractionBox[
       RowBox[{"x", "-", "a"}], 
       RowBox[{"b", "-", "x"}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594787948573699*^9, 
   3.5947879553440866`*^9}, {3.5948268728066926`*^9, 3.594826892374812*^9}, {
   3.594827089781103*^9, 3.594827107247102*^9}, {3.5955273327935333`*^9, 
   3.5955273349535365`*^9}, 3.595543018549686*^9, {3.5955634385588417`*^9, 
   3.595563461808874*^9}, 3.5955635112689433`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 13 - 15 (p. 119-120)", "Section",
 CellChangeTimes->{
  3.5947859030967045`*^9, {3.594786312986149*^9, 3.594786338418604*^9}}],

Cell[CellGroupData[{

Cell["Problem #13", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.594786070314269*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"x", "-", "5"}]], " ", 
      SqrtBox[
       RowBox[{"x", "+", "3"}]]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "25"}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      SqrtBox[
       RowBox[{"x", "-", "5"}]], " ", 
      SqrtBox[
       RowBox[{"x", "+", "3"}]]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"3", " ", 
      SqrtBox["5"]}]], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["5"], " ", 
       SqrtBox[
        RowBox[{"x", "+", "3"}]]}], 
      SqrtBox[
       RowBox[{"x", "-", "5"}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948278868476925`*^9, 
   3.5948279362925205`*^9}, {3.631489548920307*^9, 3.6314895735987186`*^9}, {
   3.6314899204105554`*^9, 3.631489923753747*^9}, {3.6574911361403694`*^9, 
   3.6574911658156223`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #14", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.5947860758785872`*^9, {
   3.594828061391676*^9, 3.5948280638198147`*^9}, {3.595534571103667*^9, 
   3.5955345716936674`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"1", "/", "4"}]], " ", 
      SqrtBox[
       RowBox[{"1", "+", "x"}]]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", "x"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         RowBox[{"1", "-", "x"}]], "-", 
        SqrtBox[
         RowBox[{"1", "+", "x"}]]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["5", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], 
     RowBox[{"3", "/", "4"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], 
     RowBox[{"1", "/", "4"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"3", "/", "4"}]]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], 
     RowBox[{"5", "/", "4"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"3", "/", "4"}]]}], "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"5", "/", "4"}]]}], 
    RowBox[{"24", " ", 
     SqrtBox[
      RowBox[{"1", "-", "x"}]]}]], "+", 
   FractionBox[
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"5", "/", "4"}]]}], 
    RowBox[{"6", " ", 
     SqrtBox[
      RowBox[{"1", "-", "x"}]]}]], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"5", "/", "4"}]]}], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "x"}], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "x"}], ")"}], 
         RowBox[{"1", "/", "4"}]]]}], "]"}]}], 
    RowBox[{"8", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "x"}], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "x"}], ")"}], 
         RowBox[{"1", "/", "4"}]]]}], "]"}]}], 
    RowBox[{"8", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", "x"}]], 
       SqrtBox[
        RowBox[{"1", "+", "x"}]]], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "x"}], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], 
        RowBox[{"1", "/", "4"}]]]}], "]"}], 
    RowBox[{"8", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", "x"}]], 
       SqrtBox[
        RowBox[{"1", "+", "x"}]]], "+", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "x"}], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], 
        RowBox[{"1", "/", "4"}]]]}], "]"}], 
    RowBox[{"8", " ", 
     SqrtBox["2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594827968205346*^9, 
   3.594827976105798*^9}, 3.611254746229421*^9, 3.6112983514941344`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #15", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.594786088970336*^9, {
   3.594828048447935*^9, 3.594828050528054*^9}, {3.5955346064837165`*^9, 
   3.595534607093717*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"2", "/", "3"}]], " ", 
      SqrtBox[
       RowBox[{"1", "-", "x"}]]}], 
     RowBox[{
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", "x"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], 
        RowBox[{"2", "/", "3"}]]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], 
        RowBox[{"1", "/", "3"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], 
        RowBox[{"5", "/", "6"}]]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "12"]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"3", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SqrtBox[
     RowBox[{"1", "-", "x"}]], " ", "x", " ", 
    SqrtBox[
     RowBox[{"1", "+", "x"}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], 
     RowBox[{"1", "/", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"3", " ", "x"}]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], 
     RowBox[{"1", "/", "6"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"5", "/", "6"}]], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"3", " ", "x"}]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], 
     RowBox[{"5", "/", "6"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"1", "/", "6"}]], " ", 
    RowBox[{"(", 
     RowBox[{"10", "+", 
      RowBox[{"3", " ", "x"}]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], 
       RowBox[{"1", "/", "6"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], 
       RowBox[{"1", "/", "6"}]]], "]"}]}], "-", 
   FractionBox[
    RowBox[{"4", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "x"}], ")"}], 
         RowBox[{"1", "/", "3"}]], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "x"}], ")"}], 
          RowBox[{"1", "/", "3"}]]}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "x"}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]], "]"}]}], 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], "-", 
   RowBox[{
    FractionBox["5", "6"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], 
        RowBox[{"1", "/", "3"}]], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], 
        RowBox[{"1", "/", "6"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], 
        RowBox[{"1", "/", "6"}]]}]], "]"}]}], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], 
        RowBox[{"1", "/", "6"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], 
        RowBox[{"1", "/", "6"}]]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "x"}], ")"}], 
        RowBox[{"1", "/", "3"}]], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]], "]"}], 
    RowBox[{"6", " ", 
     SqrtBox["3"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594827998474077*^9, 
   3.5948280069795637`*^9}, {3.5948280394884233`*^9, 3.594828043084629*^9}, {
   3.59485146088805*^9, 3.594851465223298*^9}, {3.595527557283848*^9, 
   3.5955275616038537`*^9}, 3.595619409039116*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 16 - 21 (p. 127)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.594786365023125*^9}],

Cell[CellGroupData[{

Cell["Problem #16", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.594786107888418*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "4"]}], ")"}], 
      RowBox[{"1", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "4"]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947880623262053`*^9, 
   3.5947880691135936`*^9}, {3.594831340978257*^9, 3.594831357384196*^9}, {
   3.594831390450087*^9, 3.5948313934322577`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #17", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.594786109191492*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", "2"}], ")"}], "5"]}], ")"}], 
      RowBox[{"1", "/", "4"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", "2"}], ")"}], "5"]}], ")"}], 
     RowBox[{"1", "/", "4"}]]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947880809802723`*^9, 
   3.5947880867076*^9}, 3.594831323596263*^9, {3.5948313979575167`*^9, 
   3.5948314017727346`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #18", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.59478611072358*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "7"]}], ")"}], 
      RowBox[{"1", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}]}], 
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], "7"]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}], "+", 
   FractionBox[
    RowBox[{"9", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}]}], 
    RowBox[{"16", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "7"]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947880938140063`*^9, 
   3.594788100113367*^9}, {3.594831300502942*^9, 3.594831309068432*^9}, {
   3.594831367129753*^9, 3.5948313705919514`*^9}, {3.5948314066530137`*^9, 
   3.594831413158386*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #19", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.5947861116806345`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"x", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    SqrtBox["3"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["3"]], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"x", "+", "1"}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]]}], ")"}]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "1"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"x", "-", "1"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594788114108167*^9, 
   3.59478812360071*^9}, 3.594829514482788*^9, {3.5954795877800756`*^9, 
   3.5954797229302645`*^9}, 3.6275798388474083`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #20", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, {
   3.5947861125156827`*^9, 3.594786124417363*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", "+", 
      FractionBox["1", "x"]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", "1"}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{"x", "-", "2"}], ")"}]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}]}], 
     RowBox[{"3", " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], "3"], " ", 
        RowBox[{"(", 
         RowBox[{"x", "-", "2"}], ")"}]}]]}]]}], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{"x", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"ArcSinh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"x", "-", "2"}]], 
       SqrtBox["3"]], "]"}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}]}]]], "-", 
   FractionBox[
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox[
      RowBox[{"x", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         RowBox[{"x", "+", "1"}]]}], 
       SqrtBox[
        RowBox[{"x", "-", "2"}]]], "]"}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}]}]]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947881375435076`*^9, 
   3.594788143771864*^9}, {3.5948297221296644`*^9, 3.5948297314411974`*^9}, {
   3.594831025510214*^9, 3.5948310807223716`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #21", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.5947861342119236`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"x", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"x", "+", "1"}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]], "x"]}], "-", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["3"]], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["3"]], 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"x", "+", "1"}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]]}], ")"}]}], "]"}]}], "-", 
   RowBox[{
    SqrtBox["3"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["3"]], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{"x", "+", "1"}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]]}], ")"}]}], "]"}]}], "+", 
   "\[IndentingNewLine]", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], "6"], "-", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "1"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"x", "-", "1"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "x"}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"x", "-", "1"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "1"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "x"}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947881602978086`*^9, 
   3.5947881679712477`*^9}, {3.594829853281166*^9, 3.5948298914753504`*^9}, 
   3.5948309846318755`*^9, {3.5956100169188366`*^9, 3.595610112828971*^9}, {
   3.5956101747490573`*^9, 3.5956102582591743`*^9}, 3.5956102978692293`*^9, {
   3.627580857076228*^9, 3.6275808671842427`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 22 - 27 (p. 128)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.594786371980523*^9}],

Cell[CellGroupData[{

Cell["Problem #22", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.594786134571944*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"2", " ", "x"}], "-", "3"}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "-", "x"}], 
    RowBox[{"12", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"2", " ", "x"}], "-", "3"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "-", 
   FractionBox[
    RowBox[{"1", "-", "x"}], 
    RowBox[{"24", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"2", " ", "x"}], "-", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594788199860072*^9, 
   3.5947882055403967`*^9}, {3.5948317363478713`*^9, 3.5948317392910395`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #23", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.5947861351229753`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "3"], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"3", " ", "x"}], "+", "9"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"3", "-", "x"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x"}]], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", "x"}]], "2"], "]"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"5", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "9"}]]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594788211649746*^9, 
   3.5947882196612043`*^9}, 3.594831781797471*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #24", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.594786135475996*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "-", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "-", "x"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    RowBox[{"64", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "-", 
   FractionBox[
    RowBox[{"15", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "-", "x"}], ")"}], "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    RowBox[{"256", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"15", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "-", "x"}], ")"}], "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "+", "x"}]], "2"], "]"}]}], 
    RowBox[{"512", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594788229707779*^9, 
   3.594788235859131*^9}, {3.594831813925308*^9, 3.5948318231058335`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #25", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.5947861358360167`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"1", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    SqrtBox["3"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["3"]], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "3"}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "3"], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
          RowBox[{"1", "/", "3"}]]]}], ")"}]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "1"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"x", "-", "3"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "3"], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox["x", "2"]}], "+", 
          RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947882452906704`*^9, 
   3.59478825210506*^9}, {3.5948318908307076`*^9, 3.5948318968560514`*^9}, 
   3.594832866896535*^9, {3.595480268711029*^9, 3.5954803794111843`*^9}, 
   3.627581107942963*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #26", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.5947861362080374`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"2", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "3"], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
     RowBox[{"2", "/", "3"}]]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947882662638702`*^9, 
   3.5947882727552414`*^9}, 3.594831902712387*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #27", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.594786136567058*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"4", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"3", "-", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"4", "/", "3"}]]}]], "+", 
   FractionBox[
    RowBox[{"9", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "-", "x"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    RowBox[{"80", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"4", "/", "3"}]]}]], "-", 
   FractionBox[
    RowBox[{"27", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "-", "x"}], ")"}], "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    RowBox[{"320", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}], "+", "9"}], ")"}], 
      RowBox[{"4", "/", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947882850709457`*^9, 
   3.594788291045287*^9}, {3.59483191203592*^9, 3.5948319174402294`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 28 - 37 (p. 143-144)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.594786381699079*^9}],

Cell[CellGroupData[{

Cell["Problem #28", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.59478614201737*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "x"}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}], 
   RowBox[{"ArcSin", "[", 
    FractionBox[
     RowBox[{"3", "-", 
      RowBox[{"4", " ", "x"}]}], 
     SqrtBox["41"]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594788315852706*^9, 
   3.5947883216610384`*^9}, {3.594832973549635*^9, 3.594832978079894*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #29", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.5947861447035236`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       RowBox[{"4", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"ArcSin", "[", 
    RowBox[{"2", "-", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947883279763994`*^9, 
   3.594788335135809*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #30", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.5947861510648875`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "2"}], "-", 
       RowBox[{"5", " ", "x"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"ArcSin", "[", 
    RowBox[{"5", "+", 
     RowBox[{"6", " ", "x"}]}], "]"}], 
   SqrtBox["3"]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947883411251516`*^9, 
   3.594788347510517*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #31", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.5947861515259137`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "4"}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["5"], " ", "x"}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox["5"]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947883562980194`*^9, 
   3.5947883644044833`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #32", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.594786151959939*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "4"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}], "+", "1"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SqrtBox["15"]}]], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["15"], " ", "x"}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594788376886197*^9, 
   3.5947883847676477`*^9}, {3.5948332230319047`*^9, 3.5948332278541803`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #33", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.594786152314959*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SuperscriptBox["x", "2"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"5", "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"5", "-", 
       SuperscriptBox["x", "2"]}]], 
     SqrtBox["2"]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594788391575037*^9, 
   3.5947883967863355`*^9}, {3.59483325809591*^9, 3.594833261662114*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #34", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.594786152735983*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"5", "-", 
        SuperscriptBox["x", "2"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"3", "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"3", "-", 
       SuperscriptBox["x", "2"]}]], 
     SqrtBox["2"]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594788407475947*^9, 
   3.5947884135592947`*^9}, {3.5948332678664694`*^9, 3.5948332711976595`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #35", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.5947861530960035`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "-", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox[
       RowBox[{"2", "+", 
        SuperscriptBox["x", "2"]}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["3"], " ", "x"}], 
      SqrtBox[
       RowBox[{"2", "+", 
        SuperscriptBox["x", "2"]}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947884189816046`*^9, 
   3.594788427338083*^9}, {3.5948333332702103`*^9, 3.5948333367134066`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #36", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.5947861534540243`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "4"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"2", " ", 
       SqrtBox["7"]}]]}], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"5", "+", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["7"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", "x"}], "+", "4"}]]}]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "4"}]], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947884344684906`*^9, 
   3.594788442413945*^9}, {3.5948333899084496`*^9, 3.5948334059633675`*^9}, {
   3.594833577974206*^9, 3.5948335806873617`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #37", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.5947861538090444`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", "8"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "5"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"4", " ", 
       SqrtBox["3"]}]]}], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", "x"}], 
      RowBox[{
       SqrtBox["3"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", "x"}], "+", "5"}]]}]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"12", " ", 
      SqrtBox["13"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"7", "+", 
       RowBox[{"3", " ", "x"}]}], 
      RowBox[{
       SqrtBox["13"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", "x"}], "+", "5"}]]}]], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"ArcTanh", "[", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", " ", "x"}], "+", "5"}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5947884519564905`*^9, 
   3.5947884576188145`*^9}, {3.594833465423769*^9, 3.5948334766404104`*^9}, {
   3.594833563268365*^9, 3.5948335701377583`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 38 - 42 (p. 145-146)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.5947863891165032`*^9}],

Cell[CellGroupData[{

Cell["Problem #38", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.5947861541750655`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "x", "+", "4"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"4", " ", "x"}], "+", "5"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     SqrtBox["11"]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"4", " ", "x"}], "+", "5"}]], 
      SqrtBox["11"]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["165"]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox[
        FractionBox["11", "15"]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "x"}], "+", "1"}], ")"}]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"4", " ", "x"}], "+", "5"}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948362015722675`*^9, 
   3.594836207850627*^9}, {3.5948363243412895`*^9, 3.5948363678357773`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #39", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.5947861593663626`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", "+", "3"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", "x", "+", "1"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"x", "-", "1"}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", "x", "+", "1"}]]}]], "]"}]}], "+", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"x", "+", "1"}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", "x", "+", "1"}]]}]], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948362170091505`*^9, 
   3.594836222921489*^9}, {3.5948363806585107`*^9, 3.594836384154711*^9}, 
   3.5955280729445696`*^9, 3.5959707876634192`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #40", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.594786165081689*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"4", " ", "x"}], "+", "4"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"6", " ", "x"}], "-", "1"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["5", 
      RowBox[{"6", " ", 
       SqrtBox["14"]}]]}], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["7"], 
       RowBox[{"(", 
        RowBox[{"2", "-", "x"}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"], " ", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"6", " ", "x"}], "-", "1"}]]}]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"3", " ", 
      SqrtBox["7"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["7"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"6", " ", "x"}], "-", "1"}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594836240837513*^9, 
   3.594836251062098*^9}, {3.5948363979074974`*^9, 3.594836429761319*^9}, {
   3.5955283600849714`*^9, 3.595528418315053*^9}, {3.5959702439826574`*^9, 
   3.595970255052673*^9}, {3.595970285522715*^9, 3.595970293152726*^9}, {
   3.5959703290727763`*^9, 3.5959703306827784`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #41", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.594786165572717*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"A", " ", "x"}], "+", "B"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"18", " ", "x"}], "+", "17"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"10", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"22", " ", "x"}], "+", "13"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "A"}], "+", "B"}], 
      SqrtBox["35"]]}], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["35"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", "x"}], ")"}]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"10", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"22", " ", "x"}], "+", "13"}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", "B"}], 
     RowBox[{"2", " ", 
      SqrtBox["35"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["35"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"10", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"22", " ", "x"}], "+", "13"}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.59483626927314*^9, 
   3.594836276744567*^9}, {3.5948364391718574`*^9, 3.594836477551052*^9}, {
   3.594836523500681*^9, 3.594836526303841*^9}, 3.5955286662354*^9, 
   3.595528697435444*^9, {3.5955287317654915`*^9, 3.5955287541155233`*^9}, 
   3.59552883762564*^9, {3.5959701831525717`*^9, 3.5959701949425883`*^9}, {
   3.5959703080927467`*^9, 3.595970310852751*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #42", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.5947861659297376`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", "-", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"18", " ", "x"}], "+", "17"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"10", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"22", " ", "x"}], "+", "13"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     SqrtBox["35"]}]], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["35"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "x"}], ")"}]}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"10", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"22", " ", "x"}], "+", "13"}]]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948362881782207`*^9, 
   3.5948362966107035`*^9}, {3.594836485736521*^9, 3.5948365149211903`*^9}, {
   3.595528874855692*^9, 3.5955289025757313`*^9}, {3.595967740389152*^9, 
   3.595967758759178*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 43 - 49 (p. 163)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.5947863980900164`*^9}],

Cell[CellGroupData[{

Cell["Problem #43", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.594786166378763*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "4"], " ", 
    SqrtBox[
     RowBox[{"5", "-", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["25", "16"]}], " ", "x", " ", 
    SqrtBox[
     RowBox[{"5", "-", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   RowBox[{
    FractionBox["5", "24"], " ", 
    SuperscriptBox["x", "3"], " ", 
    SqrtBox[
     RowBox[{"5", "-", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["x", "5"], " ", 
    SqrtBox[
     RowBox[{"5", "-", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   RowBox[{
    FractionBox["125", "16"], " ", 
    RowBox[{"ArcSin", "[", 
     FractionBox["x", 
      SqrtBox["5"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948373129228334`*^9, 
   3.5948373192631955`*^9}, {3.5948375447340918`*^9, 3.594837556201748*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #44", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.5947861667307835`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "6"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", "2"}]], 
     RowBox[{"10", " ", 
      SuperscriptBox["x", "5"]}]]}], "+", 
   FractionBox[
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "2"}]], 
    RowBox[{"15", " ", 
     SuperscriptBox["x", "3"]}]], "-", 
   FractionBox[
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "2"}]], 
    RowBox[{"15", " ", "x"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594837326798627*^9, 
   3.594837337800256*^9}, {3.5948375864864798`*^9, 3.5948375925568275`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #45", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.5947861671328063`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "+", "3"}], ")"}], 
      RowBox[{"7", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"15", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "+", "3"}], ")"}], 
      RowBox[{"5", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"4", " ", "x"}], 
    RowBox[{"135", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "+", "3"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"8", " ", "x"}], 
    RowBox[{"405", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}], "+", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594837344321629*^9, 
   3.594837351834059*^9}, {3.5948376549353952`*^9, 3.5948376597156687`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #46", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.5947861674888268`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"a", " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}]]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"Log", "[", 
   RowBox[{"a", "+", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}]]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948373616236186`*^9, 
   3.5948373686160183`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #47", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.594786167844847*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "-", "x", "+", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}]]], "+", 
   RowBox[{"ArcSinh", "[", "x", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594837382559816*^9, 
   3.5948373903002586`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #48", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.5947861682218685`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}]], 
     RowBox[{"2", "+", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"ArcSinh", "[", "x", "]"}], "-", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["2"]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox["x", 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948374008508625`*^9, 
   3.594837407783259*^9}, {3.5948374400131025`*^9, 3.5948374437903185`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #49", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.594786168576889*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"x", " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}]]}], 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]]}], "+", 
   RowBox[{
    FractionBox["3", 
     RowBox[{"4", " ", 
      SqrtBox["2"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox["x", 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948374154236956`*^9, 
   3.5948374558040056`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 50 - 62 (p. 164)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.59478641668508*^9}],

Cell[CellGroupData[{

Cell["Problem #50", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.594786175509286*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "6"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "-", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"ArcTanh", "[", 
    FractionBox["x", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", "2"}]]], "]"}], "-", 
   RowBox[{
    SqrtBox[
     FractionBox["3", "2"]], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox[
        FractionBox["2", "3"]], " ", "x"}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "-", "2"}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948377924942627`*^9, 
   3.5948377983195963`*^9}, {3.5948381176458607`*^9, 3.5948381216030865`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #51", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.594786175877307*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "5"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}], 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]], "+", 
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", "x"}], 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594837807602127*^9, 
   3.5948378169126596`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #52", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.5947861763183317`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"4", " ", "x"}], "-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}], 
     RowBox[{"5", "+", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "-", 
   RowBox[{"4", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   RowBox[{"5", " ", 
    RowBox[{"ArcSin", "[", "x", "]"}]}], "+", 
   FractionBox[
    RowBox[{"25", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox["x", 
       RowBox[{"2", " ", 
        SqrtBox["6"]}]], "]"}]}], 
    RowBox[{"2", " ", 
     SqrtBox["6"]}]], "-", 
   FractionBox[
    RowBox[{"25", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"5", " ", "x"}], 
       RowBox[{"2", " ", 
        SqrtBox["6"], " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}]], "]"}]}], 
    RowBox[{"2", " ", 
     SqrtBox["6"]}]], "+", 
   RowBox[{"20", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594837826289196*^9, 
   3.5948378328395705`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #53", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.594786176822361*^9, {
   3.5948381904220233`*^9, 3.594838193196182*^9}, {3.595534647043773*^9, 
   3.595534647733774*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["x", "2"], "+", "1"}]]}], ")"}], " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "+", "1"}], ")"}], 
         RowBox[{"3", "/", "2"}]], "-", 
        SuperscriptBox["x", "3"], "+", "1"}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"8", " ", "x"}], "9"], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "6"], "+", 
   FractionBox[
    RowBox[{"8", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", "1"}]]}], "9"], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", "x", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "1"}]]}], "-", 
   FractionBox[
    RowBox[{"41", " ", 
     RowBox[{"ArcSinh", "[", "x", "]"}]}], "54"], "+", 
   RowBox[{
    FractionBox["4", "27"], " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"3", " ", "x"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]], "]"}]}], "+", 
   RowBox[{
    FractionBox["4", "27"], " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", "x"}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", "1"}]]}]], "]"}]}], "+", 
   RowBox[{
    FractionBox["7", "27"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"1", "-", "x"}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", "1"}]]}]], "]"}]}], "-", 
   RowBox[{
    FractionBox["7", "54"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", 
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.59483785310773*^9, 
   3.5948378617672253`*^9}, 3.5959891244397287`*^9, {3.5959891667497897`*^9, 
   3.5959891817198114`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #54", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.594786177313389*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"2", " ", "r", " ", "x"}], "-", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "x"}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"2", " ", "r", " ", "x"}], "-", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "r", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    SuperscriptBox["r", "3"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", "r", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948378887097664`*^9, 
   3.594837896486211*^9}, 3.6381377392689753`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #55", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.5947861776694093`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"2", " ", "r", " ", "x"}], "-", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["5", "8"]}], " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "x"}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"2", " ", "r", " ", "x"}], "-", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   RowBox[{
    FractionBox["5", "12"], " ", "r", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "r", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "r", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["5", "4"], " ", 
    SuperscriptBox["r", "4"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", "r", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948379035156136`*^9, 
   3.5948379097429695`*^9}, {3.594838217271559*^9, 3.5948382278781652`*^9}, {
   3.638137781018364*^9, 3.6381378282250633`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #56", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.5947861780284295`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"2", " ", "r", " ", "x"}], "-", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["7", "8"]}], " ", 
    SuperscriptBox["r", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "x"}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"2", " ", "r", " ", "x"}], "-", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   RowBox[{
    FractionBox["7", "12"], " ", 
    SuperscriptBox["r", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "r", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "-", 
   RowBox[{
    FractionBox["7", "20"], " ", "r", " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "r", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "-", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "r", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["7", "4"], " ", 
    SuperscriptBox["r", "5"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", "r", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948379202735715`*^9, 
   3.5948379274239807`*^9}, {3.59483828320033*^9, 3.594838298312194*^9}, 
   3.6381378894655666`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #57", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.594786178396451*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"ArcTan", "[", 
     SqrtBox[
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", 
       SuperscriptBox["x", "2"]}]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", "x"}], "+", 
         SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594837944812975*^9, 
   3.594837951567362*^9}, {3.594838314761135*^9, 3.5948383185413513`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #58", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.5947861787534714`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", "x"}], "-", "2"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "3"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"5", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}]]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "2"]}]]}], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"2", " ", "x"}], "-", 
       SuperscriptBox["x", "2"]}]]}], 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", "x"}], "-", 
         SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948379587527723`*^9, 
   3.594837967508273*^9}, {3.5948383622908535`*^9, 3.594838365621044*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #59", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.5947861791074915`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"ArcSinh", "[", 
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x"}]}], 
    SqrtBox["3"]], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948379763387785`*^9, 
   3.5948379817600884`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #60", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.5947861859238815`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], 
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    SuperscriptBox["x", "2"], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"10", " ", "x"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   RowBox[{
    FractionBox["7", "16"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948379949638433`*^9, 
   3.5948380003281507`*^9}, 3.6381379941425533`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #61", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.594786186287902*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}]}], 
   RowBox[{"3", " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948380087876344`*^9, 
   3.5948380172361174`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #62", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.5947861867359276`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "x"}], ")"}]}], 
    RowBox[{"3", " ", 
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.59483802427252*^9, 
   3.5948380326860013`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 63 - 72 (p. 165)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.594786432300973*^9}],

Cell[CellGroupData[{

Cell["Problem #63", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.5947861872159553`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "x"}], ")"}]}], 
     RowBox[{"3", " ", 
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]]}]]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948384774174385`*^9, 
   3.594838483961813*^9}, 3.633033250032482*^9, 3.638138046287536*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #64", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.5947861876739817`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "64"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   RowBox[{
    FractionBox["5", "24"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["3", "128"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948384913942375`*^9, 
   3.594838500713771*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #65", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.5947861880250015`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["9", "64"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["27", "128"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594838509755288*^9, 
   3.5948385173627234`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #66", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.5947861883760214`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"5", "/", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["45", "512"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   RowBox[{
    FractionBox["5", "64"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"5", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["135", "1024"], 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594838534158684*^9, 
   3.594838548755519*^9}, {3.5948387375043144`*^9, 3.5948387422615867`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #67", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.594786188735042*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]], "x"]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"2", "+", "x"}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "+", "x", "+", 
         SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948385555299063`*^9, 
   3.59483856118423*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #68", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.594786189104063*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]], 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]]}], 
    RowBox[{"4", " ", "x"}]], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"2", "+", "x"}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "+", "x", "+", 
         SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948385698687267`*^9, 
   3.594838575998077*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #69", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.5947861894570837`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x", "+", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}], 
    RowBox[{"3", " ", "x", " ", 
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]]}]], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]]}], 
    RowBox[{"3", " ", "x"}]], "+", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"2", "+", "x"}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "+", "x", "+", 
         SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594838585437617*^9, 
   3.5948385911649446`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #70", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.5947861972965317`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x", "+", 
         SuperscriptBox["x", "2"]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}], 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"], " ", 
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]]}]], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]]}], 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "2"]}]], "+", 
   FractionBox[
    RowBox[{"37", " ", 
     SqrtBox[
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}]]}], 
    RowBox[{"12", " ", "x"}]], "-", 
   RowBox[{
    FractionBox["3", "8"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"2", "+", "x"}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "+", "x", "+", 
         SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948385993484125`*^9, 
   3.594838607122857*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #71", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.5947861976605525`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"1", "-", "x"}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594838616277381*^9, 
   3.594838622699748*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #72", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.594786198052575*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", "x"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "4"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"4", "+", "x"}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", "x"}], "+", "4"}]]}]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["7"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"5", "+", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["7"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", "x"}], "+", "4"}]]}]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "4"}]], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594838629461135*^9, 
   3.5948386372875824`*^9}, {3.594838804939172*^9, 3.5948388117475605`*^9}, {
   3.5948388430103493`*^9, 3.5948388534969487`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 73 - 79 (p. 166)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.5947864413094883`*^9, 3.5947864859370413`*^9}],

Cell[CellGroupData[{

Cell["Problem #73", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.5947861984045954`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", " ", "x"}], "+", "4"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", "x"}], "+", "4"}]], 
    RowBox[{"1", "-", "x"}]], "+", 
   RowBox[{"ArcSinh", "[", 
    FractionBox[
     RowBox[{"1", "+", "x"}], 
     SqrtBox["3"]], "]"}], "-", 
   RowBox[{
    FractionBox["2", 
     SqrtBox["7"]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"5", "+", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["7"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", "x"}], "+", "4"}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594839010083905*^9, 
   3.594839017847349*^9}, {3.594839173190234*^9, 3.5948391905182257`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #74", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.5947861988086185`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "3"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", "x"}], "+", "3"}], ")"}], "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "4"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", " ", "x"}], "+", "4"}]]}], 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", " ", "x"}], "+", "3"}], ")"}]}]], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", " ", 
      SqrtBox["2"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"x", "+", "1"}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", "x"}], "+", "4"}]]}]], "]"}]}], "+", 
   RowBox[{"ArcTanh", "[", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", "x"}], "+", "4"}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948390261758256`*^9, 
   3.594839032142167*^9}, {3.5948392438112736`*^9, 3.5948392830215163`*^9}, {
   3.594839359560894*^9, 3.5948393605789523`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #75", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.5947861991616383`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "+", "x", "-", "3"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "-", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   SqrtBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", " ", "x"}], "-", "3"}]], "+", 
   FractionBox[
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", "x"}], "-", "3"}]], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594839048213086*^9, 
   3.5948390566775703`*^9}, {3.5948394055495243`*^9, 3.594839408466691*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #76", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.5947861995706615`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "4"], "+", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "x", "+", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", "x", "+", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["7", "4"]}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "x", "+", "2"}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "x", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "x", "+", "2"}]]}], "-", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["7"]], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["3"]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", "x", "+", "2"}]]}]], "]"}]}], "-", 
   RowBox[{"ArcTanh", "[", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "x", "+", "2"}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594839068272233*^9, 
   3.594839075354638*^9}, {3.594839453163248*^9, 3.5948394901893654`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #77", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.5947861999246817`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "4"}], ")"}], 
      RowBox[{"7", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "+", "x"}], 
    RowBox[{"15", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "4"}], ")"}], 
      RowBox[{"5", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    RowBox[{"135", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "4"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], 
    RowBox[{"405", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       RowBox[{"2", " ", "x"}], "+", "4"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948390854982185`*^9, 
   3.5948390918815837`*^9}, {3.594839596268433*^9, 3.594839601169713*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #78", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.594786200292703*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"8", " ", "x"}], "+", "1"}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"4", "+", 
      RowBox[{"3", " ", "x"}]}], 
     RowBox[{"39", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"8", " ", "x"}], "+", "1"}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]]}], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "x"}]}], ")"}]}], 
    RowBox[{"169", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"8", " ", "x"}], "+", "1"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948391007780924`*^9, 
   3.5948391063124094`*^9}, {3.5948396325335073`*^9, 3.5948396353146667`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #79", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.5947862006497235`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"4", " ", "x"}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", "-", 
      RowBox[{"3", " ", "x"}]}], 
     RowBox[{"57", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "+", 
         RowBox[{"4", " ", "x"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]]}], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"3", " ", "x"}]}], ")"}]}], 
    RowBox[{"361", " ", 
     SqrtBox[
      RowBox[{"5", "+", 
       RowBox[{"4", " ", "x"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948391141028547`*^9, 
   3.594839120338211*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 80 - 84 (p. 167)", "Section",
 CellChangeTimes->{
  3.5947859030967045`*^9, 3.594786312986149*^9, 3.5947864540782185`*^9, 
   3.5947865619683895`*^9, {3.594787529560733*^9, 3.594787529910753*^9}}],

Cell[CellGroupData[{

Cell["Problem #80", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.594786207243101*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "x"}]], "-", 
   FractionBox[
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", "x"}], "+", "2"}]], 
    RowBox[{"1", "+", "x"}]], "+", 
   RowBox[{"ArcSinh", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594841118564503*^9, 
   3.594841126945983*^9}, 3.594841302968051*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #81", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.5947862077261286`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", "+", 
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   SqrtBox[
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}]], "-", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}], "+", 
   RowBox[{"2", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", 
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594841133914381*^9, 
   3.594841140745772*^9}, {3.594841344006398*^9, 3.594841372093004*^9}, 
   3.5955298365870385`*^9, {3.601580848397641*^9, 3.601580863844525*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #82", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.594786208204156*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", "1", "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "+", "x", "+", 
         SuperscriptBox["x", "2"]}]]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "3"], "9"]}], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "6"], "+", 
   RowBox[{
    FractionBox["1", "96"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}], "-", 
   RowBox[{
    FractionBox["5", "36"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["1", "64"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.59484114874923*^9, 
   3.594841156568677*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #83", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.5947862086631823`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]], "-", 
      RowBox[{"3", " ", "x"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]], "-", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "-", 
   RowBox[{"3", " ", 
    SqrtBox[
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}]]}], "+", 
   RowBox[{
    FractionBox["5", "2"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"1", "-", "x"}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "+", "x", "+", 
         SuperscriptBox["x", "2"]}]]}]], "]"}]}], "-", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"2", "+", "x"}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"1", "+", "x", "+", 
        SuperscriptBox["x", "2"]}]]}]], "]"}], "+", 
   RowBox[{"Log", "[", "x", "]"}], "-", 
   RowBox[{"4", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948411779539003`*^9, 
   3.594841186310378*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #84", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.5947862090932064`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", "+", "1"}], 
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "x"}], "+", "4"}]], "-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", "x", "+", "1"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "x", "+", "1"}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "x", "+", "1"}]]}], "-", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", "x"}], "+", "4"}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"2", " ", "x"}], "+", "4"}]]}], "+", 
   RowBox[{
    FractionBox["11", "2"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", "x"}], 
      SqrtBox["3"]], "]"}]}], "+", 
   RowBox[{
    FractionBox["43", "8"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}]}], "-", 
   RowBox[{"2", " ", 
    SqrtBox["7"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"5", " ", "x"}]}], 
      RowBox[{"2", " ", 
       SqrtBox["7"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", "x", "+", "1"}]]}]], "]"}]}], "+", 
   RowBox[{"2", " ", 
    SqrtBox["7"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "x"}]}], 
      RowBox[{
       SqrtBox["7"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", "x"}], "+", "4"}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948411993811255`*^9, 
   3.5948412072675767`*^9}, {3.594841447434314*^9, 3.5948414732767916`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 85 - 91 (p. 177)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.594786573055024*^9}],

Cell[CellGroupData[{

Cell["Problem #85", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.594786209446227*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "3"], " ", 
      SqrtBox[
       RowBox[{"x", "-", "1"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"x", "-", "1"}]], 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SqrtBox[
      RowBox[{"x", "-", "1"}]]}], 
    RowBox[{"4", " ", "x"}]], "+", 
   RowBox[{
    FractionBox["3", "4"], " ", 
    RowBox[{"ArcTan", "[", 
     SqrtBox[
      RowBox[{"x", "-", "1"}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594841645133621*^9, 
   3.5948416511169634`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #86", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.5947862098002467`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         FractionBox["3", "x"]}], ")"}], 
       RowBox[{"4", "/", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["3", "x"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594841658714398*^9, 
   3.594841668832977*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #87", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.5947862111513243`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "x"}], "-", "1"}], ")"}], 
      RowBox[{"4", "/", "3"}]], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"12", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", "1"}], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", "1"}], ")"}], 
     RowBox[{"4", "/", "3"}]], "x"], "+", 
   RowBox[{"4", " ", 
    SqrtBox["3"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "x"}], "-", "1"}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]}], 
      SqrtBox["3"]], "]"}]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", "x", "]"}]}], "-", 
   RowBox[{"6", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "x"}], "-", "1"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948416793885803`*^9, 
   3.5948416858819523`*^9}, 3.5950057964142056`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #88", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.594786211512345*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"4", "-", 
       RowBox[{"3", " ", "x"}]}], ")"}], 
     RowBox[{"4", "/", "3"}]], " ", 
    SuperscriptBox["x", "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["16", "63"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"4", "-", 
       RowBox[{"3", " ", "x"}]}], ")"}], 
     RowBox[{"7", "/", "3"}]]}], "+", 
   RowBox[{
    FractionBox["4", "45"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"4", "-", 
       RowBox[{"3", " ", "x"}]}], ")"}], 
     RowBox[{"10", "/", "3"}]]}], "-", 
   RowBox[{
    FractionBox["1", "117"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"4", "-", 
       RowBox[{"3", " ", "x"}]}], ")"}], 
     RowBox[{"13", "/", "3"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948416953884954`*^9, 
   3.5948417013168344`*^9}, {3.5948424470354877`*^9, 
   3.5948424552769585`*^9}, {3.5955303017076893`*^9, 3.5955303022976904`*^9}, 
   3.595530472557929*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #89", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.594786211884366*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", 
          RowBox[{"1", "/", "3"}]]}]}], ")"}], 
      RowBox[{"3", "/", "4"}]], "x"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", 
         RowBox[{"1", "/", "3"}]]}]}], ")"}], 
     RowBox[{"3", "/", "4"}]]}], "+", 
   RowBox[{"6", " ", 
    RowBox[{"ArcTan", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", 
          RowBox[{"1", "/", "3"}]]}]}], ")"}], 
      RowBox[{"1", "/", "4"}]], "]"}]}], "-", 
   RowBox[{"6", " ", 
    RowBox[{"ArcTanh", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", 
          RowBox[{"1", "/", "3"}]]}]}], ")"}], 
      RowBox[{"1", "/", "4"}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948417074701867`*^9, 
   3.5948417138005486`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #90", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.594786219666811*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "-", 
        RowBox[{"2", " ", 
         SqrtBox["x"]}]}], ")"}], 
      RowBox[{"3", "/", "4"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["27", "2"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"2", " ", 
        SqrtBox["x"]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "+", 
   RowBox[{
    FractionBox["27", "10"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"2", " ", 
        SqrtBox["x"]}]}], ")"}], 
     RowBox[{"5", "/", "4"}]]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"2", " ", 
        SqrtBox["x"]}]}], ")"}], 
     RowBox[{"9", "/", "4"}]]}], "+", 
   RowBox[{
    FractionBox["1", "26"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"2", " ", 
        SqrtBox["x"]}]}], ")"}], 
     RowBox[{"13", "/", "4"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948417222450323`*^9, 
   3.5948417294074416`*^9}, {3.5948424970763493`*^9, 3.5948425082819905`*^9}, 
   3.613799931943701*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #91", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.594786220098836*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox["x"]}], "-", "1"}], ")"}], 
      RowBox[{"5", "/", "4"}]], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox["x"]}], "-", "1"}], ")"}], 
      RowBox[{"5", "/", "4"}]], "x"]}], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox["x"]}], "-", "1"}], ")"}], 
      RowBox[{"1", "/", "4"}]]}], 
    RowBox[{"2", " ", 
     SqrtBox["x"]}]], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        SqrtBox["2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SqrtBox["x"]}], "-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]]}]}], "]"}]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        SqrtBox["2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SqrtBox["x"]}], "-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]]}]}], "]"}]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        SqrtBox["2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SqrtBox["x"]}], "-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]]}], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", 
          SqrtBox["x"]}], "-", "1"}]]}], "]"}]}], 
    RowBox[{"4", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        SqrtBox["2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SqrtBox["x"]}], "-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]]}], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"2", " ", 
          SqrtBox["x"]}], "-", "1"}]]}], "]"}]}], 
    RowBox[{"4", " ", 
     SqrtBox["2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948417370958815`*^9, 
   3.5948417444182997`*^9}, {3.5948425288321657`*^9, 3.59484255581771*^9}, {
   3.595530763798337*^9, 3.595530802688391*^9}, {3.5955308462984524`*^9, 
   3.5955309168685513`*^9}, {3.5966488619359274`*^9, 3.596648884642226*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 92 - 100 (p. 178)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.594786583733635*^9}],

Cell[CellGroupData[{

Cell["Problem #92", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.594786220559862*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "7"], "+", "1"}], ")"}], 
     RowBox[{"1", "/", "3"}]], " ", 
    SuperscriptBox["x", "6"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["3", "28"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "7"], "+", "1"}], ")"}], 
    RowBox[{"4", "/", "3"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948426537243094`*^9, 
   3.5948426600576715`*^9}, 3.5948429184324503`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #93", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.5947862210368896`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "6"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "7"], "+", "1"}], ")"}], 
      RowBox[{"5", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox["3", 
    RowBox[{"14", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "7"], "+", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948426673620896`*^9, 
   3.594842673792457*^9}, 3.594842921529627*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #94", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.59478622139191*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["x", "7"]}], "-", "27"}], ")"}], 
       RowBox[{"2", "/", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"21", " ", 
       SqrtBox["3"]}]]}], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"3", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["x", "7"]}], "-", "27"}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]}], 
      RowBox[{"3", " ", 
       SqrtBox["3"]}]], "]"}]}], "-", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], "18"], "+", 
   RowBox[{
    FractionBox["1", "42"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["x", "7"]}], "-", "27"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948426843550615`*^9, 
   3.594842691056445*^9}, {3.5948429645250864`*^9, 3.59484296896034*^9}, {
   3.5948477479006796`*^9, 3.5948477564881706`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #95", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.5947862218949385`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "7"], "+", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]], 
     SuperscriptBox["x", "8"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "7"], "+", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]], 
     RowBox[{"7", " ", 
      SuperscriptBox["x", "7"]}]]}], "+", 
   RowBox[{
    FractionBox["2", 
     RowBox[{"7", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "7"], "+", "1"}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]}], 
      SqrtBox["3"]], "]"}]}], "-", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], "3"], "+", 
   RowBox[{
    FractionBox["1", "7"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "7"], "+", "1"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594842699173909*^9, 
   3.594842706234313*^9}, {3.595005917417126*^9, 3.5950059211133375`*^9}, {
   3.595531098118805*^9, 3.5955311009088087`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #96", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.594786222249959*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}], 
      RowBox[{"1", "/", "4"}]], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}], 
      RowBox[{"1", "/", "4"}]], "x"]}], "-", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["2"]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", "x"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["x", "4"]}]}], ")"}], 
       RowBox[{"1", "/", "4"}]]], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["2"]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", "x"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["x", "4"]}]}], ")"}], 
       RowBox[{"1", "/", "4"}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594842713807746*^9, 
   3.5948427193790646`*^9}, {3.595531107598818*^9, 3.595531114628828*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #97", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.59478622261798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}], 
     RowBox[{"5", "/", "4"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["15", "32"], " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}], 
     RowBox[{"5", "/", "4"}]]}], "-", 
   FractionBox[
    RowBox[{"45", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["x", "4"]}]}], ")"}], 
        RowBox[{"1", "/", "4"}]]], "]"}]}], 
    RowBox[{"128", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"45", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["x", "4"]}]}], ")"}], 
        RowBox[{"1", "/", "4"}]]], "]"}]}], 
    RowBox[{"128", " ", 
     SqrtBox["2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594842732373808*^9, 
   3.5948427382901464`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #98", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.5947862229730005`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["3", "128"], " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox["x", "7"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "+", 
   FractionBox[
    RowBox[{"27", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["x", "4"]}]}], ")"}], 
        RowBox[{"1", "/", "4"}]]], "]"}]}], 
    RowBox[{"512", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    RowBox[{"27", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["x", "4"]}]}], ")"}], 
        RowBox[{"1", "/", "4"}]]], "]"}]}], 
    RowBox[{"512", " ", 
     SqrtBox["2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948427483937244`*^9, 
   3.5948427538800383`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #99", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.594786223693042*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}], ")"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "x"}], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["x", "2"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]], "]"}]}], "+", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], "12"], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["x", "2"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948427707520027`*^9, 
   3.5948427775423913`*^9}, 3.5948490073407154`*^9, {3.595568179968067*^9, 
   3.5955682315781393`*^9}, 3.6275815952588615`*^9, 3.6275816354959197`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #100", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.5947862324515424`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", 
         RowBox[{"1", "/", "3"}]]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["7", "64"], " ", 
    SqrtBox[
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", 
         RowBox[{"1", "/", "3"}]]}], ")"}]}]]}], "-", 
   FractionBox[
    RowBox[{"21", " ", 
     SqrtBox[
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["x", 
          RowBox[{"1", "/", "3"}]]}], ")"}]}]]}], 
    RowBox[{"128", " ", 
     SuperscriptBox["x", 
      RowBox[{"1", "/", "3"}]]}]], "-", 
   RowBox[{
    FractionBox["7", "80"], " ", 
    SuperscriptBox["x", 
     RowBox[{"1", "/", "3"}]], " ", 
    SqrtBox[
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", 
         RowBox[{"1", "/", "3"}]]}], ")"}]}]]}], "+", 
   RowBox[{
    FractionBox["3", "40"], " ", 
    SuperscriptBox["x", 
     RowBox[{"2", "/", "3"}]], " ", 
    SqrtBox[
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", 
         RowBox[{"1", "/", "3"}]]}], ")"}]}]]}], "+", 
   RowBox[{
    FractionBox["3", "5"], " ", "x", " ", 
    SqrtBox[
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", 
         RowBox[{"1", "/", "3"}]]}], ")"}]}]]}], "+", 
   RowBox[{
    FractionBox["21", "128"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"2", "/", "3"}]], 
      SqrtBox[
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["x", 
           RowBox[{"1", "/", "3"}]]}], ")"}]}]]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, 3.5948427846217966`*^9, {
   3.5948428413780427`*^9, 3.5948428534347324`*^9}, {3.594843065069837*^9, 
   3.5948430786076117`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 101 - 112 (p. 193-194)", "Section",
 CellChangeTimes->{3.5947859030967045`*^9, 3.594786312986149*^9, 
  3.5947866113302135`*^9}],

Cell[CellGroupData[{

Cell["Problem #101", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.594786232914569*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "-", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["x", "8"]}], "+", "1"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"4", " ", 
      SqrtBox["3"]}]]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["x", "4"]}], "+", "1"}], 
     RowBox[{
      SqrtBox["3"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["x", "8"]}], "+", "1"}]]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948432021996803`*^9, 
   3.594843208790057*^9}, {3.594843470351018*^9, 3.5948434952984447`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #102", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.5947862333415937`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "9"], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "5"], "+", 
      SuperscriptBox["x", "10"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "40"]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "5"]}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "5"], "+", 
      SuperscriptBox["x", "10"]}]]}], "+", 
   RowBox[{
    FractionBox["1", "15"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "5"], "+", 
       SuperscriptBox["x", "10"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "-", 
   RowBox[{
    FractionBox["3", "80"], " ", 
    RowBox[{"ArcSinh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "5"]}]}], 
      SqrtBox["3"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948432209827547`*^9, 
   3.5948432308833213`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #103", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.594786233774618*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "5"], " ", 
      SqrtBox[
       RowBox[{"4", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        SuperscriptBox["x", "4"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{"4", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       SuperscriptBox["x", "4"]}]], 
     RowBox[{"16", " ", 
      SuperscriptBox["x", "4"]}]]}], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SqrtBox[
      RowBox[{"4", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       SuperscriptBox["x", "4"]}]]}], 
    RowBox[{"64", " ", 
     SuperscriptBox["x", "2"]}]], "+", 
   RowBox[{
    FractionBox["1", "128"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"4", "+", 
       SuperscriptBox["x", "2"]}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"4", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         SuperscriptBox["x", "4"]}]]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.59484323943081*^9, 
   3.5948432451601377`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #104", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.594786234226644*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "-", "1"}], 
     RowBox[{"x", " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        SuperscriptBox["x", "4"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"ArcTanh", "[", 
   FractionBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      SuperscriptBox["x", "4"]}]]], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594843253381608*^9, 
   3.594843261162053*^9}, 3.595531319659115*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #105", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.5947862345826645`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "4"], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"3", "/", "5"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["x", "3"]}], "-", 
      RowBox[{"3", " ", "x"}]}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["5", "16"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "4"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], 
    RowBox[{"8", "/", "5"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594843270714599*^9, 
   3.5948432763819237`*^9}, 3.594843590235875*^9, 3.596223977238308*^9, {
   3.5962240457559032`*^9, 3.596224059915923*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #106", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.594786234940685*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "8"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "5"]}], "-", 
      RowBox[{
       SuperscriptBox["x", "2"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["x", "3"]}], "-", "1"}], ")"}], 
        RowBox[{"2", "/", "3"}]]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["x", "3"]}], "-", "1"}], ")"}], 
      RowBox[{"3", "/", "4"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["4", "27"]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "3"]}], "-", "1"}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "-", 
   RowBox[{
    FractionBox["4", "33"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "3"]}], "-", "1"}], ")"}], 
     RowBox[{"11", "/", "12"}]]}], "+", 
   RowBox[{
    FractionBox["4", "243"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "3"]}], "-", "1"}], ")"}], 
     RowBox[{"9", "/", "4"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948432864314985`*^9, 
   3.59484329275486*^9}, {3.5948436293711133`*^9, 3.5948436315742393`*^9}, {
   3.5948493011165185`*^9, 3.5948493093329887`*^9}, {3.5955315706094666`*^9, 
   3.595531574799472*^9}, 3.595531609439521*^9, {3.59553164491957*^9, 
   3.5955316586495895`*^9}, {3.5955318149198084`*^9, 
   3.5955318463898525`*^9}, {3.613800011642259*^9, 3.6138000362126646`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #107", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.594786235307706*^9, {
   3.594843314572108*^9, 3.5948433161872005`*^9}, {3.595532255510425*^9, 
   3.595532256120426*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", "1"}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "3"], "+", "2"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["3", 
           RowBox[{"1", "/", "3"}]], " ", "x"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "+", 
            SuperscriptBox["x", "3"]}], ")"}], 
          RowBox[{"1", "/", "3"}]]]}], 
       SqrtBox["3"]], "]"}], 
     SuperscriptBox["3", 
      RowBox[{"5", "/", "6"}]]]}], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["3", 
         RowBox[{"1", "/", "3"}]], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", 
          SuperscriptBox["x", "3"]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], "]"}], 
    RowBox[{"3", " ", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "3"}]]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["3", 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox["x", "2"]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", 
          SuperscriptBox["x", "3"]}], ")"}], 
        RowBox[{"2", "/", "3"}]]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["3", 
         RowBox[{"1", "/", "3"}]], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", 
          SuperscriptBox["x", "3"]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], "]"}], 
    RowBox[{"6", " ", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948433022984056`*^9, 
   3.5948433106508837`*^9}, {3.5948494550123205`*^9, 3.5948494673960295`*^9}, 
   3.5955322522104206`*^9, 3.6896977307949924`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #108", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.5947862356697264`*^9, {
   3.594843333455188*^9, 3.5948433354132996`*^9}, {3.5955329789814377`*^9, 
   3.595532979541439*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "+", "1"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "4"], "+", "2"}], ")"}], 
       RowBox[{"1", "/", "4"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{
         SqrtBox["2"], " ", "x"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "4"], "+", "2"}], ")"}], 
         RowBox[{"1", "/", "4"}]]]}], "]"}], 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]]}], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "4"], "+", "2"}], ")"}], 
        RowBox[{"1", "/", "4"}]]]}], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       SuperscriptBox["x", "2"], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "4"], "+", "2"}]]], "-", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "4"], "+", "2"}], ")"}], 
        RowBox[{"1", "/", "4"}]]]}], "]"}], 
    RowBox[{"4", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       SuperscriptBox["x", "2"], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "4"], "+", "2"}]]], "+", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", "x"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "4"], "+", "2"}], ")"}], 
        RowBox[{"1", "/", "4"}]]]}], "]"}], 
    RowBox[{"4", " ", 
     SqrtBox["2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948433297319746`*^9, 
   3.5948433383634686`*^9}, {3.5955323859806075`*^9, 3.595532464710718*^9}, 
   3.595532638060961*^9, {3.596673915782794*^9, 3.5966739339728193`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #109", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.594786236027747*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "3"], "-", "1"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "+", "2"}], ")"}], 
      RowBox[{"1", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "3"], "+", "2"}], ")"}], 
     RowBox[{"2", "/", "3"}]]}], "-", 
   RowBox[{
    FractionBox["5", 
     RowBox[{"3", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["3"]], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", "x"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "3"], "+", "2"}], ")"}], 
          RowBox[{"1", "/", "3"}]]]}], ")"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["5", "6"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "3"], "+", "2"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948433511892023`*^9, 
   3.594843357930588*^9}, {3.594843672396574*^9, 3.5948437018972616`*^9}, 
   3.594849950186643*^9, {3.595025874603713*^9, 3.5950258819621334`*^9}, {
   3.595533063151556*^9, 3.5955330727515693`*^9}, {3.5955331357016573`*^9, 
   3.5955331416116657`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #110", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, 
   3.5947862430301476`*^9, {3.5948433791808033`*^9, 3.594843381064911*^9}, {
   3.5955332352517967`*^9, 3.595533235841798*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "+", "1"}], ")"}], 
      RowBox[{"3", "/", "4"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "+", "2"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "4"], "+", "1"}], ")"}], 
      RowBox[{"3", "/", "4"}]]}], 
    RowBox[{"8", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "4"], "+", "2"}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox["x", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"1", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "4"], "+", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]]}]], "]"}]}], 
    RowBox[{"16", " ", 
     SuperscriptBox["2", 
      RowBox[{"3", "/", "4"}]]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox["x", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"1", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "4"], "+", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]]}]], "]"}]}], 
    RowBox[{"16", " ", 
     SuperscriptBox["2", 
      RowBox[{"3", "/", "4"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594843371414359*^9, 
   3.5948433773136964`*^9}, {3.595533260561832*^9, 3.5955333693519845`*^9}, {
   3.5955334122120447`*^9, 3.5955334280620666`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #111", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859481112795`*^9}, 3.594786243479173*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "5"], "-", "2"}], ")"}], "2"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "5"], "+", "3"}], ")"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "5"], "+", "3"}], ")"}], 
       RowBox[{"1", "/", "5"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"5", " ", "x", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "5"], "-", "2"}], ")"}]}], 
     RowBox[{"33", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "5"], "+", "3"}], ")"}], 
       RowBox[{"11", "/", "5"}]]}]]}], "+", 
   FractionBox[
    RowBox[{"5", " ", "x"}], 
    RowBox[{"297", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "5"], "+", "3"}], ")"}], 
      RowBox[{"6", "/", "5"}]]}]], "+", 
   FractionBox[
    RowBox[{"97", " ", "x"}], 
    RowBox[{"891", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "5"], "+", "3"}], ")"}], 
      RowBox[{"1", "/", "5"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948433897504077`*^9, 
   3.5948433959027596`*^9}, {3.5948437683350616`*^9, 3.5948437871991405`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #112", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, {
   3.5947859231728525`*^9, 3.5947859499863863`*^9}, 3.5947862439341993`*^9, {
   3.594843411365644*^9, 3.5948434126147156`*^9}, {3.595533917442752*^9, 
   3.5955339180327525`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"3", " ", "x"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "3"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"3", " ", "x"}], "+", "3"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["3", 
           RowBox[{"1", "/", "3"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "x"}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"2", "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", "x"}], ")"}], "3"]}], ")"}], 
          RowBox[{"1", "/", "3"}]]]}], 
       SqrtBox["3"]], "]"}], 
     SuperscriptBox["3", 
      RowBox[{"5", "/", "6"}]]]}], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["3", 
         RowBox[{"1", "/", "3"}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "x"}], ")"}], "3"]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], "]"}], 
    RowBox[{"3", " ", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "3"}]]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["3", 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "x"}], ")"}], "2"]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "x"}], ")"}], "3"]}], ")"}], 
        RowBox[{"2", "/", "3"}]]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["3", 
         RowBox[{"1", "/", "3"}]], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "x"}], ")"}], "3"]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}], "]"}], 
    RowBox[{"6", " ", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594843405680319*^9, 
   3.5948434083384705`*^9}, {3.5955338136926064`*^9, 3.595533868432683*^9}, 
   3.689697846981638*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 113 - 122 (p. 195-196)", "Section",
 CellChangeTimes->{
  3.5947859030967045`*^9, 3.594786312986149*^9, 3.5947866231228876`*^9, {
   3.5947872010869455`*^9, 3.5947872187419553`*^9}, 3.594787588452101*^9}],

Cell[CellGroupData[{

Cell["Problem #113", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785959256917*^9, 3.5947862444432287`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "4"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", "x"}], 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "4"]}]]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948440076657505`*^9, 
   3.5948440137370977`*^9}, {3.59484423703187*^9, 3.5948442404430647`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #114", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.594785961622052*^9, 3.594786244875253*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "4"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", "x"}], 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "4"]}]]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594844021482541*^9, 
   3.59484402706586*^9}, {3.5948442457233667`*^9, 3.5948442482865133`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #115", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859638901815`*^9, 3.5947862452322736`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", "1"}], 
     RowBox[{"x", " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "4"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"ArcTanh", "[", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "-", "1"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "4"]}]]], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948440339522543`*^9, 
   3.594844040437625*^9}, {3.594844283790544*^9, 3.59484428705173*^9}, {
   3.595533988142851*^9, 3.5955340022628703`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #116", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859661403103`*^9, 3.5947862455922937`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "2"], "-", "1"}], 
     RowBox[{"x", " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "4"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"ArcTanh", "[", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", "1"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "4"]}]]], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948440547084413`*^9, 
   3.59484406203486*^9}, {3.5948443114491262`*^9, 3.5948443150103292`*^9}, {
   3.5955340093328805`*^9, 3.5955340118528843`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #117", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859685714493`*^9, 3.5947862459643154`*^9, {
   3.594844078129781*^9, 3.594844080177898*^9}, {3.5955347136438665`*^9, 
   3.5955347143038673`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["x", "4"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["3"]], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["3"], " ", "x"}], 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["x", "4"]}]]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948440719824295`*^9, 
   3.5948440760616627`*^9}, {3.5955340939329987`*^9, 3.5955341051230145`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #118", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859713496084`*^9, 3.594786246322336*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["x", "4"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"ArcTan", "[", 
   FractionBox["x", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "4"]}]]], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948440933496513`*^9, 
   3.594844099947029*^9}, {3.594844515112775*^9, 3.5948445263674183`*^9}, {
   3.595534176673115*^9, 3.5955341864331284`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #119", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, 3.5947859739067545`*^9, 3.594786249636525*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "4"], "-", "1"}], 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "4"], "+", 
        SuperscriptBox["x", "2"], "+", "1"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   SqrtBox[
    RowBox[{
     SuperscriptBox["x", "4"], "+", 
     SuperscriptBox["x", "2"], "+", "1"}]], "x"]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948441114486866`*^9, 
   3.5948441167899923`*^9}, 3.5948446151414957`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #120", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, {
   3.5947862662974787`*^9, 3.5947862686186113`*^9}, {3.594850547821826*^9, 
   3.5948505492779093`*^9}, {3.5955343792433987`*^9, 3.595534379793399*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "a", " ", "x"}], "+", 
        SuperscriptBox["x", "2"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "a", " ", "x"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["x", "3"]}], "+", 
        SuperscriptBox["x", "4"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox["2"], 
     SqrtBox[
      RowBox[{"1", "-", "b"}]]}]], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", "b", "+", "1"}], ")"}], "x"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "2"]}]}], 
     RowBox[{
      SqrtBox["2"], 
      SqrtBox[
       RowBox[{"1", "-", "b"}]], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "a", " ", "x"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["x", "3"]}], "+", 
        SuperscriptBox["x", "4"]}]]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948441411773868`*^9, 
   3.5948441510499516`*^9}, 3.5948504986850157`*^9, {3.594850540613414*^9, 
   3.5948505432365637`*^9}, {3.59553427299325*^9, 3.5955343344033356`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #121", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, {
   3.5947862662974787`*^9, 3.5947862686186113`*^9}, {3.5948441280596366`*^9, 
   3.594844128271649*^9}, {3.5948441623605986`*^9, 3.5948441640246935`*^9}, {
   3.5952733268059187`*^9, 3.5952733275059195`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "4"]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SqrtBox[
         RowBox[{"1", "+", 
          SuperscriptBox["x", "4"]}]], "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"ArcTan", "[", 
   FractionBox["x", 
    SqrtBox[
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", 
        SuperscriptBox["x", "4"]}]], "-", 
      SuperscriptBox["x", "2"]}]]], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.594844158028351*^9, 
   3.594844160414487*^9}, {3.595273322505913*^9, 3.5952733237259145`*^9}, {
   3.5955344202234554`*^9, 3.5955344459034915`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #122", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5947859231728525`*^9, {3.5947859739067545`*^9, 3.594785994527934*^9}, {
   3.5947862662974787`*^9, 3.5947862686186113`*^9}, {3.5948441307057877`*^9, 
   3.5948441308917985`*^9}, {3.5948441815936985`*^9, 3.594844183030781*^9}, {
   3.5952733329359274`*^9, 3.5952733336459284`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["x", 
            RowBox[{"2", " ", "n"}]]}], ")"}], 
         RowBox[{"1", "/", "n"}]], "-", 
        SuperscriptBox["x", "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"ArcTan", "[", 
   FractionBox["x", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}], ")"}], 
       RowBox[{"1", "/", "n"}]], "-", 
      SuperscriptBox["x", "2"]}]]], "]"}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5947858505376987`*^9, 3.5947858538328867`*^9}, {3.5948441720001497`*^9, 
   3.5948441759963784`*^9}, {3.5952734462260857`*^9, 
   3.5952734473060875`*^9}, {3.595534495253561*^9, 3.595534499873567*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Chapter 5 (p. 201-309)\n",
 StyleBox["Trigonometric Function Integration Problems",
  FontSize->24]
}], "Subtitle",
 CellChangeTimes->{{3.5950910754931736`*^9, 3.59509110077662*^9}, {
  3.595091364101681*^9, 3.5950913726391697`*^9}, {3.5950917162088203`*^9, 
  3.5950917374460354`*^9}, {3.595273846966647*^9, 3.5952738693266783`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->28],

Cell[CellGroupData[{

Cell["Problems 1 - 3 (p. 202-203)", "Section"],

Cell[CellGroupData[{

Cell["Problem #1", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "2"], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, {3.589079641304035*^9, 3.5890796421840363`*^9}, 
   3.5890796807990913`*^9, {3.5890797306916637`*^9, 3.5890797361216717`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #2", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"], "3"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951341124`*^9, {3.5890797416916795`*^9, 
   3.589079746356686*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"3", " ", "x"}], "8"], "-", 
   RowBox[{
    FractionBox["3", "8"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951441126`*^9, {3.589079750806692*^9, 
   3.5890797559817*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 4 - 7 (p. 208)", "Section"],

Cell[CellGroupData[{

Cell["Problem #4", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "6"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"5", " ", "x"}], "16"], "+", 
   RowBox[{
    FractionBox["5", "16"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["5", "24"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951441126`*^9, {3.58907976289421*^9, 
   3.589079767594217*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "8"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"35", " ", "x"}], "128"], "-", 
   RowBox[{
    FractionBox["35", "128"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["35", "192"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}], "-", 
   RowBox[{
    FractionBox["7", "48"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "5"]}], "-", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "7"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951541123`*^9, {3.5890797731467247`*^9, 
   3.5890797776692314`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["\[Pi]", "4"], "+", 
       FractionBox["x", "2"]}], "]"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"3", " ", "x"}], "8"], "+", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], "-", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951541123`*^9, {3.589079785691743*^9, 
   3.589079792341752*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #7", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", 
       FractionBox["\[Pi]", "12"]}], "]"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "3"]}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["\[Pi]", "12"], "-", 
      RowBox[{"3", " ", "x"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["\[Pi]", "12"], "-", 
       RowBox[{"3", " ", "x"}]}], "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951541123`*^9, {3.589079799826763*^9, 
   3.589079806046772*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 8 - 11 (p. 211)", "Section"],

Cell[CellGroupData[{

Cell["Problem #8", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "6"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Cot", "[", "x", "]"}]}], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Cot", "[", "x", "]"}], "3"]}], "3"], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cot", "[", "x", "]"}], "5"], "5"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951541123`*^9, {3.5890798132517824`*^9, 
   3.589079821676794*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #9", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079251563972*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "7"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["5", "16"]}], 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["5", "16"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    RowBox[{"Csc", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["5", "24"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "3"]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "5"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951541123`*^9, {3.589079829756806*^9, 
   3.58907985306184*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #10", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.5890793251840773`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "12"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "3"]}], "3"], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "5"]}], "+", 
   FractionBox[
    RowBox[{"10", " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "7"]}], "7"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "9"]}], "9"], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "11"], "11"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695164112*^9, {3.589079858151847*^9, 
   3.589079862911854*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #11", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.5890793262890797`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["\[Pi]", "4"], "+", 
        RowBox[{"3", " ", "x"}]}], "]"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["\[Pi]", "4"], "+", 
       RowBox[{"3", " ", "x"}]}], "]"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Sec", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", 
      RowBox[{"3", " ", "x"}]}], "]"}], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", 
      RowBox[{"3", " ", "x"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695164112*^9, {3.589079869726864*^9, 
   3.5890798747618713`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 12 - 14 (p. 213)", "Section"],

Cell[CellGroupData[{

Cell["Problem #12", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.589079327429081*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "6"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"Tan", "[", "x", "]"}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "3"], "3"], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "5"], "5"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695164112*^9, {3.589079881931881*^9, 
   3.5890798865168877`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #13", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.589079328804083*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cot", "[", "x", "]"}], "2"], "2"], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cot", "[", "x", "]"}], "4"], "4"], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695164112*^9, {3.5890798909943943`*^9, 
   3.5890798951844006`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #14", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.589079330989086*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cot", "[", 
      RowBox[{
       FractionBox["x", "3"], "-", 
       FractionBox[
        RowBox[{"3", " ", "\[Pi]"}], "4"]}], "]"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "+", 
   RowBox[{"3", " ", 
    RowBox[{"Cot", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", 
      FractionBox["x", "3"]}], "]"}]}], "-", 
   SuperscriptBox[
    RowBox[{"Cot", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", 
      FractionBox["x", "3"]}], "]"}], "3"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951741123`*^9, {3.589079901129409*^9, 
   3.589079906126916*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 15 - 20 (p. 219-220)", "Section"],

Cell[CellGroupData[{

Cell["Problem #15", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.5890793329340887`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "6"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"3", " ", "x"}], "256"], "+", 
   RowBox[{
    FractionBox["3", "256"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "128"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "160"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "80"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "10"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951741123`*^9, {3.5890799138919277`*^9, 
   3.589079918796934*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #16", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.589079334449091*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "7"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "6"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "7"]}], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "7"]}], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "9"], "3"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "11"]}], "11"], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "13"], "13"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951741123`*^9, {3.589079925411944*^9, 
   3.5890799301469507`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #17", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9, 
  3.5890793356090927`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "11"], 
     RowBox[{"Cos", "[", "x", "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"]}], "2"], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "4"]}], "2"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "6"]}], "3"], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "8"]}], "8"], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "10"], "10"], "-", 
   RowBox[{"Log", "[", 
    RowBox[{"Cos", "[", "x", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951741123`*^9, {3.5890799361519594`*^9, 
   3.589079940861966*^9}, 3.7036139419115057`*^9, 3.704500318924593*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #18", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.5890793376040955`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "6"], " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "6"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "10"}], " ", 
    RowBox[{"Cot", "[", "x", "]"}]}], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Cot", "[", "x", "]"}], "3"]}], "3"], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cot", "[", "x", "]"}], "5"], "5"], "+", 
   RowBox[{"10", " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "3"]}], "3"], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "5"], "5"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951741123`*^9, {3.589079945771973*^9, 
   3.589079951146981*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #19.1", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079251563972*^9, 3.5890795240343637`*^9, {
   3.5956295589258914`*^9, 3.5956295805359216`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "8"], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951841125`*^9, {3.5890799626319976`*^9, 
   3.589079967812005*^9}, {3.5956295748759136`*^9, 3.5956295883759327`*^9}, 
   3.5956296734460516`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #19.2", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079251563972*^9, 3.5890795240343637`*^9, {
   3.5956295589258914`*^9, 3.5956296004059496`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"3", " ", "x"}], "128"], "+", 
   RowBox[{
    FractionBox["3", "128"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "64"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951841125`*^9, {3.5890799626319976`*^9, 
   3.589079967812005*^9}, {3.5956295748759136`*^9, 3.5956296118359656`*^9}, 
   3.5956296941760807`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #19.3", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079251563972*^9, 3.5890795240343637`*^9, {
   3.5956295589258914`*^9, 3.5956296025259523`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "6"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "6"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"5", " ", "x"}], "1024"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "1024"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "1536"], "+", 
   RowBox[{
    FractionBox["1", "384"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "64"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "5"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951841125`*^9, {3.5890799626319976`*^9, 
   3.589079967812005*^9}, {3.5956295748759136`*^9, 3.595629615865971*^9}, 
   3.5956297197261167`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #19.4", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079251563972*^9, 3.5890795240343637`*^9, {
   3.5956295589258914`*^9, 3.595629605135956*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "8"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"35", " ", "x"}], "32768"], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "32768"], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "49152"], "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "12288"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "2048"], "-", 
   RowBox[{
    FractionBox["1", "256"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "9"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["5", "384"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "9"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}], "-", 
   RowBox[{
    FractionBox["1", "32"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "9"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "5"]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "9"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "7"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951841125`*^9, {3.5890799626319976`*^9, 
   3.589079967812005*^9}, {3.5956295748759136`*^9, 3.5956295883759327`*^9}, {
   3.595629618835975*^9, 3.595629620275977*^9}, 3.595629754316165*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #19.m", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079251563972*^9, 3.5890795240343637`*^9, {
   3.5956295589258914`*^9, 3.595629568925905*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"2", " ", "m"}]], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"2", " ", "m"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "m"}]}]], 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "m"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"], ")"}], 
    RowBox[{
     FractionBox["1", "2"], "-", "m"}]], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "m"}]}]], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "m"}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "m"}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", "m"}]}], ")"}]}], ",", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951841125`*^9, {3.5890799626319976`*^9, 
   3.589079967812005*^9}, {3.6280165352425284`*^9, 3.6280165379855337`*^9}, 
   3.6653516355085115`*^9, 3.7051102248293266`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #20", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.589079341304101*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{
         FractionBox["\[Pi]", "4"], "+", 
         RowBox[{"2", " ", "x"}]}], "]"}], "3"], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["\[Pi]", "4"], "+", 
        RowBox[{"2", " ", "x"}]}], "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SuperscriptBox[
     RowBox[{"Cot", "[", 
      RowBox[{
       FractionBox["\[Pi]", "4"], "+", 
       RowBox[{"2", " ", "x"}]}], "]"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Tan", "[", 
      RowBox[{
       FractionBox["\[Pi]", "4"], "+", 
       RowBox[{"2", " ", "x"}]}], "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951841125`*^9, {3.589079973157013*^9, 
   3.5890799786520205`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 21 - 29 (p. 223)", "Section"],

Cell[CellGroupData[{

Cell["Problem #21", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.5890793430591035`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Tan", "[", "x", "]"}], "3"], "3"]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951841125`*^9, {3.5890799867520323`*^9, 
   3.5890799907195377`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #22", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.5890793466791086`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cot", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Csc", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"Csc", "[", "x", "]"}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "3"], "3"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951841125`*^9, {3.589079995499545*^9, 
   3.5890799999395514`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #23", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.5890793476691103`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Sec", "[", "x", "]"}], "3"], "3"]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951941123`*^9, {3.5890800085545635`*^9, 
   3.5890800135420713`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #24", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.589079348809112*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cot", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    RowBox[{"Csc", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951941123`*^9, {3.589080019127079*^9, 
   3.5890800242770863`*^9}, 3.6653517965157204`*^9, 3.666390649132993*^9, 
   3.6798438251224365`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #25", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.5890793499391136`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "7"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "4"], "4"], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "6"], "6"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951941123`*^9, {3.589080032847099*^9, 
   3.5890800389421077`*^9}, 3.6653518732571096`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #26", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.589079350964115*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "5"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], 
     RowBox[{"3", "/", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["2", "3"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], 
     RowBox[{"3", "/", "2"}]]}], "-", 
   RowBox[{
    FractionBox["4", "7"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], 
     RowBox[{"7", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["2", "11"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], 
     RowBox[{"11", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951941123`*^9, {3.5890800450271163`*^9, 
   3.5890800503971243`*^9}, {3.602381079489231*^9, 3.6023810861592407`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #27", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9, 
  3.5890793523191166`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], 
     RowBox[{"3", "/", "2"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["2", "5"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], 
     RowBox[{"5", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["2", "9"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], 
     RowBox[{"9", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796951941123`*^9, {3.589080054952131*^9, 
   3.5890800610171394`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #28", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.5890793541541195`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cot", "[", "x", "]"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "16"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    RowBox[{"Csc", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "3"]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox[
     RowBox[{"Cot", "[", "x", "]"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695204112*^9, {3.5890800674521484`*^9, 
   3.5890800721571555`*^9}, 3.6653519397789145`*^9, 3.6663907428503537`*^9, 
   3.6798438554081693`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #29", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079251563972*^9, 
  3.589079357389124*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{
       FractionBox["\[Pi]", "4"], "+", 
       FractionBox["x", "2"]}], "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{
       FractionBox["\[Pi]", "4"], "+", 
       FractionBox["x", "2"]}], "]"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["\[Pi]", "4"], "+", 
       FractionBox["x", "2"]}], "]"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Sec", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", 
      FractionBox["x", "2"]}], "]"}], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", 
      FractionBox["x", "2"]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{
       FractionBox["\[Pi]", "4"], "+", 
       FractionBox["x", "2"]}], "]"}], "3"], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", 
      FractionBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695204112*^9, {3.589080076957162*^9, 
   3.5890800821021695`*^9}, 3.6653519844734707`*^9, 3.666390798581541*^9, 
   3.6798439891138167`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 30 - 32 (p. 228)", "Section"],

Cell[CellGroupData[{

Cell["Problem #30", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.5890793596641273`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", "x", "]"}], "2"]}], "-", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cot", "[", "x", "]"}], "3"], "+", "1"}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "2"], "+", 
   RowBox[{"4", " ", "a", " ", "x"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"]}], "+", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "4"], "+", 
   RowBox[{"4", " ", "a", " ", 
    RowBox[{"Cot", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Cot", "[", "x", "]"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"4", "-", "a"}], ")"}], " ", "a", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"4", "+", 
      SuperscriptBox["a", "2"]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "3"], " "}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695204112*^9, {3.5890800959771895`*^9, 
   3.589080105829704*^9}, {3.6280192856419992`*^9, 3.6280192959190164`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #31", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.5890793609816294`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}], "4"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "-", 
      RowBox[{"3", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"227", " ", "x"}], "32"], "+", 
   RowBox[{"10", " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], "-", 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"]}], "3"], "-", 
   RowBox[{"3", " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["99", "32"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}], "2"], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "4"]}], "8"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "5"]}], "80"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695204112*^9, {3.589080113719715*^9, 
   3.589080119424723*^9}, 3.616092542384492*^9, 3.701313242795119*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #32", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.589079361981631*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"2", " ", 
        RowBox[{"Cot", "[", "x", "]"}]}]}], ")"}], "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      RowBox[{"3", " ", 
       RowBox[{"Cot", "[", "x", "]"}]}]}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"285", " ", "x"}], "2"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"2", " ", 
        RowBox[{"Cot", "[", "x", "]"}]}]}], ")"}], "2"]}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "-", 
      RowBox[{"2", " ", 
       RowBox[{"Cot", "[", "x", "]"}]}]}], ")"}], "3"], "-", 
   RowBox[{"42", " ", 
    RowBox[{"Cot", "[", "x", "]"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952141123`*^9, {3.589080126017233*^9, 
   3.58908013065224*^9}, {3.58908196136788*^9, 3.589081964417884*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 33 - 36 (p. 229)", "Section"],

Cell[CellGroupData[{

Cell["Problem #33", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.589079366306637*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      RowBox[{"5", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"16", " ", "x"}], "-", 
   RowBox[{"15", " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "3"]}], "3"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952141123`*^9, {3.589080140044753*^9, 
   3.5890801444322596`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #34", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.5890793680316396`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      RowBox[{"4", " ", "x"}], "]"}], 
     RowBox[{"Cos", "[", "x", "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"ArcTanh", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], "-", 
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}], "3"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952141123`*^9, {3.5890801487422657`*^9, 
   3.589080153482272*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #35", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.589079368951641*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "x"}], "]"}], " ", 
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "10"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"5", " ", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952141123`*^9, {3.589080160202282*^9, 
   3.589080165142289*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #36", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.5890793703166428`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      RowBox[{"4", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["35", "8"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["29", "8"], " ", 
    RowBox[{"Sec", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952141123`*^9, {3.5890801700122957`*^9, 
   3.5890801742973022`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 37 - 39 (p. 233)", "Section"],

Cell[CellGroupData[{

Cell["Problem #37", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9, 
  3.589079371616645*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "x"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "16"], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["3", "32"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"4", " ", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"6", " ", "x"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "128"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"8", " ", "x"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952241125`*^9, {3.5890803690450826`*^9, 
   3.5890803746000905`*^9}, 3.5922400788796825`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #38", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.589079374136648*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      RowBox[{"5", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"6", " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "2"]}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "4"], "4"], "+", 
   RowBox[{"16", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952241125`*^9, {3.5890803794300976`*^9, 
   3.589080383840104*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #39", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079251563972*^9, 
  3.5890793769516525`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"4", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "4"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "2"]}], "-", 
   RowBox[{"8", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952241125`*^9, {3.5890803892851114`*^9, 
   3.5890803948401194`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 40 - 49 (p. 254-255)", "Section"],

Cell[CellGroupData[{

Cell["Problem #40", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.5890793855841646`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["x", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]]}], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["3"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], 
      RowBox[{"2", "+", 
       SqrtBox["3"], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", "x", "]"}], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}]], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952241125`*^9, {3.589080402590131*^9, 
   3.589080407190138*^9}, {3.5902896362634554`*^9, 3.590289643563465*^9}, 
   3.6023593018860908`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #41", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.5890793859041653`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"], 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"3", " ", "x"}], "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", "x", "]"}], "2"], "-", "4"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952341127`*^9, {3.589080411725144*^9, 
   3.5890804166201515`*^9}, 3.5903334237753057`*^9, {3.5903335108078585`*^9, 
   3.590333515316266*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #42", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.589079386259166*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "4"], "+", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "4"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952341127`*^9, {3.5890804261351647`*^9, 
   3.589080433990176*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #43", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.589079386599166*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", "+", 
      RowBox[{
       SqrtBox["3"], " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{"Sin", "[", "x", "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"2", " ", 
     SqrtBox["3"]}]], "+", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["3"]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "-", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", 
          SqrtBox["3"]}], ")"}]}], "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{"Sin", "[", "x", "]"}]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952341127`*^9, {3.589080442840189*^9, 
   3.589080456095208*^9}, 3.5902897079935555`*^9, {3.5910607941693945`*^9, 
   3.591060801669405*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #44", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.5890793869091663`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"3", "+", 
      RowBox[{"4", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["23"]]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["23"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "-", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], 
     RowBox[{"8", "+", 
      RowBox[{"3", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952341127`*^9, {3.589080466400223*^9, 
   3.589080479330241*^9}, {3.5910611159698453`*^9, 3.591061127139861*^9}, 
   3.591251286149802*^9, 3.602367613977254*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #45", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.589079387239167*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", "-", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "3"], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952341127`*^9, {3.5890804911402583`*^9, 
   3.5890804968752666`*^9}, 3.590273466410346*^9, 3.591041435283662*^9, 
   3.6024363420920887`*^9, {3.6280163438251867`*^9, 3.6280163475661926`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #46", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.5890793876891675`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"4", "+", 
      RowBox[{"Tan", "[", "x", "]"}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"Cot", "[", "x", "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"4", " ", "x"}], "25"], "-", 
   RowBox[{
    FractionBox["3", "25"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "+", 
   FractionBox["2", 
    RowBox[{"5", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"Tan", "[", "x", "]"}]}], ")"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952441125`*^9, {3.589080501415273*^9, 
   3.5890805087152834`*^9}, 3.591551925024533*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #47", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9, 
  3.589079388484169*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Sec", "[", "x", "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"8", " ", "x"}], 
    RowBox[{"15", " ", 
     SqrtBox["15"]}]], "-", 
   RowBox[{
    FractionBox["8", 
     RowBox[{"15", " ", 
      SqrtBox["15"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], 
      RowBox[{"4", "+", 
       SqrtBox["15"], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Cos", "[", "x", "]"}], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}]], "]"}]}], "+", 
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"4", " ", 
      RowBox[{"Tan", "[", "x", "]"}]}]}], 
    RowBox[{"15", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"Tan", "[", "x", "]"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952441125`*^9, {3.589080515210293*^9, 
   3.5890805240103054`*^9}, 3.5902897471036105`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #48", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.5890793890541697`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Sec", "[", "x", "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"6", " ", 
     SqrtBox["6"]}]], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"6", " ", 
      SqrtBox["6"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      RowBox[{"2", "+", 
       SqrtBox["6"], "+", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}]], "]"}]}], "+", 
   FractionBox[
    RowBox[{"Tan", "[", "x", "]"}], 
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952441125`*^9, {3.5890805371003246`*^9, 
   3.589080543112833*^9}, {3.5902735014853964`*^9, 3.5902735149304156`*^9}, 
   3.5902787729129667`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #49", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079251563972*^9, 
  3.589079391349173*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"5", "-", 
      RowBox[{"Tan", "[", "x", "]"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         RowBox[{"Tan", "[", "x", "]"}]}]}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"67", " ", "x"}], "250"]}], "-", 
   RowBox[{
    FractionBox["28", "125"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}], "-", 
   FractionBox["7", 
    RowBox[{"10", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         RowBox[{"Tan", "[", "x", "]"}]}]}], ")"}], "2"]}]], "-", 
   FractionBox["29", 
    RowBox[{"50", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", 
        RowBox[{"Tan", "[", "x", "]"}]}]}], ")"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952441125`*^9, {3.5890805517628455`*^9, 
   3.589080566352866*^9}, 3.591581104876252*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 50 - 56 (p. 260)", "Section"],

Cell[CellGroupData[{

Cell["Problem #50", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.5890793963991804`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"], 
     RowBox[{"Cos", "[", 
      RowBox[{"3", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"ArcTanh", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952541122`*^9, {3.5890805819853888`*^9, 
   3.5890805925179043`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #51", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.589079396729181*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], 
   SqrtBox["2"]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952541122`*^9, {3.5890805970779104`*^9, 
   3.5890806010279164`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #52", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.589079397049181*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"], 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952541122`*^9, {3.589080608507927*^9, 
   3.5890806141029353`*^9}, {3.5913070841851416`*^9, 3.5913070982951612`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #53", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.5890793974891815`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"], 
     RowBox[{"Cos", "[", 
      RowBox[{"3", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952541122`*^9, {3.5890806183079414`*^9, 
   3.5890806267879534`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #54", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.5890793978191824`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"3", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"3", "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952641125`*^9, {3.5890806327629623`*^9, 
   3.589080639857972*^9}, {3.590333445147343*^9, 3.5903334643197765`*^9}, 
   3.628015231770997*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #55", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.5890793981441827`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"4", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952641125`*^9, {3.58908064575298*^9, 
   3.5890806511679883`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #56", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.5890793985741835`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"], 
     RowBox[{"Sin", "[", 
      RowBox[{"4", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}], 
    RowBox[{"4", " ", 
     SqrtBox["2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952641125`*^9, {3.589080663548006*^9, 
   3.589080668143013*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 57 - 61 (p. 266)", "Section"],

Cell[CellGroupData[{

Cell["Problem #57a", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.5890792470039654`*^9, 3.5890793989041843`*^9, {
   3.6280197711750546`*^9, 3.6280197714650555`*^9}, {3.6280201586137595`*^9, 
   3.628020159226761*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952641125`*^9, {3.5890806782980275`*^9, 
   3.589080691373046*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #57b", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.5890792470039654`*^9, 3.5890793989041843`*^9, {
   3.6280197740600595`*^9, 3.62801977437006*^9}, {3.628020162487766*^9, 
   3.6280201637137685`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "x"}], "]"}], 
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}]]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952641125`*^9, {3.5890806782980275`*^9, 
   3.589080691373046*^9}, 3.628020176228791*^9, 3.628020372958144*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #58a", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079249418969*^9, 3.5890793992341843`*^9, {
   3.6280197838800764`*^9, 3.6280197903580875`*^9}, {3.6280201657747726`*^9, 
   3.628020168343777*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952641125`*^9, {3.5890807207480884`*^9, 
   3.589080729323101*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #58b", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079249418969*^9, 3.5890793992341843`*^9, {
   3.6280197931960926`*^9, 3.628019793516093*^9}, {3.6280201706777806`*^9, 
   3.6280201712607813`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]]}]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952641125`*^9, {3.5890807207480884`*^9, 
   3.589080729323101*^9}, 3.628020177923794*^9, {3.6280204020391955`*^9, 
   3.6280204069162035`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #59", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079251563972*^9, 
  3.589079399574185*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"3", " ", "x"}], "]"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"6", " ", 
       SqrtBox["2"]}]]}], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"3", " ", "x"}], "]"}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         RowBox[{"Cos", "[", 
          RowBox[{"3", " ", "x"}], "]"}]}]]}]], "]"}]}], "-", 
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}], 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"3", " ", "x"}], "]"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952741127`*^9, {3.5890807364831114`*^9, 
   3.5890807499831305`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #60", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.5890793999041853`*^9, 3.58907947270679*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"2", " ", "x"}], "3"], "]"}]}], ")"}], 
     RowBox[{"5", "/", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"32", " ", 
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"2", " ", "x"}], "3"], "]"}]}], 
    RowBox[{"5", " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"2", " ", "x"}], "3"], "]"}]}]]}]], "+", 
   RowBox[{
    FractionBox["8", "5"], " ", 
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"2", " ", "x"}], "3"], "]"}], " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"2", " ", "x"}], "3"], "]"}]}]]}], "+", 
   RowBox[{
    FractionBox["3", "5"], " ", 
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"2", " ", "x"}], "3"], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"2", " ", "x"}], "3"], "]"}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952741127`*^9, {3.589080760933146*^9, 
   3.589080766578154*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #61", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.5890794074791965`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}], 
          RowBox[{"1", "/", "4"}]]}], "-", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["3", 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}]]}]], "-", 
   FractionBox["4", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]]], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952741127`*^9, {3.5890807722731624`*^9, 
   3.5890807767731686`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 62 - 66 (p. 268)", "Section"],

Cell[CellGroupData[{

Cell["Problem #62", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.5890794079791965`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"Tan", "[", "x", "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "-", 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         RowBox[{"Tan", "[", "x", "]"}]]}]}], "]"}], 
     SqrtBox["2"]]}], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{"Tan", "[", "x", "]"}]]}]}], "]"}], 
    SqrtBox["2"]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{"Tan", "[", "x", "]"}]]}], "+", 
      RowBox[{"Tan", "[", "x", "]"}]}], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{"Tan", "[", "x", "]"}]]}], "+", 
      RowBox[{"Tan", "[", "x", "]"}]}], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952741127`*^9, {3.589080788043185*^9, 
   3.589080793763193*^9}, 3.604107890081729*^9, 3.666390869424593*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #63", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.5890794082941976`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"5", " ", "x"}], "]"}], 
      RowBox[{"1", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "10"]}], " ", 
    SqrtBox["3"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"5", " ", "x"}], "]"}], 
         RowBox[{"2", "/", "3"}]]}]}], 
      SqrtBox["3"]], "]"}]}], "+", 
   RowBox[{
    FractionBox["3", "20"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"5", " ", "x"}], "]"}], 
       RowBox[{"2", "/", "3"}]]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "20"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Tan", "[", 
        RowBox[{"5", " ", "x"}], "]"}], "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952841125`*^9, {3.5890807978731995`*^9, 
   3.589080804588209*^9}, 3.602368155422405*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #64", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.589079408624198*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"4", "+", 
        RowBox[{"3", " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"2", " ", "x"}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"9", " ", 
      RowBox[{"ArcTan", "[", 
       FractionBox[
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"2", " ", "x"}], "]"}]}]}], 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          RowBox[{"4", "+", 
           RowBox[{"3", " ", 
            RowBox[{"Tan", "[", 
             RowBox[{"2", " ", "x"}], "]"}]}]}]]}]], "]"}]}], 
     RowBox[{"250", " ", 
      SqrtBox["2"]}]]}], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{"3", "+", 
        RowBox[{"Tan", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         RowBox[{"4", "+", 
          RowBox[{"3", " ", 
           RowBox[{"Tan", "[", 
            RowBox[{"2", " ", "x"}], "]"}]}]}]]}]], "]"}]}], 
    RowBox[{"250", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox["3", 
    RowBox[{"25", " ", 
     SqrtBox[
      RowBox[{"4", "+", 
       RowBox[{"3", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952841125`*^9, {3.5890808121982203`*^9, 
   3.5890808209282327`*^9}, {3.6041093448837667`*^9, 
   3.6041093997938433`*^9}, {3.604109485103963*^9, 3.6041095110439997`*^9}, {
   3.604109833644452*^9, 3.6041098459644694`*^9}, 3.610319194014492*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #65", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.5890794089441986`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"Tan", "[", "x", "]"}]}], "-", 
      SqrtBox[
       RowBox[{"4", "-", 
        RowBox[{"3", " ", 
         RowBox[{"Tan", "[", "x", "]"}]}]}]]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"3", " ", 
          RowBox[{"Tan", "[", "x", "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"4", "-", 
      RowBox[{"3", " ", 
       RowBox[{"Tan", "[", "x", "]"}]}]}], "]"}]}], "+", 
   FractionBox["8", 
    RowBox[{"3", " ", 
     SqrtBox[
      RowBox[{"4", "-", 
       RowBox[{"3", " ", 
        RowBox[{"Tan", "[", "x", "]"}]}]}]]}]], "+", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    SqrtBox[
     RowBox[{"4", "-", 
      RowBox[{"3", " ", 
       RowBox[{"Tan", "[", "x", "]"}]}]}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952841125`*^9, {3.5890808341307516`*^9, 
   3.589080842940764*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #66", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.589079409294199*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Tan", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         RowBox[{"Tan", "[", "x", "]"}]], "-", "1"}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["x", "2"]}], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"Tan", "[", "x", "]"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{"Tan", "[", "x", "]"}]]}]], "]"}], 
    SqrtBox["2"]], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"Tan", "[", "x", "]"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{"Tan", "[", "x", "]"}]]}]], "]"}], 
    SqrtBox["2"]], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SqrtBox[
      RowBox[{"Tan", "[", "x", "]"}]]}], "]"}], "+", 
   FractionBox["1", 
    RowBox[{"1", "-", 
     SqrtBox[
      RowBox[{"Tan", "[", "x", "]"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952841125`*^9, {3.589080848240772*^9, 
   3.589080870045803*^9}, 3.5915546951021686`*^9, {3.604109957374625*^9, 
   3.604109962174632*^9}, {3.604110022692217*^9, 3.604110025952222*^9}, 
   3.604110068862282*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 67 - 75 (p. 272-273)", "Section"],

Cell[CellGroupData[{

Cell["Problem #67a", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9, 
  3.589079409674199*^9, 3.589081080428606*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796952841125`*^9, {3.589080883295822*^9, 
   3.58908088878833*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #67b", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079249418969*^9, 3.5890794105092006`*^9, {
   3.589081082773609*^9, 3.5890810857986135`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695294112*^9, {3.5890808937083373`*^9, 
   3.5890808996933455`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #68", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079251563972*^9, 3.5890794119092026`*^9, {
   3.5890810891786184`*^9, 3.589081094643626*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]], " ", 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695294112*^9, {3.5890809078108573`*^9, 
   3.589080913295865*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #69", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.5890794182592115`*^9, {3.5890810964186287`*^9, 
   3.589081098863632*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695294112*^9, {3.5890809193808737`*^9, 
   3.589080924835882*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #70", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.5890792349739475`*^9, 3.5890794189292126`*^9, {
   3.5890811065136433`*^9, 3.589081107923645*^9}, {3.5890811881687613`*^9, 
   3.5890811887287617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "7"], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"7", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "16"]}], " ", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]}], "]"}]}], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "5"], 
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"5", "/", "2"}]]}]], "-", 
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953041124`*^9, {3.5890809423709073`*^9, 
   3.589080948775916*^9}, 3.602368572613338*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #71", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.5890792369264507`*^9, 3.5890794192592134`*^9, {
   3.5890811105486493`*^9, 3.5890811109186497`*^9}, {3.5890811913037653`*^9, 
   3.589081191603766*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "7"], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"7", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "16"]}], " ", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]}], "]"}]}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"], 
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"5", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953041124`*^9, {3.5890809601059327`*^9, 
   3.589080964545939*^9}, 3.602368942000787*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #72", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079239021454*^9, 3.589079419569214*^9, {
   3.5890811132886534`*^9, 3.5890811135386534`*^9}, {3.589081193843769*^9, 
   3.5890811940587697`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"3", "/", "2"}]], 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "5"]}], " ", 
   SuperscriptBox[
    RowBox[{"Csc", "[", "x", "]"}], "5"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}], 
    RowBox[{"5", "/", "2"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953041124`*^9, {3.5890809714309487`*^9, 
   3.5890809791809597`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #73", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.5890792424814587`*^9, 3.5890794199392138`*^9, {
   3.5890811155536566`*^9, 3.589081115813657*^9}, {3.5890811973237743`*^9, 
   3.589081197593775*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["4", "5"], " ", 
    RowBox[{"Sec", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "3"], " ", 
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"2", " ", "x"}], "]"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953041124`*^9, {3.5890809843584676`*^9, 
   3.589080990253476*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #74", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.5890792450389624`*^9, 3.5890794207242155`*^9, {
   3.5890811179186597`*^9, 3.589081119353662*^9}, {3.5890812015237803`*^9, 
   3.589081201813781*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}], 
       RowBox[{"3", "/", "2"}]]}]]}], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    RowBox[{"3", " ", 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953041124`*^9, {3.5890809948534827`*^9, 
   3.589081000668491*^9}, 3.6129247714975004`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #75", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.5890792470039654`*^9, 3.5890794213942165`*^9, {
   3.589081121508665*^9, 3.5890811219286656`*^9}, {3.589081204051284*^9, 
   3.5890812043837843`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"Tan", "[", "x", "]"}]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"], "-", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}], 
       RowBox[{"5", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["33", "32"], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]], 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}]], "]"}]}], "-", 
   FractionBox[
    RowBox[{"9", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], 
    RowBox[{"16", " ", 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]}]], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Cot", "[", "x", "]"}]}], 
    RowBox[{"24", " ", 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Cot", "[", "x", "]"}], "2"]}], 
    RowBox[{"20", " ", 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953141127`*^9, {3.5890810141235104`*^9, 
   3.58908102085852*^9}, {3.59556421663501*^9, 3.595564222075018*^9}, 
   3.5955646685231447`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 76 - 82 (p. 276)", "Section"],

Cell[CellGroupData[{

Cell["Problem #76", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079249418969*^9, 3.5890794221392174`*^9, {
   3.5890812167188025`*^9, 3.5890812177288036`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "5"]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["2", "3"], " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "4"], " ", 
     RowBox[{"Tan", "[", "x", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953141127`*^9, {3.5890812286808205`*^9, 
   3.5890812363108315`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #77", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079249418969*^9, 3.5890794221392174`*^9, {
   3.5890812195138063`*^9, 3.5890812198938065`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "5"], 
      RowBox[{"Cos", "[", "x", "]"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["3", 
     RowBox[{"4", " ", 
      SqrtBox["2"]}]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"Cot", "[", "x", "]"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", "x", "]"}], "2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "4"], " ", 
         RowBox[{"Tan", "[", "x", "]"}]}]]}], 
      SqrtBox["2"]], "]"}]}], "+", 
   RowBox[{
    FractionBox["3", 
     RowBox[{"4", " ", 
      SqrtBox["2"]}]], 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}], "-", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{"Cot", "[", "x", "]"}], " ", 
       RowBox[{"Csc", "[", "x", "]"}], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "4"], " ", 
         RowBox[{"Tan", "[", "x", "]"}]}]]}]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "4"], " ", 
      RowBox[{"Tan", "[", "x", "]"}]}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953141127`*^9, {3.5890812425058403`*^9, 
   3.589081248140848*^9}, 3.589154256957238*^9, 3.6023694503288803`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #78", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.5890794221392174`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"], 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "14"]], ")"}], 
     RowBox[{"1", "/", "3"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["3", "5"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "12"], " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "+", 
   RowBox[{
    FractionBox["3", "11"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "12"], " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953141127`*^9, {3.5890812545058575`*^9, 
   3.589081260720866*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #79", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079251563972*^9, 
  3.5890794229092183`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "13"], " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "11"]}], ")"}], 
      RowBox[{"1", "/", "4"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     RowBox[{"9", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "11"], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "13"]}], ")"}], 
       RowBox[{"1", "/", "4"}]]}]]}], "-", 
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "11"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "13"]}], ")"}], 
     RowBox[{"1", "/", "4"}]]], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "5"]}], 
    RowBox[{"7", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "11"], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "13"]}], ")"}], 
      RowBox[{"1", "/", "4"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953141127`*^9, {3.589081267375876*^9, 
   3.589081272530884*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #80", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.5890794274367247`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], "-", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]}], 
     SqrtBox[
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "3"]}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SqrtBox["2"]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}], "-", 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{"Sec", "[", "x", "]"}], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]]}]}], "]"}]}], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "-", 
       RowBox[{"Sin", "[", "x", "]"}]}], "]"}], " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"Sin", "[", "x", "]"}], "]"}], " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]]], "-", 
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953141127`*^9, {3.5890812779858913`*^9, 
   3.589081283275899*^9}, 3.602369960815477*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #81", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.5890794277567253`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "3"], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}]], "-", 
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Tan", "[", "x", "]"}]], "-", 
      SqrtBox[
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "3"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcCoth", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", "x", "]"}], "+", 
         RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]]}]], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]], " ", 
    RowBox[{"ArcCoth", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox["2"], " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "+", 
         RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]]}]], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]], " ", 
    RowBox[{"ArcCoth", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], "+", 
       RowBox[{"Tan", "[", "x", "]"}]}], 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], " ", 
       SqrtBox[
        RowBox[{"Tan", "[", "x", "]"}]]}]], "]"}]}], "-", 
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", "x", "]"}], "-", 
         RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]]}]], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox["2"], " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "-", 
         RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]]}]], "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], "-", 
       RowBox[{"Tan", "[", "x", "]"}]}], 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"3", "/", "4"}]], " ", 
       SqrtBox[
        RowBox[{"Tan", "[", "x", "]"}]]}]], "]"}]}], "+", 
   RowBox[{"4", " ", 
    RowBox[{"Csc", "[", "x", "]"}], " ", 
    RowBox[{"Sec", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}]]}], "+", 
   FractionBox["4", 
    SqrtBox[
     RowBox[{"Tan", "[", "x", "]"}]]], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}], "]"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}]], " ", 
    SqrtBox[
     RowBox[{"Tan", "[", "x", "]"}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}]], " ", 
    SqrtBox[
     RowBox[{"Tan", "[", "x", "]"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695324113*^9, {3.58908129103841*^9, 
   3.589081294908416*^9}, {3.5890890578754387`*^9, 3.58908906971586*^9}, 
   3.5896772124489965`*^9, 3.602371093725068*^9, 3.602371347656714*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #82", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.5890794280917263`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"Sin", "[", "x", "]"}], 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "7"]], ")"}], 
       RowBox[{"1", "/", "3"}]], "-", 
      RowBox[{"3", " ", 
       RowBox[{"Tan", "[", "x", "]"}]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "5"]}], ")"}], 
      RowBox[{"2", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"9", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "4"]}], 
     RowBox[{"10", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], ")"}], 
       RowBox[{"2", "/", "3"}]]}]]}], "-", 
   RowBox[{
    FractionBox["9", "4"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], ")"}], 
     RowBox[{"4", "/", "3"}]]}], "+", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "6"], " ", 
       RowBox[{"Tan", "[", "x", "]"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "+", 
   RowBox[{
    FractionBox["3", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "6"], " ", 
       RowBox[{"Tan", "[", "x", "]"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "+", 
   RowBox[{
    FractionBox["3", "14"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "6"], " ", 
       RowBox[{"Tan", "[", "x", "]"}]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695324113*^9, {3.5890813034534283`*^9, 
   3.589081310343438*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 83 - 92 (p. 288-289)", "Section"],

Cell[CellGroupData[{

Cell["Problem #83", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.5890794283917265`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}], "+", "1"}], ")"}], 
     RowBox[{"5", "/", "2"}]], " ", 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"5", " ", 
      RowBox[{"ArcSinh", "[", 
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "]"}]}], 
     RowBox[{"16", " ", 
      SqrtBox["2"]}]]}], "-", 
   RowBox[{
    FractionBox["5", "16"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}]}]]}], "-", 
   RowBox[{
    FractionBox["5", "24"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"5", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695324113*^9, {3.5890813203534527`*^9, 
   3.5890813251434593`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #84", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.5890794287317266`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}], "+", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}], 
     RowBox[{"5", "/", "2"}]], " ", 
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["625", "32"], " ", 
    RowBox[{"ArcSin", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      SqrtBox["5"]], "]"}]}], "+", 
   RowBox[{
    FractionBox["125", "16"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"5", "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]}], "+", 
   RowBox[{
    FractionBox["25", "24"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"5", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695324113*^9, {3.5890813310209684`*^9, 
   3.5890813367959766`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #85", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.5890794290917273`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]], " ", 
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["3", "16"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "8"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953341126`*^9, {3.5890813425209846`*^9, 
   3.589081347538492*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #86", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.589079429431728*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"7", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"10", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"5", "/", "2"}]]}]], "-", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"15", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"7", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"15", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"7", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953341126`*^9, {3.589081354418502*^9, 
   3.5890813595435095`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #87", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9, 
  3.5890794297617283`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"ArcSin", "[", 
      RowBox[{
       SqrtBox[
        FractionBox["5", "2"]], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], 
    RowBox[{"5", " ", 
     SqrtBox["5"]}]], "+", 
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"10", " ", 
     SqrtBox[
      RowBox[{"2", "-", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953341126`*^9, {3.5890813647285166`*^9, 
   3.5890813704835253`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #88", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.589079430096729*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", 
      RowBox[{"5", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    RowBox[{"ArcSin", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "3"], "]"}]}], "-", 
   FractionBox[
    RowBox[{"55", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], 
    RowBox[{"27", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"9", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"295", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], 
    RowBox[{"243", " ", 
     SqrtBox[
      RowBox[{"9", "-", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953341126`*^9, {3.589081376238533*^9, 
   3.589081381678541*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #89", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079251563972*^9, 
  3.5890794312867303`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"3", " ", "x"}], "]"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", "5"}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]]}], "-", 
   FractionBox["5", 
    RowBox[{"8", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]}]], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953341126`*^9, {3.589081386103547*^9, 
   3.589081390803554*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #90", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.589079436334238*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "-", "1"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "3"]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"], "-", "5"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"Cos", "[", "x", "]"}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"], "-", "5"}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["5"]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["5"], " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"], "-", "5"}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["2", 
     SqrtBox["5"]], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"], "-", "5"}]], 
      SqrtBox["5"]], "]"}]}], "-", 
   RowBox[{"2", " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], 
      SqrtBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"], "-", "5"}]]], "]"}]}], "+", 
   FractionBox[
    RowBox[{"2", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"], "-", "5"}]]}], 
    RowBox[{"5", 
     RowBox[{"Sin", "[", "x", "]"}]}]], "+", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"], "-", "5"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953441124`*^9, {3.5890813958985615`*^9, 
   3.589081400883569*^9}, {3.6041113146840267`*^9, 3.6041113364440575`*^9}, {
   3.604111539016841*^9, 3.6041115449668493`*^9}, {3.6041123673755016`*^9, 
   3.6041124688456435`*^9}, 3.6041127653535585`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #91", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.5890794366442385`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      RowBox[{"3", " ", "x"}], "]"}], 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "-", 
      SqrtBox[
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", "1"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["5", 
     RowBox[{"4", " ", 
      SqrtBox["2"]}]], 
    RowBox[{"ArcSin", "[", 
     RowBox[{"2", " ", 
      SqrtBox[
       FractionBox["2", "7"]], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["3", "4"], " ", 
    RowBox[{"ArcSin", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      SqrtBox["3"]], "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "4"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", "1"}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "4"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], 
      SqrtBox[
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", "1"}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", "1"}]]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", "1"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953441124`*^9, {3.5890814069985776`*^9, 
   3.5890814119385843`*^9}, 3.604112246357832*^9, {3.604112496515682*^9, 
   3.604112499675687*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #92", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.5890794369842386`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "5"}]], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"4", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["5", "36"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"8", "/", "5"}]]}], "-", 
   RowBox[{
    FractionBox["20", "117"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"13", "/", "5"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953441124`*^9, {3.589081419243595*^9, 
   3.5890814240986023`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 93 - 97 (p. 293)", "Section"],

Cell[CellGroupData[{

Cell["Problem #93", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.5890794373542395`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]], " ", 
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcSin", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953441124`*^9, {3.589081435653619*^9, 
   3.589081441013626*^9}, 3.6044657433948603`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #94", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.58907943781424*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"3", "/", "2"}]], " ", 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", 
      RowBox[{"8", " ", 
       SqrtBox["2"]}]]}], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], 
      SqrtBox[
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]], "]"}]}], "+", 
   RowBox[{
    FractionBox["3", "8"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"3", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953541126`*^9, {3.589081445693633*^9, 
   3.589081461383656*^9}, {3.6044657821609282`*^9, 3.6044657950465508`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #95", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.5890794384892406`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sin", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Cos", "[", 
     RowBox[{"3", " ", "x"}], "]"}], 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"3", "/", "2"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953541126`*^9, {3.589081470428669*^9, 
   3.589081475368676*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #96", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.589079439219242*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"3", "/", "2"}]], 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["5", "2"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], 
      SqrtBox[
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Sec", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953541126`*^9, {3.5890814874711933`*^9, 
   3.589081493556202*^9}, {3.604465825419804*^9, 3.604465827650608*^9}, {
   3.6044660426189857`*^9, 3.604466046253792*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #97", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9, 
  3.589079439759243*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "3"]}], "-", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"4", " ", "x"}], "]"}]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csc", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}], 
       RowBox[{"7", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       RowBox[{
        SqrtBox["2"], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], 
       SqrtBox[
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]]], "]"}], 
     SqrtBox["2"]]}], "-", 
   FractionBox[
    RowBox[{"11", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], 
    RowBox[{"20", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"3", "/", "2"}]]}]], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"]}], 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"63", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], 
    RowBox[{"20", " ", 
     SqrtBox[
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}]]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"]}], 
    RowBox[{"10", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"5", "/", "2"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953541126`*^9, {3.589081499711211*^9, 
   3.5890815046662183`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 98 - 103 (p. 297)", "Section"],

Cell[CellGroupData[{

Cell["Problem #98", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.589079440334244*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"4", "-", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"8", " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Tan", "[", "x", "]"}]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["7", "2"], " ", 
    SqrtBox["5"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["5"], " ", 
       RowBox[{"Tan", "[", "x", "]"}]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["5", "2"], " ", 
    RowBox[{"Tan", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695364113*^9, {3.589081520856241*^9, 
   3.5890815283012524`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #99", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079251563972*^9, 
  3.589079441514245*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"4", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Tan", "[", "x", "]"}]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]], "]"}]}], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"Tan", "[", "x", "]"}]}], 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695364113*^9, {3.589081533116259*^9, 
   3.5890815384712667`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #100", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, 3.589079538691885*^9, {
   3.589079586468956*^9, 3.5890795871489573`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"Cot", "[", "x", "]"}], "2"]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"Tan", "[", "x", "]"}]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]], "]"}]}], "-", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}]], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     RowBox[{"Cot", "[", "x", "]"}]}], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}]], "-", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}], "+", 
   RowBox[{
    FractionBox["9", "2"], " ", 
    RowBox[{"Cot", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695364113*^9, {3.589081544236275*^9, 
   3.5890815497062826`*^9}, {3.6044653408673534`*^9, 3.6044653435661583`*^9}, 
   3.6044653763418155`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #101", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.589079538691885*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], "-", "3"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
      SqrtBox[
       RowBox[{"4", "-", 
        SuperscriptBox[
         RowBox[{"Cot", "[", "x", "]"}], "2"]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], " ", 
    SqrtBox[
     RowBox[{"4", "-", 
      SuperscriptBox[
       RowBox[{"Cot", "[", "x", "]"}], "2"]}]], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    SqrtBox[
     RowBox[{"4", "-", 
      SuperscriptBox[
       RowBox[{"Cot", "[", "x", "]"}], "2"]}]], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695364113*^9, {3.5890815546812897`*^9, 
   3.5890815783713245`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #102", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.5890795422618904`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"Tan", "[", "x", "]"}], "3"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"], "-", "2"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "-", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTanh", "[", 
      FractionBox[
       SqrtBox[
        RowBox[{"5", "-", 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"Sec", "[", "x", "]"}], "2"]}]}]], 
       SqrtBox["3"]], "]"}], 
     RowBox[{"6", " ", 
      SqrtBox["3"]}]]}], "-", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{"5", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", "x", "]"}], "2"]}]}]], 
      SqrtBox["5"]], "]"}], 
    RowBox[{"5", " ", 
     SqrtBox["5"]}]], "-", 
   FractionBox["2", 
    RowBox[{"15", " ", 
     SqrtBox[
      RowBox[{"5", "-", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", "x", "]"}], "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953741126`*^9, {3.589081585056334*^9, 
   3.5890815908113422`*^9}, 3.5891544208574677`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #103", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.5890795430918913`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sec", "[", "x", "]"}], "2"], "-", 
      RowBox[{"3", " ", 
       RowBox[{"Tan", "[", "x", "]"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"Sec", "[", "x", "]"}], "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"Sec", "[", "x", "]"}], "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "4"]}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Tan", "[", "x", "]"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["3", "8"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"4", "+", 
      RowBox[{"9", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], "]"}]}], "-", 
   FractionBox[
    RowBox[{"Cot", "[", "x", "]"}], 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{"4", "+", 
       RowBox[{"9", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}]], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     RowBox[{"Tan", "[", "x", "]"}]}], 
    RowBox[{"8", " ", 
     SqrtBox[
      RowBox[{"4", "+", 
       RowBox[{"9", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953741126`*^9, {3.5890815977963524`*^9, 
   3.5890816036313605`*^9}, {3.58967797707273*^9, 3.589678007714483*^9}, 
   3.6138002038202515`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 104 - 110 (p. 303)", "Section"],

Cell[CellGroupData[{

Cell["Problem #104", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.5890795437018924`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"5", "/", "2"}]], " ", 
    RowBox[{"Tan", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "32"}], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}], "]"}]}], "+", 
   RowBox[{"16", " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}], "-", 
   RowBox[{
    FractionBox["4", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"5", "/", "2"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953741126`*^9, {3.5890816140763755`*^9, 
   3.589081619236383*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #105", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.5890795442668934`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Tan", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "32"], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}], "]"}]}], "-", 
   FractionBox["1", 
    RowBox[{"12", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox["1", 
    RowBox[{"16", " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953741126`*^9, {3.589081625661392*^9, 
   3.589081631926401*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #106", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.589079544746894*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Tan", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "+", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox[
     SqrtBox["3"], 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "3"], "-", 
         SuperscriptBox["b", "3"]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["3"]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "3"], "+", 
             RowBox[{
              SuperscriptBox["b", "3"], " ", 
              SuperscriptBox[
               RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "3"], "-", 
            SuperscriptBox["b", "3"]}], ")"}], 
          RowBox[{"1", "/", "3"}]]]}], ")"}]}], "]"}]}], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        SuperscriptBox["b", "3"]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "3"], "-", 
          SuperscriptBox["b", "3"]}], ")"}], 
        RowBox[{"1", "/", "3"}]], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "3"], "+", 
          RowBox[{
           SuperscriptBox["b", "3"], " ", 
           SuperscriptBox[
            RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], "]"}]}], 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        SuperscriptBox["b", "3"]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953741126`*^9, {3.589081636591408*^9, 
   3.5890816409464145`*^9}, {3.5890821386581354`*^9, 3.589082141693139*^9}, 
   3.595042893111318*^9, 3.6280207108449354`*^9, 3.6280207691750383`*^9, {
   3.689973115895673*^9, 3.689973165585515*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #107", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9, 
  3.589079545336895*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"7", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    RowBox[{"Tan", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", 
    SqrtBox["3"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"7", " ", 
           SuperscriptBox[
            RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      SqrtBox["3"]], "]"}]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], "+", 
   RowBox[{"3", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"7", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["3", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"7", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"2", "/", "3"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953841124`*^9, {3.5890816485864253`*^9, 
   3.589081653916433*^9}, 3.5950429128834486`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #108a", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.5890795459368954`*^9, 3.6023717242810764`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cot", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"1", "/", "4"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "+", 
          RowBox[{
           SuperscriptBox["b", "4"], " ", 
           SuperscriptBox[
            RowBox[{"Csc", "[", "x", "]"}], "2"]}]}], ")"}], 
        RowBox[{"1", "/", "4"}]], "a"], "]"}], "a"]}], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"1", "/", "4"}]], "a"], "]"}], "a"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953841124`*^9, {3.5890816585214396`*^9, 
   3.5890816633914466`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #108b", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.5890795459368954`*^9, 3.602371725700679*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Cot", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", "x", "]"}], "2"]}]}], ")"}], 
      RowBox[{"1", "/", "4"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "4"], " ", 
           SuperscriptBox[
            RowBox[{"Csc", "[", "x", "]"}], "2"]}]}], ")"}], 
        RowBox[{"1", "/", "4"}]], "a"], "]"}], "a"]}], "+", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "4"], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"1", "/", "4"}]], "a"], "]"}], "a"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953841124`*^9, {3.5890816585214396`*^9, 
   3.5890816633914466`*^9}, 3.602371734296294*^9, 3.6023717967432036`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #109", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079251563972*^9, 
  3.589079546801897*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox[
              RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}]}], ")"}], " ", 
      RowBox[{"Tan", "[", "x", "]"}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"5", "/", "6"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox[
            RowBox[{"Sec", "[", "x", "]"}], "2"]}]}]]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    SqrtBox["3"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox[
             RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}], 
         RowBox[{"1", "/", "6"}]]}]}], 
      SqrtBox["3"]], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Log", "[", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"], "]"}]}], "-", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"1", "/", "6"}]]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", "x", "]"}], "2"]}]}]]}], "]"}]}], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}], 
    RowBox[{"1", "/", "6"}]], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"2", "/", "3"}]]}], "+", 
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SqrtBox[
        RowBox[{"1", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox[
           RowBox[{"Sec", "[", "x", "]"}], "2"]}]}]]}], ")"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953841124`*^9, {3.5890816689464545`*^9, 
   3.589081675356464*^9}, 3.5890891407895846`*^9, 3.5890891825664577`*^9, {
   3.589154491747567*^9, 3.5891545726876802`*^9}, 3.602377712709515*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #110", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079227683937*^9, {3.589079282114016*^9, 
   3.5890792825940166`*^9}, 3.5890793251840773`*^9, {3.589079554621908*^9, 
   3.5890795737489376`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Tan", "[", "x", "]"}], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{"2", " ", "x"}], "]"}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"Tan", "[", "x", "]"}], 
      SqrtBox[
       RowBox[{
        RowBox[{"Tan", "[", "x", "]"}], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]]], "]"}]}], "-", 
   RowBox[{
    FractionBox["11", 
     RowBox[{"4", " ", 
      SqrtBox["2"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{"Tan", "[", "x", "]"}]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"Tan", "[", "x", "]"}], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]]], "]"}]}], "+", 
   FractionBox[
    RowBox[{"Tan", "[", "x", "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Tan", "[", "x", "]"}], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "x", "]"}], "3"]}], 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Tan", "[", "x", "]"}], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"Tan", "[", "x", "]"}]}], 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], " ", 
       RowBox[{"Tan", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953841124`*^9, {3.58908168632648*^9, 
   3.589081690646486*^9}, {3.602378099017556*^9, 3.602378112977576*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 111 - 113 (p. 305-306)", "Section"],

Cell[CellGroupData[{

Cell["Problem #111", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079227683937*^9, 
  3.5890793262890797`*^9, 3.5890795626919193`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Tan", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "n"]}]}], ")"}], 
      RowBox[{"4", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SqrtBox["3"], 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "n"}]]}], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "3"], "-", 
           RowBox[{
            SuperscriptBox["b", "3"], " ", 
            SuperscriptBox[
             RowBox[{"Cos", "[", "x", "]"}], "n"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]}], 
      RowBox[{
       SqrtBox["3"], " ", "a"}]], "]"}]}], "-", 
   FractionBox["3", 
    RowBox[{
     SuperscriptBox["a", "3"], " ", "n", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "3"], "-", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "n"]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"]}]], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"a", "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "3"], "-", 
          RowBox[{
           SuperscriptBox["b", "3"], " ", 
           SuperscriptBox[
            RowBox[{"Cos", "[", "x", "]"}], "n"]}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], "]"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"], " ", "n"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953941126`*^9, {3.589081742901561*^9, 
   3.589081746981567*^9}, {3.589082191338211*^9, 3.5890822016032257`*^9}, {
   3.628021093316629*^9, 3.6280210962276344`*^9}, 3.6280213656591177`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #112", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792349739475`*^9, 
  3.589079327429081*^9, 3.589079563831921*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "9"]}]}], ")"}], 
     RowBox[{"5", "/", "6"}]], " ", 
    RowBox[{"Tan", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"Cos", "[", "x", "]"}], "9"]}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      RowBox[{
       SqrtBox["3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"Cos", "[", "x", "]"}], "9"]}]}], ")"}], 
        RowBox[{"1", "/", "6"}]]}]], "]"}], 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"ArcTanh", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "9"]}]}], ")"}], 
      RowBox[{"1", "/", "6"}]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    RowBox[{"ArcTanh", "[", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "9"]}]}]], "]"}]}], "-", 
   RowBox[{
    FractionBox["2", "15"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "9"]}]}], ")"}], 
     RowBox[{"5", "/", "6"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953941126`*^9, {3.589081753466576*^9, 
   3.589081757991583*^9}, {3.5890822071707335`*^9, 3.5890822150607452`*^9}, 
   3.602379835559989*^9, 3.604118424298264*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #113", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792369264507`*^9, 
  3.589079328804083*^9, 3.589079563941921*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "9"], " ", 
      RowBox[{"Cot", "[", "x", "]"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "3"]}]}], ")"}], 
      RowBox[{"4", "/", "3"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["4", 
    RowBox[{"125", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "3"]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]], "+", 
   RowBox[{
    FractionBox["2", "125"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "3"]}]}], ")"}], 
     RowBox[{"2", "/", "3"}]]}], "-", 
   RowBox[{
    FractionBox["1", "625"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "3"]}]}], ")"}], 
     RowBox[{"5", "/", "3"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953941126`*^9, {3.5890817630725937`*^9, 
   3.5890817789701166`*^9}, 3.613800271419118*^9, 3.628021551583578*^9, 
   3.6280216298487167`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 114 - 120 (p. 308-309)", "Section"],

Cell[CellGroupData[{

Cell["Problem #114", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079239021454*^9, 
  3.589079330989086*^9, 3.589079564063924*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], ")"}], " ", 
      RowBox[{"Tan", "[", "x", "]"}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"8", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"2", "/", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", "32"]}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"8", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], ")"}], "2"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.5890796953941126`*^9, {3.5890817914876347`*^9, 
   3.5890818068451567`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #115", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792424814587`*^9, 
  3.5890793329340887`*^9, 3.589079564193924*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"8", " ", 
            SuperscriptBox[
             RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], ")"}], " ", 
      RowBox[{"Cot", "[", "x", "]"}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"8", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"2", "/", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Log", "[", 
     RowBox[{"Tan", "[", "x", "]"}], "]"}]}], "+", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"8", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695404113*^9, {3.5890818123726654`*^9, 
   3.589081820452677*^9}, 3.6023799782976885`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #116", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792450389624`*^9, 
  3.589079334449091*^9, 3.589079564313924*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", "1"}]]}], ")"}], " ", 
      RowBox[{"Tan", "[", "x", "]"}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", "1"}], ")"}], 
       RowBox[{"1", "/", "4"}]], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"5", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", "1"}]]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", 
      SqrtBox["2"]]}], 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      SqrtBox["2"]], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]], 
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      SqrtBox["2"]], "]"}]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]}], ")"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695404113*^9, {3.58908182957269*^9, 
   3.5890818346476974`*^9}, {3.589082241885784*^9, 3.589082251700798*^9}, 
   3.6023803017231417`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #117", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.5890792470039654`*^9, 
  3.5890793356090927`*^9, 3.589079564443924*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    RowBox[{"Tan", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "40"]}], 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"5", "/", "3"}]]}], "-", 
   RowBox[{
    FractionBox["3", "64"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"8", "/", "3"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695404113*^9, {3.5890818483127165`*^9, 
   3.589081865417742*^9}, {3.6044658619394684`*^9, 3.604465870472683*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #118", "Subsection",
 CellChangeTimes->{3.589079165503848*^9, 3.589079249418969*^9, 
  3.5890793376040955`*^9, 3.5890795645639243`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "6"], " ", 
      RowBox[{"Tan", "[", "x", "]"}]}], 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"3", "/", "4"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "-", 
       SqrtBox[
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}], 
        RowBox[{"1", "/", "4"}]]}]], "]"}], 
    SqrtBox["2"]], "-", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       SqrtBox[
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}], 
        RowBox[{"1", "/", "4"}]]}]], "]"}], 
    SqrtBox["2"]], "+", 
   RowBox[{
    FractionBox["71", "45"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"1", "/", "4"}]]}], "+", 
   RowBox[{
    FractionBox["13", "45"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"1", "/", "4"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "9"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], 
     RowBox[{"1", "/", "4"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "4"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695404113*^9, {3.589081872247751*^9, 
   3.589081879472762*^9}, {3.604116917251151*^9, 3.604116928571167*^9}, 
   3.6041170387088213`*^9, {3.604117174079011*^9, 3.604117179009018*^9}, 
   3.6041172536191225`*^9, 3.6041176069371176`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #119", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079251563972*^9, {3.5890795646939244`*^9, 
   3.5890795695189314`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"Tan", "[", "x", "]"}], " ", 
      RowBox[{"Tan", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"Tan", "[", "x", "]"}], 
     SqrtBox[
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], " ", 
       RowBox[{"Tan", "[", 
        RowBox[{"2", " ", "x"}], "]"}]}]]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695414113*^9, {3.5890818897077765`*^9, 
   3.589081895455285*^9}, 3.602380554590996*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #120", "Subsection",
 CellChangeTimes->{
  3.589079165503848*^9, 3.589079251563972*^9, {3.5890795646939244`*^9, 
   3.5890795695189314`*^9}, {3.589079601638978*^9, 3.589079602523979*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{"Cot", "[", 
       RowBox[{"2", " ", "x"}], "]"}], 
      RowBox[{"Cot", "[", "x", "]"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcSin", "[", 
      RowBox[{"Tan", "[", "x", "]"}], "]"}], 
     SqrtBox["2"]]}], "+", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["2"], " ", 
      RowBox[{"Tan", "[", "x", "]"}]}], 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}]]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5890791563338346`*^9, 
   3.589079157123836*^9}, 3.589079695414113*^9, {3.5890819007302923`*^9, 
   3.589081905290299*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Chapter 6 (p. 310-330)\n",
 StyleBox["Rational and Algebraic Function Integration Problems",
  FontSize->24]
}], "Subtitle",
 CellChangeTimes->{{3.5950910754931736`*^9, 3.59509110077662*^9}, {
  3.5950913929563313`*^9, 3.5950914019088435`*^9}, {3.5950918541987133`*^9, 
  3.595091861876152*^9}, {3.5952738722766824`*^9, 3.5952738728066835`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->28],

Cell[CellGroupData[{

Cell["Problems 1 - 5 (p. 314)", "Section",
 CellChangeTimes->{3.594154869972735*^9, 3.5942373335696173`*^9}],

Cell[CellGroupData[{

Cell["Problem #1", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561390193644`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"20", " ", 
      SuperscriptBox["x", "4"]}]]}], "+", 
   FractionBox["1", 
    RowBox[{"50", " ", 
     SuperscriptBox["x", "2"]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], "125"], "-", 
   RowBox[{
    FractionBox["1", "250"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237411359726*^9, 3.5942374152797318`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561401113663`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"25", " ", 
      SuperscriptBox["x", "5"]}]]}], "+", 
   FractionBox["1", 
    RowBox[{"75", " ", 
     SuperscriptBox["x", "3"]}]], "-", 
   FractionBox["1", 
    RowBox[{"125", " ", "x"}]], "-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox["x", 
      SqrtBox["5"]], "]"}], 
    RowBox[{"125", " ", 
     SqrtBox["5"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237419199737*^9, 3.5942374229597425`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "4"}], ")"}], "4"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"24", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"4", "-", 
        SuperscriptBox["x", "2"]}], ")"}], "3"]}]], "+", 
   FractionBox["1", 
    RowBox[{"64", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"4", "-", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "+", 
   FractionBox["1", 
    RowBox[{"128", " ", 
     RowBox[{"(", 
      RowBox[{"4", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], "256"], "-", 
   RowBox[{
    FractionBox["1", "512"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"4", "-", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237427079748*^9, 3.5942374305097528`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #4", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372352394795`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "2"}], ")"}], 
       RowBox[{"5", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "2"}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]]}], "+", 
   FractionBox["1", 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "-", "2"}]], 
      SqrtBox["2"]], "]"}], 
    RowBox[{"4", " ", 
     SqrtBox["2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237437939763*^9, 3.5942374424997697`*^9}, {3.594237916830434*^9, 
   3.5942379421404696`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372365894814`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "10"}], ")"}], 
      RowBox[{"5", "/", "2"}]], "x"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"100", " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "-", "10"}]]}], "-", 
   RowBox[{
    FractionBox["10", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", "10"}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", "10"}], ")"}], 
     RowBox[{"5", "/", "2"}]]}], "-", 
   RowBox[{"100", " ", 
    SqrtBox["10"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "-", "10"}]], 
      SqrtBox["10"]], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237446789776*^9, 3.594237450529781*^9}, {3.5942379639504995`*^9, 
   3.5942379697005076`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 6 - 21 (p. 327-328)", "Section",
 CellChangeTimes->{
  3.594154869972735*^9, {3.5942373335696173`*^9, 3.5942373495196395`*^9}}],

Cell[CellGroupData[{

Cell["Problem #6", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.594237237979483*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"2", " ", "n"}], "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   SuperscriptBox["x", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237458559792*^9, 3.5942374621497974`*^9}, {3.594238017660575*^9, 
   3.594238023470583*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #7", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.594237239329485*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "7"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "5"}], ")"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox["125", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"5", "-", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "+", 
   FractionBox["75", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["15", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"5", "-", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237466279803*^9, 3.594237470029808*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #8", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372408894873`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["x", "5"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["x", "3"]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "1"}], ")"}], "5"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"8", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], "4"]}]], "+", 
   FractionBox["1", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], "3"]}]], "-", 
   FractionBox["3", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942374742598143`*^9, 3.5942374782698193`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #9", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372424494896`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"9", "/", "14"}]], " ", 
    SuperscriptBox["x", "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["7", "23"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"23", "/", "14"}]]}], "+", 
   RowBox[{
    FractionBox["7", "37"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"37", "/", "14"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942374910298376`*^9, 3.594237496189845*^9}, {3.594237729230171*^9, 
   3.5942377365901814`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #10", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.594237245259494*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "5"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", "4"}], ")"}], 
      RowBox[{"13", "/", "6"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["48", 
     RowBox[{"7", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "4"}], ")"}], 
       RowBox[{"7", "/", "6"}]]}]]}], "-", 
   FractionBox["24", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", "4"}], ")"}], 
     RowBox[{"1", "/", "6"}]]], "+", 
   RowBox[{
    FractionBox["3", "5"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", "4"}], ")"}], 
     RowBox[{"5", "/", "6"}]]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237500749851*^9, 3.594237504909857*^9}, {3.5942380513706217`*^9, 
   3.5942380546106267`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #11", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372497795*^9}, 3.594237280769543*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    RowBox[{"3", " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942375092398634`*^9, 3.5942375135398693`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #12", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372497795*^9}, 3.5942372843895483`*^9, {3.5942375318498945`*^9, 
   3.5942375320898952`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"2", " ", "x"}], "-", "1"}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "-", "x"}], 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"2", " ", "x"}], "-", "1"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "-", 
   FractionBox[
    RowBox[{"1", "-", "x"}], 
    RowBox[{"6", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"2", " ", "x"}], "-", "1"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942375181498756`*^9, 3.5942375295498915`*^9}, {3.5942380801306624`*^9, 
   3.594238082010665*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #13", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372497795*^9}, 3.5942372825395455`*^9, {3.5942375340298977`*^9, 
   3.594237534259898*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "-", "8"}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"24", " ", 
     SuperscriptBox["x", "3"], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", "8"}]]}]], "+", 
   FractionBox["1", 
    RowBox[{"48", " ", "x", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", "8"}]]}]], "-", 
   FractionBox["x", 
    RowBox[{"192", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", "8"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942375486799183`*^9, 3.594237553259925*^9}, {3.5942381068006997`*^9, 
   3.594238109750704*^9}, {3.613800359389149*^9, 3.6138003695117283`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #14", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372497795*^9}, 3.594237286349551*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "5"}], ")"}], "2"], 
     RowBox[{
      SuperscriptBox["x", "4"], " ", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["15", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", 
       RowBox[{"10", "/", "3"}]]}]]}], "-", 
   FractionBox["15", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", 
      RowBox[{"4", "/", "3"}]]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", 
      RowBox[{"2", "/", "3"}]]}], "2"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942375576399307`*^9, 3.594237562129937*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #15", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372497795*^9}, 3.5942372888195543`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["x", "7"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}], ")"}], "3"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"6", " ", 
      SuperscriptBox["x", "6"]}]]}], "+", 
   FractionBox["3", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "4"]}]], "-", 
   FractionBox["3", 
    SuperscriptBox["x", "2"]], "-", 
   FractionBox["1", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "-", 
   FractionBox["2", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]], "-", 
   RowBox[{"10", " ", 
    RowBox[{"Log", "[", "x", "]"}]}], "+", 
   RowBox[{"5", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942375676999445`*^9, 3.5942375718899508`*^9}, 3.6138005203293543`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #16", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372497795*^9}, 3.5942372903195567`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"2", "+", 
         SuperscriptBox["x", "2"]}], 
        SuperscriptBox["x", "2"]], ")"}], 
      RowBox[{"7", "/", "9"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"9", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"2", "+", 
         SuperscriptBox["x", "2"]}], 
        SuperscriptBox["x", "2"]], ")"}], 
      RowBox[{"7", "/", "9"}]], " ", "x"}], 
    RowBox[{"10", " ", 
     SqrtBox[
      RowBox[{"2", "+", 
       SuperscriptBox["x", "2"]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942375774299583`*^9, 3.5942375841299677`*^9}, 3.594238151920763*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #17", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372497795*^9}, 3.5942372917395587`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "4"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SqrtBox["10"], "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"9", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "5"], 
    RowBox[{"7", " ", 
     SqrtBox["10"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SqrtBox["10"], "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"7", "/", "2"}]]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], 
    RowBox[{"175", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SqrtBox["10"], "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"5", "/", "2"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237591119978*^9, 3.5942375957399845`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #18", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372497795*^9}, 3.5942372933695607`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "2"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    SqrtBox[
     RowBox[{"3", "-", 
      SuperscriptBox["x", "2"]}]]], "-", 
   RowBox[{"ArcSin", "[", 
    FractionBox["x", 
     SqrtBox["3"]], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942376000799904`*^9, 3.5942376039299955`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #19", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.5942372497795*^9}, 3.594237296239565*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"25", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      RowBox[{"3", "/", "2"}]], 
     SuperscriptBox["x", "4"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"25", "-", 
      SuperscriptBox["x", "2"]}]], "x"], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"25", "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]], 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "3"]}]], "+", 
   RowBox[{"ArcSin", "[", 
    FractionBox["x", "5"], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237610260004*^9, 3.59423761434001*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #20", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.594237267079524*^9}, 3.594237297999567*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"7", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"5", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"4", " ", "x"}], 
    RowBox[{"15", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "+", 
   FractionBox[
    RowBox[{"8", " ", "x"}], 
    RowBox[{"15", " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237618750016*^9, 3.594237622790022*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #21", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.594237267079524*^9}, 3.594237300469571*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"6", " ", "x"}], "-", "7"}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", "-", "x"}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"6", " ", "x"}], "-", "7"}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]]}], "-", 
   FractionBox[
    RowBox[{"3", "-", "x"}], 
    RowBox[{"6", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"6", " ", "x"}], "-", "7"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.59423762856003*^9, 3.5942376322600355`*^9}, {3.594238190440817*^9, 
   3.5942381923808193`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 22 - 25 (p. 329)", "Section",
 CellChangeTimes->{
  3.594154869972735*^9, {3.5942373335696173`*^9, 3.5942373782496796`*^9}}],

Cell[CellGroupData[{

Cell["Problem #22", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.594237267079524*^9}, 3.5942373016495724`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"2", " ", "x"}], "+", "1"}], ")"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "-", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "4"]}], "-", 
   FractionBox[
    RowBox[{"12", " ", 
     SuperscriptBox["x", "5"]}], "5"], "-", 
   RowBox[{"4", " ", 
    SuperscriptBox["x", "6"]}], "-", 
   FractionBox[
    RowBox[{"8", " ", 
     SuperscriptBox["x", "7"]}], "7"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237640270046*^9, 3.5942376451600533`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #23", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.594237267079524*^9}, 3.5942373037595754`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", "x", "-", "1"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", "x"}], "-", "1"}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "3"]}], "3"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "4"]}], "4"], "-", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "5"]}], "5"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "6"]}], "6"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942376504800606`*^9, 3.594237654090066*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #24", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.594237267079524*^9}, 3.594237305859578*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"3", " ", "x"}], "+", "1"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"8", " ", "x"}], "+", "1"}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "-", 
     RowBox[{"2", " ", "x"}]}], 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"8", " ", "x"}], "+", "1"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}]], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", "x"}], ")"}]}], 
    RowBox[{"21", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"8", " ", "x"}], "+", "1"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.5942376602200747`*^9, 3.594237665210081*^9}, {3.5942382050408373`*^9, 
   3.5942382069308395`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #25", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9, 
   3.5941550296546154`*^9, 3.5941561413593683`*^9, {3.5942372247994647`*^9, 
   3.594237267079524*^9}, 3.594237307759581*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"8", " ", 
       SuperscriptBox["x", "3"]}], "-", 
      RowBox[{"8", " ", "x"}], "-", "1"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"5", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}], 
     RowBox[{"15", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "x"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]]}], "-", 
   FractionBox[
    RowBox[{"7", "+", 
     RowBox[{"122", " ", "x"}]}], 
    RowBox[{"75", " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["x", "2"]}]}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9, {
   3.5941550111529827`*^9, 3.594155015552191*^9}, {3.5941551484020243`*^9, 
   3.5941551528168316`*^9}, {3.594237205989438*^9, 3.594237209249443*^9}, {
   3.594237669970088*^9, 3.594237676190097*^9}, 3.594238713641549*^9, 
   3.6999731205227427`*^9}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Chapter 7 (p. 331-344)\n",
 StyleBox["Trigonometric Function Integration Problems",
  FontSize->24]
}], "Subtitle",
 CellChangeTimes->{{3.5950910754931736`*^9, 3.59509110077662*^9}, {
  3.595091419247835*^9, 3.595091426659259*^9}, {3.595091911353982*^9, 
  3.595091917807351*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->28],

Cell[CellGroupData[{

Cell["Problems 1 - 4 (p. 334)", "Section"],

Cell[CellGroupData[{

Cell["Problem #1", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834982865099*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["16", "15"], " ", "x", " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["8", "45"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"]}], "+", 
   RowBox[{
    FractionBox["2", "25"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "5"]}], "-", 
   FractionBox[
    RowBox[{"298", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "225"], "+", 
   RowBox[{
    FractionBox["8", "15"], " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["4", "15"], " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   FractionBox[
    RowBox[{"76", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}], "675"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "5"]}], "125"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.5898573455376043`*^9, 
   3.589857353018032*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834985370242*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["40", "9"], " ", "x", " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["2", "3"], " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], "-", 
   FractionBox[
    RowBox[{"40", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "9"], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["2", "9"], " ", "x", " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}], "27"], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.5898573594373994`*^9, 
   3.5898573653667383`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834987871385*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "6"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"245", " ", "x"}], "1152"]}], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "3"]}], "48"], "+", 
   FractionBox[
    RowBox[{"245", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "1152"], "-", 
   RowBox[{
    FractionBox["5", "16"], " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["5", "16"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
   FractionBox[
    RowBox[{"65", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}], "1728"], "-", 
   RowBox[{
    FractionBox["5", "24"], " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
   RowBox[{
    FractionBox["5", "48"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "4"]}], "+", 
   RowBox[{
    FractionBox["1", "108"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "5"]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "5"]}], "+", 
   RowBox[{
    FractionBox["1", "18"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "6"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.589857371840109*^9, 
   3.5898573777934494`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #4", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834990321525*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["4", "9"], " ", "x", " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], "-", 
   FractionBox[
    RowBox[{"4", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "9"], "+", 
   RowBox[{
    FractionBox["2", "9"], " ", "x", " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}], "27"], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.5898573908751974`*^9, 
   3.5898573980816097`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 5 - 9 (p. 342-343) ", "Section"],

Cell[CellGroupData[{

Cell["Problem #5", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834992433646*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "4"]}], 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"]}], "4"]}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"], "4"], "-", 
   RowBox[{"x", " ", 
    RowBox[{"Cot", "[", "x", "]"}]}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", "x", " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.5898574153525977`*^9, 
   3.5898574285543528`*^9}, {3.589860149272969*^9, 3.5898601559053483`*^9}, {
   3.6123252071814547`*^9, 3.6123252115114603`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.5898349952288055`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}], 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "4"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["5", "6"], " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"Sec", "[", "x", "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "3"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "3"]}], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Sec", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.589857435746764*^9, 
   3.5898574422601366`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #7", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589834998651002*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"]}], "-", 
   FractionBox[
    RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.589857454259823*^9, 
   3.589857460349171*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #8", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.589835009380615*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}], 
     RowBox[{"Cos", "[", "x", "]"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "4"], "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["x", "2"]}], "2"], "-", 
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], "]"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.589857471062784*^9, 
   3.589857479493266*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #9", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, 3.5898350122887816`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}], 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "2"], "-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}], "]"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "x"}]]}]}], "]"}]}], "-", 
   FractionBox[
    RowBox[{"Tan", "[", "x", "]"}], "2"], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.589857485820628*^9, 
   3.589857494102102*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 10 - 11 (p. 344)", "Section"],

Cell[CellGroupData[{

Cell["Problem #10", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, {3.5898350149319324`*^9, 3.589835015293954*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "+", 
        RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox["2", 
   RowBox[{"1", "+", 
    FractionBox[
     RowBox[{"Cot", "[", "x", "]"}], "x"]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.589857509062958*^9, 
   3.5898575167433968`*^9}, 3.6125627887507877`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #11", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5898349299780736`*^9, {3.5898350177390933`*^9, 3.5898350179471054`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["x", 
       RowBox[{
        RowBox[{"x", " ", 
         RowBox[{"Cos", "[", "x", "]"}]}], "-", 
        RowBox[{"Sin", "[", "x", "]"}]}]], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "-", 
    RowBox[{"Sin", "[", "x", "]"}]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.5898349166343107`*^9, 
   3.589834922378639*^9}, {3.5898350918023295`*^9, 3.5898351183638487`*^9}, {
   3.5898571509454746`*^9, 3.589857155366727*^9}, {3.5898575238218017`*^9, 
   3.5898575303511753`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Chapter 8 (p. 345-378)\n",
 StyleBox["Exponential, Hyperbolic and Logarithmic Function Integration \
Problems",
  FontSize->24]
}], "Subtitle",
 CellChangeTimes->{{3.5950910754931736`*^9, 3.59509110077662*^9}, {
  3.5950914463643866`*^9, 3.5950914563549576`*^9}, {3.595092029754754*^9, 
  3.5950920689769974`*^9}, {3.5952739300867634`*^9, 3.5952739313467655`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->28],

Cell[CellGroupData[{

Cell["Problems 1 - 5 (p. 346)", "Section"],

Cell[CellGroupData[{

Cell["Problem #1", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, {
   3.592852767262048*^9, 3.5928527749720583`*^9}, 3.5928533544373713`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["a", 
     RowBox[{"m", " ", "x"}]], " ", 
    SuperscriptBox["b", 
     RowBox[{"n", " ", "x"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", 
     RowBox[{"m", " ", "x"}]], " ", 
    SuperscriptBox["b", 
     RowBox[{"n", " ", "x"}]]}], 
   RowBox[{
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}], "+", 
    RowBox[{"n", " ", 
     RowBox[{"Log", "[", "b", "]"}]}]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592851160890297*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #2", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.592852780932067*^9, 3.592853357427376*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "x"], "-", 
        SuperscriptBox["b", "x"]}], ")"}], "2"], 
     RowBox[{
      SuperscriptBox["a", "x"], " ", 
      SuperscriptBox["b", "x"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "x"}], "+", 
   FractionBox[
    RowBox[{
     FractionBox[
      SuperscriptBox["a", "x"], 
      SuperscriptBox["b", "x"]], "-", 
     FractionBox[
      SuperscriptBox["b", "x"], 
      SuperscriptBox["a", "x"]]}], 
    RowBox[{
     RowBox[{"Log", "[", "a", "]"}], "-", 
     RowBox[{"Log", "[", "b", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735791722603*^9, 3.589735797988961*^9}, {
   3.589748038150654*^9, 3.5897480409278126`*^9}, 3.5928491149129295`*^9, 
   3.592849235000598*^9, 3.592849287060671*^9, {3.5928495476005373`*^9, 
   3.5928495530705447`*^9}, 3.592851166570305*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3.1", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735180507643*^9, {3.5928495807405834`*^9, 
   3.592849581050584*^9}, 3.5928527822820687`*^9, 3.5928533604573793`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "x"}]]}], ")"}], "1"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735806675458*^9, 3.589735812957817*^9}, 
   3.5928491167229323`*^9, 3.592849235010598*^9, 3.592849287070671*^9, {
   3.592849596000605*^9, 3.592849600310611*^9}, 3.5928511747603164`*^9, {
   3.593382888244217*^9, 3.5933828932442236`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3.2", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735180507643*^9, {3.5928495836205873`*^9, 
   3.592849583930588*^9}, 3.5928527833320704`*^9, 3.5928533647673855`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "x"}]]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]]}]]}], "+", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "x"}]], "2"], "-", 
   RowBox[{"2", " ", "x"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735806675458*^9, 3.589735812957817*^9}, 
   3.5928491167229323`*^9, 3.592849235010598*^9, 3.592849287070671*^9, {
   3.592849605080618*^9, 3.5928496095006237`*^9}, 3.5928511798003235`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3.3", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735180507643*^9, {3.5928495862105913`*^9, 
   3.5928495865005913`*^9}, 3.592852784572072*^9, 3.59285336773739*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "x"}]]}], ")"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"3", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"3", " ", "x"}]]}]], "-", 
   FractionBox["3", 
    SuperscriptBox["\[ExponentialE]", "x"]], "-", 
   RowBox[{"3", " ", 
    SuperscriptBox["\[ExponentialE]", "x"]}], "+", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"3", " ", "x"}]], "3"]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735806675458*^9, 3.589735812957817*^9}, 
   3.5928491167229323`*^9, 3.592849235010598*^9, 3.592849287070671*^9, {
   3.5928496145806313`*^9, 3.592849619450638*^9}, 3.592851186680333*^9, {
   3.59338295497431*^9, 3.593382958504315*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3.4", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735180507643*^9, {3.5928495886405945`*^9, 
   3.592849588980595*^9}, 3.5928527871820755`*^9, 3.592853370477394*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "x"}]]}], ")"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"4", " ", "x"}]]}]]}], "+", 
   FractionBox["2", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "x"}]]], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "x"}]]}], "+", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"4", " ", "x"}]], "4"], "+", 
   RowBox[{"6", " ", "x"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735806675458*^9, 3.589735812957817*^9}, 
   3.5928491167229323`*^9, 3.592849235010598*^9, 3.592849287070671*^9, {
   3.592849625190646*^9, 3.5928496305906534`*^9}, 3.5928511935903425`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #3.n", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735180507643*^9, {3.5928495886405945`*^9, 
   3.592849588980595*^9}, 3.5928527871820755`*^9, 3.592853370477394*^9, {
   3.5932723848487473`*^9, 3.5932723863487496`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "x"}]]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", "x"}]]}], "+", 
         SuperscriptBox["\[ExponentialE]", "x"]}], ")"}], "n"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "x"}]]}], ")"}]}], "n"]}], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", 
     RowBox[{"1", "+", 
      FractionBox["n", "2"]}], ",", 
     RowBox[{"1", "-", 
      FractionBox["n", "2"]}], ",", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "x"}]]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735806675458*^9, 3.589735812957817*^9}, 
   3.5928491167229323`*^9, 3.592849235010598*^9, 3.592849287070671*^9, {
   3.592849625190646*^9, 3.5928496305906534`*^9}, 3.5928511935903425`*^9, {
   3.5932723942587605`*^9, 3.593272398600768*^9}, {3.5932764852810535`*^9, 
   3.5932765152010956`*^9}, 3.593373591893444*^9, {3.593382006952983*^9, 
   3.5933820101629877`*^9}, 3.5936462552463255`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #4", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735183176796*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{
         RowBox[{"-", "4"}], " ", "x"}]], "-", 
       SuperscriptBox["a", 
        RowBox[{"2", " ", "x"}]]}], ")"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"3", " ", "x"}], "-", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", 
      RowBox[{"12", " ", "x"}]], " ", 
     RowBox[{"(", 
      RowBox[{"12", " ", 
       RowBox[{"Log", "[", "a", "]"}]}], ")"}]}]], "+", 
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", 
      RowBox[{"6", " ", "x"}]], " ", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"Log", "[", "a", "]"}]}], ")"}]}]], "-", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"6", " ", "x"}]], 
    RowBox[{"6", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735824228462*^9, 3.589735833344983*^9}, 
   3.5897458306973944`*^9, 3.5928491188829355`*^9, 3.592849235010598*^9, 
   3.5928492870806713`*^9, {3.5928496458506746`*^9, 3.5928496504406815`*^9}, 
   3.5928512006803527`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5a.1", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.5928496866207323`*^9, 
   3.5928496873007326`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "+", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "1"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"k", " ", "x"}]], 
    RowBox[{"k", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"l", " ", "x"}]], 
    RowBox[{"l", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.5928497376608033`*^9, 3.5928497415308084`*^9}, 
   3.592851205470359*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5a.2", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.5928496912307386`*^9, 
   3.5928496917807393`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "+", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"2", " ", "k", " ", "x"}]], 
    RowBox[{"2", " ", "k", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"2", " ", "l", " ", "x"}]], 
    RowBox[{"2", " ", "l", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "l"}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k", "+", "l"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.5928497473708167`*^9, 3.592849752080824*^9}, 
   3.5928512097503653`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5a.3", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.592849693960742*^9, 
   3.5928496948907433`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "+", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"3", " ", "k", " ", "x"}]], 
    RowBox[{"3", " ", "k", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"3", " ", "l", " ", "x"}]], 
    RowBox[{"3", " ", "l", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "k"}], "+", "l"}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "k"}], "+", "l"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", 
         RowBox[{"2", " ", "l"}]}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k", "+", 
       RowBox[{"2", " ", "l"}]}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.5928497566108303`*^9, 3.592849760290835*^9}, 
   3.5928512157403736`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5a.4", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.592849697180747*^9, 
   3.5928496979107475`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "+", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"4", " ", "k", " ", "x"}]], 
    RowBox[{"4", " ", "k", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"4", " ", "l", " ", "x"}]], 
    RowBox[{"4", " ", "l", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"k", "+", "l"}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k", "+", "l"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "k"}], "+", "l"}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "k"}], "+", "l"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", 
         RowBox[{"3", " ", "l"}]}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k", "+", 
       RowBox[{"3", " ", "l"}]}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.5928497664608436`*^9, 3.592849772950853*^9}, 
   3.5928512220703826`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5a.n", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.592849697180747*^9, 
   3.5928496979107475`*^9}, {3.5933670536222444`*^9, 3.593367054012245*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "+", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["a", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"k", "-", "l"}], ")"}], " ", "x"}]]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", 
         RowBox[{"k", " ", "x"}]], "+", 
        SuperscriptBox["a", 
         RowBox[{"l", " ", "x"}]]}], ")"}], "n"]}], 
    RowBox[{"l", " ", "n", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"k", " ", "n"}], 
       RowBox[{"k", "-", "l"}]]}], ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"l", " ", "n"}], 
       RowBox[{"k", "-", "l"}]]}], ",", 
     RowBox[{"-", 
      SuperscriptBox["a", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"k", "-", "l"}], ")"}], " ", "x"}]]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.5928497664608436`*^9, 3.592849772950853*^9}, 
   3.5928512220703826`*^9, {3.5933670499722395`*^9, 3.5933670614822555`*^9}, 
   3.5933682021638527`*^9, 3.593368262603937*^9, 3.5933683286740294`*^9, 
   3.5938173909306707`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5b.1", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.59284969994075*^9, 
   3.592849700520751*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "-", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "1"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"k", " ", "x"}]], 
    RowBox[{"k", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "-", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"l", " ", "x"}]], 
    RowBox[{"l", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.5928497813108644`*^9, 3.5928497857908707`*^9}, 
   3.5928512274703903`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5b.2", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.5928497027907543`*^9, 
   3.5928497032507553`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "-", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"2", " ", "k", " ", "x"}]], 
    RowBox[{"2", " ", "k", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"2", " ", "l", " ", "x"}]], 
    RowBox[{"2", " ", "l", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "l"}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k", "+", "l"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.5928497903308773`*^9, 3.5928497943283825`*^9}, 
   3.5928512314903955`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5b.3", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.592849705160758*^9, 
   3.59284970649076*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "-", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"3", " ", "k", " ", "x"}]], 
    RowBox[{"3", " ", "k", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "-", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"3", " ", "l", " ", "x"}]], 
    RowBox[{"3", " ", "l", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "k"}], "+", "l"}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "k"}], "+", "l"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", 
         RowBox[{"2", " ", "l"}]}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k", "+", 
       RowBox[{"2", " ", "l"}]}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.592849800218391*^9, 3.592849804248397*^9}, 
   3.592851236690403*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5b.4", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.592849708620763*^9, 
   3.592849710090765*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "-", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"4", " ", "k", " ", "x"}]], 
    RowBox[{"4", " ", "k", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"4", " ", "l", " ", "x"}]], 
    RowBox[{"4", " ", "l", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"k", "+", "l"}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k", "+", "l"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "-", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "k"}], "+", "l"}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "k"}], "+", "l"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "-", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", 
         RowBox[{"3", " ", "l"}]}], ")"}], " ", "x"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k", "+", 
       RowBox[{"3", " ", "l"}]}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.5928498100884047`*^9, 3.592849814738411*^9}, 
   3.5928512413604097`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #5b.n", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.5897351892541437`*^9, {3.592849697180747*^9, 
   3.5928496979107475`*^9}, {3.5933670536222444`*^9, 3.593367054012245*^9}, {
   3.5933670859322896`*^9, 3.59336708622229*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"k", " ", "x"}]], "-", 
       SuperscriptBox["a", 
        RowBox[{"l", " ", "x"}]]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["a", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"k", "-", "l"}], ")"}], " ", "x"}]]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", 
         RowBox[{"k", " ", "x"}]], "-", 
        SuperscriptBox["a", 
         RowBox[{"l", " ", "x"}]]}], ")"}], "n"]}], 
    RowBox[{"l", " ", "n", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"k", " ", "n"}], 
       RowBox[{"k", "-", "l"}]]}], ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"l", " ", "n"}], 
       RowBox[{"k", "-", "l"}]]}], ",", 
     SuperscriptBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "-", "l"}], ")"}], " ", "x"}]]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358403953867`*^9, 3.5897358473527846`*^9}, 
   3.58974587187875*^9, 3.592849120742938*^9, 3.592849235020598*^9, 
   3.5928492870806713`*^9, {3.5928497664608436`*^9, 3.592849772950853*^9}, 
   3.5928512220703826`*^9, {3.5933670499722395`*^9, 3.5933671017323117`*^9}, 
   3.593368334754038*^9, {3.593817434280731*^9, 3.5938174844308014`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 6 - 9 (p. 346)", "Section"],

Cell[CellGroupData[{

Cell["Problem #6a.1", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.5928498520984635`*^9, 
   3.5928498528084645`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "1"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"m", " ", "x"}]], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.592849898956029*^9, 3.592849902976035*^9}, {3.5928512498704214`*^9, 
   3.592851251910424*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6a.2", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.592849854358467*^9, 
   3.5928498554784684`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["a", 
      RowBox[{"m", " ", "x"}]]}], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"2", " ", "m", " ", "x"}]], 
    RowBox[{"2", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.592849907186041*^9, 3.5928499122360477`*^9}, 3.5928512588904343`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6a.3", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.592849857238471*^9, 
   3.5928498581684723`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{"m", " ", "x"}]]}], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{"2", " ", "m", " ", "x"}]]}], 
    RowBox[{"2", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"3", " ", "m", " ", "x"}]], 
    RowBox[{"3", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.592849917756056*^9, 3.592849923056063*^9}, 3.592851266490445*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6a.4", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.5928498598984747`*^9, 
   3.5928498607284756`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "+", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["a", 
      RowBox[{"m", " ", "x"}]]}], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{"2", " ", "m", " ", "x"}]]}], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["a", 
      RowBox[{"3", " ", "m", " ", "x"}]]}], 
    RowBox[{"3", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"4", " ", "m", " ", "x"}]], 
    RowBox[{"4", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.5928499277760696`*^9, 3.5928499334360776`*^9}, 3.592851271170451*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6a.n", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.5928498598984747`*^9, 
   3.5928498607284756`*^9}, {3.5932724984759083`*^9, 3.5932724994459095`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["a", 
         RowBox[{"m", " ", "x"}]]}], ")"}], 
      RowBox[{"n", "+", "1"}]], " ", 
     RowBox[{"Hypergeometric2F1", "[", 
      RowBox[{"1", ",", 
       RowBox[{"n", "+", "1"}], ",", 
       RowBox[{"n", "+", "2"}], ",", 
       RowBox[{"1", "+", 
        SuperscriptBox["a", 
         RowBox[{"m", " ", "x"}]]}]}], "]"}]}], 
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.5928499277760696`*^9, 3.5928499334360776`*^9}, 3.592851271170451*^9, {
   3.5932725032059145`*^9, 3.5932725065059195`*^9}, 3.5932766228362465`*^9, 
   3.5933848352794676`*^9, {3.593454055023709*^9, 3.59345405560091*^9}, 
   3.593542869120937*^9, {3.5935429096184936`*^9, 3.5935429279085193`*^9}, 
   3.601916348374687*^9, {3.601916404864766*^9, 3.6019164158347816`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6b.1", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.592849862958479*^9, 
   3.5928498639784803`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "1"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"m", " ", "x"}]], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.5928499582361126`*^9, 3.5928499632961197`*^9}, 3.5928512862079725`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6b.2", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.592849865598482*^9, 
   3.5928498663684835`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["a", 
      RowBox[{"m", " ", "x"}]]}], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"2", " ", "m", " ", "x"}]], 
    RowBox[{"2", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.5928499676661253`*^9, 3.592849972276132*^9}, 3.592851292077981*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6b.3", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.592849869308488*^9, 
   3.592849869738488*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "3"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{"m", " ", "x"}]]}], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{"2", " ", "m", " ", "x"}]]}], 
    RowBox[{"2", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "-", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"3", " ", "m", " ", "x"}]], 
    RowBox[{"3", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.592849977146139*^9, 3.5928499810661445`*^9}, 3.5928512976679883`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6b.4", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.5928498720484915`*^9, 
   3.5928498727084923`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "4"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"x", "-", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["a", 
      RowBox[{"m", " ", "x"}]]}], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["a", 
      RowBox[{"2", " ", "m", " ", "x"}]]}], 
    RowBox[{"m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "-", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["a", 
      RowBox[{"3", " ", "m", " ", "x"}]]}], 
    RowBox[{"3", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["a", 
     RowBox[{"4", " ", "m", " ", "x"}]], 
    RowBox[{"4", " ", "m", " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.5928499861561513`*^9, 3.5928499899461565`*^9}, 3.5928513024179955`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #6b.n", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, 3.589735191971299*^9, {3.5928498720484915`*^9, 
   3.5928498727084923`*^9}, {3.593272517935935*^9, 3.5932725189959364`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["a", 
        RowBox[{"m", " ", "x"}]]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["a", 
         RowBox[{"m", " ", "x"}]]}], ")"}], 
      RowBox[{"n", "+", "1"}]], " ", 
     RowBox[{"Hypergeometric2F1", "[", 
      RowBox[{"1", ",", 
       RowBox[{"n", "+", "1"}], ",", 
       RowBox[{"n", "+", "2"}], ",", 
       RowBox[{"1", "-", 
        SuperscriptBox["a", 
         RowBox[{"m", " ", "x"}]]}]}], "]"}]}], 
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"Log", "[", "a", "]"}]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735861101571*^9, 3.5897358687520084`*^9}, 
   3.5928491232929416`*^9, 3.592849235020598*^9, 3.5928492870906715`*^9, {
   3.5928499861561513`*^9, 3.5928499899461565`*^9}, 3.5928513024179955`*^9, {
   3.593272524395944*^9, 3.593272527465948*^9}, 3.5932766351462636`*^9, 
   3.5933848647795086`*^9, {3.5934540660841284`*^9, 3.593454066614529*^9}, {
   3.5935429773760886`*^9, 3.593542989896106*^9}, 3.601916377324728*^9, {
   3.6019164192447863`*^9, 3.6019164248947945`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #7", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897351980116444`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"n", " ", "x"}]]}], "+", "b"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   FractionBox["x", "b"], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"b", "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"n", " ", "x"}]]}]}], "]"}], 
    RowBox[{"b", " ", "n"}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735875799412*^9, 3.589735883273839*^9}, 
   3.589745907987815*^9, 3.5928491253629446`*^9, 3.592849235020598*^9, 
   3.5928492870906715`*^9, {3.592849998066168*^9, 3.5928500018261733`*^9}, 
   3.5928513092780046`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #8", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352014588413`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", "x"], 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3", " ", "x"}]]}], "+", "b"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        SuperscriptBox["b", 
         RowBox[{"1", "/", "3"}]], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", 
          RowBox[{"1", "/", "3"}]], " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}]}], 
       RowBox[{
        SqrtBox["3"], " ", 
        SuperscriptBox["b", 
         RowBox[{"1", "/", "3"}]]}]], "]"}], 
     RowBox[{
      SqrtBox["3"], " ", 
      SuperscriptBox["a", 
       RowBox[{"1", "/", "3"}]], " ", 
      SuperscriptBox["b", 
       RowBox[{"2", "/", "3"}]]}]]}], "+", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["b", 
       RowBox[{"1", "/", "3"}]], "+", 
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"1", "/", "3"}]], " ", 
       SuperscriptBox["\[ExponentialE]", "x"]}]}], "]"}], 
    RowBox[{"2", " ", 
     SuperscriptBox["a", 
      RowBox[{"1", "/", "3"}]], " ", 
     SuperscriptBox["b", 
      RowBox[{"2", "/", "3"}]]}]], "-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"b", "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3", " ", "x"}]]}]}], "]"}], 
    RowBox[{"6", " ", 
     SuperscriptBox["a", 
      RowBox[{"1", "/", "3"}]], " ", 
     SuperscriptBox["b", 
      RowBox[{"2", "/", "3"}]]}]]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897358977836695`*^9, 3.5897359043440447`*^9}, 
   3.589745935768404*^9, 3.592849127632948*^9, 3.5928492350305977`*^9, 
   3.5928492871006713`*^9, {3.592850005806179*^9, 3.592850010186185*^9}, 
   3.5928513140780115`*^9, 3.593273040269167*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #9", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.5897352082782316`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], "-", "1"}], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", "x"]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735911115432*^9, 3.5897359184888535`*^9}, 
   3.59284912952295*^9, 3.5928492350305977`*^9, 3.5928492871006713`*^9, {
   3.592850015866193*^9, 3.5928500198961987`*^9}, 3.5928513192480187`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Problems 10 - 16 (p. 347)", "Section"],

Cell[CellGroupData[{

Cell["Problem #10", "Subsection",
 CellChangeTimes->{
  3.5897351492628565`*^9, {3.5897352082782316`*^9, 3.589735227059306*^9}, 
   3.5897352747240324`*^9, 3.5897353868764467`*^9, 3.589735440337505*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"4", " ", "x"}]], 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", " ", "x"}]]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "x"}]]}], "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "x"}]]}]}], 
       SqrtBox["2"]], "]"}], 
     RowBox[{"6", " ", 
      SqrtBox["2"]}]]}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "x"}]]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"4", " ", "x"}]]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897359253942485`*^9, 3.5897359322616415`*^9}, 
   3.5928491417929673`*^9, 3.5928492350305977`*^9, 3.592849287110671*^9, 
   3.5928504717818317`*^9, 3.5928513341780396`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #11", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.5897351770144434`*^9}, 
   3.5928493401907454`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"5", " ", "x"}]], "+", 
      SuperscriptBox["\[ExponentialE]", "x"]}], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", " ", "x"}]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], "+", 
      SuperscriptBox["\[ExponentialE]", "x"], "-", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], "+", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "x"}]], "2"], "-", 
   RowBox[{"ArcTan", "[", 
    SuperscriptBox["\[ExponentialE]", "x"], "]"}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     SuperscriptBox["\[ExponentialE]", "x"]}], "]"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.5897357750056467`*^9, 3.5897357825560784`*^9}, {
   3.5897480311882553`*^9, 3.589748034262431*^9}, {3.592849106792918*^9, 
   3.592849107352919*^9}, {3.592849220010577*^9, 3.5928492233605814`*^9}, {
   3.5928492548706255`*^9, 3.5928492709706483`*^9}, 3.592849331320733*^9, 
   3.592850490771858*^9, 3.592851338678046*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #12", "Subsection",
 CellChangeTimes->{{3.5897351492628565`*^9, 3.589735178594534*^9}, 
   3.5928493429727507`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"n", " ", "x"}]]}]}], ")"}], 
     RowBox[{"r", "/", "s"}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", "x"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  FractionBox[
   RowBox[{"s", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"n", " ", "x"}]]}]}], ")"}], 
     FractionBox[
      RowBox[{"s", "+", "r"}], "s"]]}], 
   RowBox[{"b", " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"s", "+", "r"}], ")"}]}]]}]], "Input",
 CellChangeTimes->{
  3.5782785945807524`*^9, {3.5782787749410048`*^9, 3.578278801901043*^9}, {
   3.5792818464177885`*^9, 3.579281848430192*^9}, {3.579281976880818*^9, 
   3.5792819846496315`*^9}, 3.5792826376823783`*^9, 3.5792829373061037`*^9, {
   3.588701127842044*^9, 3.5887011406845627`*^9}, {3.5897340167320795`*^9, 
   3.589734023076442*^9}, {3.589735791722603*^9, 3.589735797988961*^9}, {
   3.589748038150654*^9, 3.5897480409278126`*^9}, 3.5928491149129295`*^9, 
   3.592849235000598*^9, 3.592849287060671*^9, 3.592850496991867*^9, 
   3.59285134864806*^9, {3.5932732982520285`*^9, 3.59327332091206*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Problem #13", "Subsection",
 CellChangeTimes->{3.5897351492628565`*^9, 3.589735180507643*^9, 
  3.5928493444627523`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"x", "/", "3"}]]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"12", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"x", "/", "3"}]]}]}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], "-", 
   RowBox[{"6", " ", 
    RowBox[{"ArcTan", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
  